/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.hsbt.mvc.HtmxHandlerInterceptor;
import io.github.wimdeblauwe.hsbt.mvc.HtmxHandlerMethodArgumentResolver;
import io.github.wimdeblauwe.hsbt.mvc.HtmxRequestMappingHandlerMapping;
import io.github.wimdeblauwe.hsbt.mvc.HtmxViewHandlerInterceptor;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.util.Assert;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@AutoConfiguration
@ConditionalOnWebApplication
public class HtmxMvcConfiguration
implements WebMvcRegistrations,
WebMvcConfigurer {
    private final ObjectFactory<ViewResolver> resolver;
    private final ObjectFactory<LocaleResolver> locales;
    private final ObjectMapper objectMapper;

    HtmxMvcConfiguration(@Qualifier(value="viewResolver") ObjectFactory<ViewResolver> resolver, ObjectFactory<LocaleResolver> locales, ObjectMapper objectMapper) {
        Assert.notNull(resolver, (String)"ViewResolver must not be null!");
        Assert.notNull(locales, (String)"LocaleResolver must not be null!");
        this.resolver = resolver;
        this.locales = locales;
        this.objectMapper = objectMapper;
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new HtmxRequestMappingHandlerMapping();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HtmxHandlerInterceptor());
        registry.addInterceptor((HandlerInterceptor)new HtmxViewHandlerInterceptor((ViewResolver)this.resolver.getObject(), this.locales, this.objectMapper));
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new HtmxHandlerMethodArgumentResolver());
    }
}

