/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import io.github.wimdeblauwe.hsbt.mvc.HxSwapType;
import io.github.wimdeblauwe.hsbt.mvc.HxTriggerLifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public final class HtmxResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HtmxResponse.class);
    private final Set<ModelAndView> templates = new LinkedHashSet<ModelAndView>();
    private final Map<String, String> triggers = new HashMap<String, String>();
    private final Map<String, String> triggersAfterSettle = new HashMap<String, String>();
    private final Map<String, String> triggersAfterSwap = new HashMap<String, String>();
    private String headerRetarget;
    private boolean headerRefresh;
    private String headerRedirect;
    private String headerPushHistory;
    private String headerReswap;

    public HtmxResponse addTemplate(String template) {
        Assert.hasText((String)template, (String)"template should not be blank");
        if (!this.templates.stream().anyMatch(mav -> template.equals(mav.getViewName()))) {
            this.templates.add(new ModelAndView(template));
        }
        return this;
    }

    public HtmxResponse addTemplate(View template) {
        Assert.notNull((Object)template, (String)"template should not be null");
        if (!this.templates.stream().anyMatch(mav -> template.equals(mav.getView()))) {
            this.templates.add(new ModelAndView(template));
        }
        return this;
    }

    public HtmxResponse addTemplate(ModelAndView template) {
        Assert.notNull((Object)template, (String)"template should not be null");
        this.templates.add(template);
        return this;
    }

    public HtmxResponse addTrigger(String eventName) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        return this.addTrigger(eventName, null, HxTriggerLifecycle.RECEIVE);
    }

    public HtmxResponse addTrigger(String eventName, String eventDetail, HxTriggerLifecycle step) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        switch (step) {
            case RECEIVE: {
                this.triggers.put(eventName, eventDetail);
                break;
            }
            case SETTLE: {
                this.triggersAfterSettle.put(eventName, eventDetail);
                break;
            }
            case SWAP: {
                this.triggersAfterSwap.put(eventName, eventDetail);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown step " + step);
            }
        }
        return this;
    }

    public HtmxResponse pushHistory(String url) {
        Assert.hasText((String)url, (String)"url should not be blank");
        this.headerPushHistory = url;
        return this;
    }

    public HtmxResponse browserRedirect(String url) {
        Assert.hasText((String)url, (String)"url should not be blank");
        this.headerRedirect = url;
        return this;
    }

    public HtmxResponse browserRefresh(boolean refresh) {
        this.headerRefresh = refresh;
        return this;
    }

    public HtmxResponse retarget(String cssSelector) {
        Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
        this.headerRetarget = cssSelector;
        return this;
    }

    public HtmxResponse reswap(HxSwapType swapType) {
        Assert.notNull((Object)((Object)swapType), (String)"swapType should not be null");
        this.headerReswap = swapType.getValue();
        return this;
    }

    public HtmxResponse and(HtmxResponse otherResponse) {
        otherResponse.templates.forEach(otherTemplate -> {
            if (this.templates.stream().anyMatch(mav -> this.same((ModelAndView)otherTemplate, (ModelAndView)mav))) {
                LOG.info("Duplicate template '{}' found while merging HtmxResponse", otherTemplate);
            } else {
                this.templates.add((ModelAndView)otherTemplate);
            }
        });
        this.mergeMapAndLog(HxTriggerLifecycle.RECEIVE, this.triggers, otherResponse.triggers);
        this.mergeMapAndLog(HxTriggerLifecycle.SETTLE, this.triggersAfterSettle, otherResponse.triggersAfterSettle);
        this.mergeMapAndLog(HxTriggerLifecycle.SWAP, this.triggersAfterSwap, otherResponse.triggersAfterSwap);
        if (otherResponse.getHeaderPushHistory() != null) {
            this.headerPushHistory = otherResponse.getHeaderPushHistory();
        }
        if (otherResponse.getHeaderRedirect() != null) {
            this.headerRedirect = otherResponse.getHeaderRedirect();
        }
        if (otherResponse.getHeaderRefresh()) {
            this.headerRefresh = true;
        }
        if (otherResponse.getHeaderRedirect() != null) {
            this.headerRedirect = otherResponse.getHeaderRedirect();
        }
        if (otherResponse.getHeaderReswap() != null) {
            this.headerReswap = otherResponse.getHeaderReswap();
        }
        return this;
    }

    private boolean same(ModelAndView one, ModelAndView two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.getViewName() != null && one.getViewName().equals(two.getViewName())) {
            return true;
        }
        return one.getView() != null && one.getView().equals(two.getView());
    }

    private void mergeMapAndLog(HxTriggerLifecycle receive, Map<String, String> triggers, Map<String, String> otherTriggers) {
        otherTriggers.forEach((key, value) -> {
            if (LOG.isInfoEnabled() && triggers.containsKey(key)) {
                String matchingTrigger = (String)triggers.get(key);
                LOG.info("Duplicate {} entry: event '{}' details '{}' will be overwritten by with '{}'", new Object[]{receive.getHeaderName(), key, matchingTrigger, value});
            }
            triggers.put((String)key, (String)value);
        });
    }

    Collection<ModelAndView> getTemplates() {
        return Collections.unmodifiableCollection(this.templates);
    }

    Map<String, String> getTriggers() {
        if (this.triggers.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.triggers);
    }

    Map<String, String> getTriggersAfterSettle() {
        if (this.triggers.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.triggersAfterSettle);
    }

    Map<String, String> getTriggersAfterSwap() {
        if (this.triggers.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.triggersAfterSwap);
    }

    String getHeaderRetarget() {
        return this.headerRetarget;
    }

    boolean getHeaderRefresh() {
        return this.headerRefresh;
    }

    String getHeaderRedirect() {
        return this.headerRedirect;
    }

    String getHeaderPushHistory() {
        return this.headerPushHistory;
    }

    public String getHeaderReswap() {
        return this.headerReswap;
    }
}

