/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.hsbt.mvc.HtmxResponse;
import io.github.wimdeblauwe.hsbt.mvc.HtmxResponseHeader;
import io.github.wimdeblauwe.hsbt.mvc.HxTriggerLifecycle;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.ContentCachingResponseWrapper;

class HtmxViewHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(HtmxViewHandlerInterceptor.class);
    private final ViewResolver views;
    private final ObjectFactory<LocaleResolver> locales;
    private final ObjectMapper objectMapper;

    public HtmxViewHandlerInterceptor(ViewResolver views, ObjectFactory<LocaleResolver> locales, ObjectMapper objectMapper) {
        this.views = views;
        this.locales = locales;
        this.objectMapper = objectMapper;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null || !HandlerMethod.class.isInstance(handler)) {
            return;
        }
        HandlerMethod method = (HandlerMethod)handler;
        String partialsAttributeName = null;
        if (method.getReturnType().getParameterType().equals(HtmxResponse.class)) {
            partialsAttributeName = "htmxResponse";
        }
        if (partialsAttributeName == null) {
            return;
        }
        Object attribute = modelAndView.getModel().get(partialsAttributeName);
        if (!HtmxResponse.class.isInstance(attribute)) {
            return;
        }
        HtmxResponse htmxResponse = (HtmxResponse)attribute;
        modelAndView.setView(this.toView(htmxResponse));
        this.addHxHeaders(htmxResponse, response);
    }

    private void addHxHeaders(HtmxResponse htmxResponse, HttpServletResponse response) {
        this.setTriggerHeader(HxTriggerLifecycle.RECEIVE, htmxResponse.getTriggers(), response);
        this.setTriggerHeader(HxTriggerLifecycle.SETTLE, htmxResponse.getTriggersAfterSettle(), response);
        this.setTriggerHeader(HxTriggerLifecycle.SWAP, htmxResponse.getTriggersAfterSwap(), response);
        if (htmxResponse.getHeaderPushHistory() != null) {
            response.setHeader(HtmxResponseHeader.HX_PUSH.getValue(), htmxResponse.getHeaderPushHistory());
        }
        if (htmxResponse.getHeaderRedirect() != null) {
            response.setHeader(HtmxResponseHeader.HX_REDIRECT.getValue(), htmxResponse.getHeaderRedirect());
        }
        if (htmxResponse.getHeaderRefresh()) {
            response.setHeader(HtmxResponseHeader.HX_REFRESH.getValue(), "true");
        }
        if (htmxResponse.getHeaderRetarget() != null) {
            response.setHeader(HtmxResponseHeader.HX_RETARGET.getValue(), htmxResponse.getHeaderRetarget());
        }
        if (htmxResponse.getHeaderReswap() != null) {
            response.setHeader(HtmxResponseHeader.HX_RESWAP.getValue(), htmxResponse.getHeaderReswap());
        }
    }

    private void setTriggerHeader(HxTriggerLifecycle triggerHeader, Map<String, String> triggers, HttpServletResponse response) {
        if (triggers.isEmpty()) {
            return;
        }
        if (triggers.size() == 1) {
            Map.Entry singleHeader = (Map.Entry)triggers.entrySet().stream().findFirst().orElseThrow();
            if (singleHeader.getValue() == null || ((String)singleHeader.getValue()).isBlank()) {
                response.setHeader(triggerHeader.getHeaderName(), (String)singleHeader.getKey());
            } else {
                try {
                    response.setHeader(triggerHeader.getHeaderName(), this.objectMapper.writeValueAsString(triggers));
                }
                catch (Exception e) {
                    LOG.warn("Unable to set header {} to {}", new Object[]{triggerHeader.getHeaderName(), triggers, e});
                }
            }
        } else {
            try {
                response.setHeader(triggerHeader.getHeaderName(), this.objectMapper.writeValueAsString(triggers));
            }
            catch (Exception e) {
                LOG.warn("Unable to set header {} to {}", new Object[]{triggerHeader.getHeaderName(), triggers, e});
            }
        }
    }

    private View toView(HtmxResponse partials) {
        Assert.notNull((Object)partials, (String)"HtmxPartials must not be null!");
        return (model, request, response) -> {
            Locale locale = ((LocaleResolver)this.locales.getObject()).resolveLocale(request);
            ContentCachingResponseWrapper wrapper = new ContentCachingResponseWrapper(response);
            for (ModelAndView template : partials.getTemplates()) {
                View view = template.getView();
                if (view == null) {
                    view = this.views.resolveViewName(template.getViewName(), locale);
                }
                for (String key : model.keySet()) {
                    if (template.getModel().containsKey(key)) continue;
                    template.getModel().put(key, model.get(key));
                }
                Assert.notNull((Object)view, (String)("Template '" + template + "' could not be resolved"));
                view.render(template.getModel(), request, (HttpServletResponse)wrapper);
            }
            wrapper.copyBodyToResponse();
        };
    }
}

