/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.thymeleaf;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.hsbt.mvc.HtmxSpringStandardExressionObjectFactory;
import io.github.wimdeblauwe.hsbt.thymeleaf.HtmxAttributeProcessor;
import java.util.HashSet;
import java.util.Set;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;

public class HtmxDialect
extends AbstractProcessorDialect
implements IExpressionObjectDialect {
    private HtmxSpringStandardExressionObjectFactory expressionObjectFactory;
    private final ObjectMapper mapper;

    public HtmxDialect(ObjectMapper mapper) {
        super("Htmx", "hx", 1000);
        this.mapper = mapper;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        HashSet<IProcessor> htmxProcessors = new HashSet<IProcessor>();
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "boost", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "confirm", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "delete", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "disable", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "disinherit", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "encoding", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "ext", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "get", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "headers", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "history-elt", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "include", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "indicator", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "params", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "patch", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "post", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "preserve", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "prompt", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "put", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "push-url", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "request", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "select", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "swap", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "swap-oob", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "sync", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "target", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "trigger", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "validate", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "vals", this.mapper));
        htmxProcessors.add((IProcessor)new HtmxAttributeProcessor(dialectPrefix, "vars", this.mapper));
        return htmxProcessors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        if (this.expressionObjectFactory == null) {
            this.expressionObjectFactory = new HtmxSpringStandardExressionObjectFactory();
        }
        return this.expressionObjectFactory;
    }
}

