/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.thymeleaf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public class HtmxAttributeProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 1000;
    private final String attrName;
    private final ObjectMapper mapper;
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private AttributeDefinition targetAttributeDefinition;

    public HtmxAttributeProcessor(String dialectPrefix, String attrName, ObjectMapper mapper) {
        super(TEMPLATE_MODE, dialectPrefix, attrName, 1000, false, true);
        this.attrName = attrName;
        this.mapper = mapper;
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, this.attrName);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        if (expressionResult == null) {
            structureHandler.removeAttribute(attributeName);
        } else {
            String expressionResultString;
            if (expressionResult instanceof LinkedHashMap) {
                try {
                    expressionResultString = this.mapper.writeValueAsString(expressionResult);
                }
                catch (JsonProcessingException e) {
                    throw new TemplateProcessingException("Exception writing map", tag.getTemplateName(), tag.getLine(), tag.getLine(), (Throwable)e);
                }
            } else {
                expressionResultString = expressionResult.toString();
            }
            String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)expressionResultString);
            newAttributeValue = RequestDataValueProcessorUtils.processUrl((ITemplateContext)context, (String)newAttributeValue);
            StandardProcessorUtils.replaceAttribute((IElementTagStructureHandler)structureHandler, (AttributeName)attributeName, (AttributeDefinition)this.targetAttributeDefinition, (String)("hx-" + this.attrName), (String)(newAttributeValue == null ? "" : newAttributeValue));
        }
    }
}

