/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxLocation;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxTrigger;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxSwapType;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerLifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public final class HtmxResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmxResponse.class);
    private final Set<ModelAndView> views;
    private final Set<HtmxTrigger> triggers;
    private final Set<HtmxTrigger> triggersAfterSettle;
    private final Set<HtmxTrigger> triggersAfterSwap;
    private final String replaceUrl;
    private final String reselect;
    private String retarget;
    private boolean refresh;
    private String redirect;
    private String pushUrl;
    private HtmxReswap reswap;
    private HtmxLocation location;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public HtmxResponse() {
        this.views = new LinkedHashSet<ModelAndView>();
        this.triggers = new LinkedHashSet<HtmxTrigger>();
        this.triggersAfterSettle = new LinkedHashSet<HtmxTrigger>();
        this.triggersAfterSwap = new LinkedHashSet<HtmxTrigger>();
        this.replaceUrl = null;
        this.reselect = null;
    }

    HtmxResponse(Set<ModelAndView> views, Set<HtmxTrigger> triggers, Set<HtmxTrigger> triggersAfterSettle, Set<HtmxTrigger> triggersAfterSwap, String retarget, boolean refresh, String redirect, String pushUrl, String replaceUrl, String reselect, HtmxReswap reswap, HtmxLocation location) {
        this.views = views;
        this.triggers = triggers;
        this.triggersAfterSettle = triggersAfterSettle;
        this.triggersAfterSwap = triggersAfterSwap;
        this.retarget = retarget;
        this.refresh = refresh;
        this.redirect = redirect;
        this.pushUrl = pushUrl;
        this.replaceUrl = replaceUrl;
        this.reselect = reselect;
        this.reswap = reswap;
        this.location = location;
    }

    @Deprecated
    public HtmxResponse addTemplate(String template) {
        Assert.hasText((String)template, (String)"template should not be blank");
        if (!this.views.stream().anyMatch(mav -> template.equals(mav.getViewName()))) {
            this.views.add(new ModelAndView(template));
        }
        return this;
    }

    @Deprecated
    public HtmxResponse addTemplate(View template) {
        Assert.notNull((Object)template, (String)"template should not be null");
        if (!this.views.stream().anyMatch(mav -> template.equals(mav.getView()))) {
            this.views.add(new ModelAndView(template));
        }
        return this;
    }

    @Deprecated
    public HtmxResponse addTemplate(ModelAndView template) {
        Assert.notNull((Object)template, (String)"template should not be null");
        this.views.add(template);
        return this;
    }

    @Deprecated
    public HtmxResponse addTrigger(String eventName) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        return this.addTrigger(eventName, null, HxTriggerLifecycle.RECEIVE);
    }

    @Deprecated
    public HtmxResponse addTrigger(String eventName, String eventDetail, HxTriggerLifecycle step) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        switch (step) {
            case RECEIVE: {
                this.triggers.add(new HtmxTrigger(eventName, eventDetail));
                break;
            }
            case SETTLE: {
                this.triggersAfterSettle.add(new HtmxTrigger(eventName, eventDetail));
                break;
            }
            case SWAP: {
                this.triggersAfterSwap.add(new HtmxTrigger(eventName, eventDetail));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown step " + step);
            }
        }
        return this;
    }

    @Deprecated
    public HtmxResponse pushHistory(String url) {
        Assert.hasText((String)url, (String)"url should not be blank");
        this.pushUrl = url;
        return this;
    }

    @Deprecated
    public HtmxResponse browserRedirect(String url) {
        Assert.hasText((String)url, (String)"url should not be blank");
        this.redirect = url;
        return this;
    }

    @Deprecated
    public HtmxResponse browserRefresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    @Deprecated
    public HtmxResponse retarget(String cssSelector) {
        Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
        this.retarget = cssSelector;
        return this;
    }

    @Deprecated
    public HtmxResponse reswap(HxSwapType swapType) {
        Assert.notNull((Object)((Object)swapType), (String)"swapType should not be null");
        this.reswap = new HtmxReswap(swapType);
        return this;
    }

    @Deprecated
    public HtmxResponse and(HtmxResponse otherResponse) {
        otherResponse.views.forEach(otherTemplate -> {
            if (this.views.stream().anyMatch(mav -> Builder.same(otherTemplate, mav))) {
                LOGGER.warn("Duplicate template '{}' found while merging HtmxResponse", otherTemplate);
            } else {
                this.views.add((ModelAndView)otherTemplate);
            }
        });
        Builder.mergeTriggers(this.triggers, otherResponse.triggers);
        Builder.mergeTriggers(this.triggersAfterSettle, otherResponse.triggersAfterSettle);
        Builder.mergeTriggers(this.triggersAfterSwap, otherResponse.triggersAfterSwap);
        if (otherResponse.getPushUrl() != null) {
            this.pushUrl = otherResponse.getPushUrl();
        }
        if (otherResponse.getRedirect() != null) {
            this.redirect = otherResponse.getRedirect();
        }
        if (otherResponse.isRefresh()) {
            this.refresh = true;
        }
        if (otherResponse.getRetarget() != null) {
            this.retarget = otherResponse.getRetarget();
        }
        if (otherResponse.getReswap() != null) {
            this.reswap = otherResponse.reswap;
        }
        return this;
    }

    @Deprecated
    String getHeaderRetarget() {
        return this.retarget;
    }

    @Deprecated
    boolean getHeaderRefresh() {
        return this.refresh;
    }

    @Deprecated
    String getHeaderRedirect() {
        return this.redirect;
    }

    @Deprecated
    String getHeaderPushHistory() {
        return this.pushUrl;
    }

    @Deprecated
    public String getHeaderReswap() {
        return this.reswap != null ? this.reswap.getType().getValue() : null;
    }

    @Deprecated
    public Collection<ModelAndView> getTemplates() {
        return Collections.unmodifiableCollection(this.views);
    }

    public HtmxLocation getLocation() {
        return this.location;
    }

    public String getPushUrl() {
        return this.pushUrl;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getReplaceUrl() {
        return this.replaceUrl;
    }

    public String getReselect() {
        return this.reselect;
    }

    public HtmxReswap getReswap() {
        return this.reswap;
    }

    public String getRetarget() {
        return this.retarget;
    }

    public Map<String, String> getTriggers() {
        return this.getTriggersAsMap(this.triggers);
    }

    Collection<HtmxTrigger> getTriggersInternal() {
        return Collections.unmodifiableCollection(this.triggers);
    }

    public Map<String, String> getTriggersAfterSettle() {
        return this.getTriggersAsMap(this.triggersAfterSettle);
    }

    Collection<HtmxTrigger> getTriggersAfterSettleInternal() {
        return Collections.unmodifiableCollection(this.triggersAfterSettle);
    }

    public Map<String, String> getTriggersAfterSwap() {
        return this.getTriggersAsMap(this.triggersAfterSwap);
    }

    Collection<HtmxTrigger> getTriggersAfterSwapInternal() {
        return Collections.unmodifiableCollection(this.triggersAfterSwap);
    }

    public Collection<ModelAndView> getViews() {
        return Collections.unmodifiableCollection(this.views);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    @Deprecated
    private Map<String, String> getTriggersAsMap(Collection<HtmxTrigger> triggers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (HtmxTrigger trigger : triggers) {
            map.put(trigger.getEventName(), Objects.toString(trigger.getEventDetail(), null));
        }
        return Collections.unmodifiableMap(map);
    }

    public static final class Builder {
        private Set<ModelAndView> views = new LinkedHashSet<ModelAndView>();
        private Set<HtmxTrigger> triggers = new LinkedHashSet<HtmxTrigger>();
        private Set<HtmxTrigger> triggersAfterSettle = new LinkedHashSet<HtmxTrigger>();
        private Set<HtmxTrigger> triggersAfterSwap = new LinkedHashSet<HtmxTrigger>();
        private HtmxLocation location;
        private String pushUrl;
        private String redirect;
        private boolean refresh;
        private String replaceUrl;
        private HtmxReswap reswap;
        private String retarget;
        private String reselect;

        public Builder and(HtmxResponse otherResponse) {
            otherResponse.views.forEach(otherTemplate -> {
                if (this.views.stream().anyMatch(mav -> Builder.same(otherTemplate, mav))) {
                    LOGGER.warn("Duplicate template '{}' found while merging HtmxResponse", otherTemplate);
                } else {
                    this.views.add((ModelAndView)otherTemplate);
                }
            });
            Builder.mergeTriggers(this.triggers, otherResponse.triggers);
            Builder.mergeTriggers(this.triggersAfterSettle, otherResponse.triggersAfterSettle);
            Builder.mergeTriggers(this.triggersAfterSwap, otherResponse.triggersAfterSwap);
            if (otherResponse.pushUrl != null) {
                this.pushUrl = otherResponse.pushUrl;
            }
            if (otherResponse.redirect != null) {
                this.redirect = otherResponse.redirect;
            }
            if (otherResponse.refresh) {
                this.refresh = true;
            }
            if (otherResponse.retarget != null) {
                this.retarget = otherResponse.retarget;
            }
            if (otherResponse.reswap != null) {
                this.reswap = otherResponse.reswap;
            }
            return this;
        }

        public HtmxResponse build() {
            return new HtmxResponse(this.views, this.triggers, this.triggersAfterSettle, this.triggersAfterSwap, this.retarget, this.refresh, this.redirect, this.pushUrl, this.replaceUrl, this.reselect, this.reswap, this.location);
        }

        public Builder location(String path) {
            this.location = new HtmxLocation(path);
            return this;
        }

        public Builder location(HtmxLocation location) {
            this.location = location;
            return this;
        }

        public Builder preventHistoryUpdate() {
            this.pushUrl = "false";
            this.replaceUrl = null;
            return this;
        }

        public Builder pushUrl(String url) {
            Assert.hasText((String)url, (String)"url should not be blank");
            this.pushUrl = url;
            this.replaceUrl = null;
            return this;
        }

        public Builder redirect(String url) {
            Assert.hasText((String)url, (String)"url should not be blank");
            this.redirect = url;
            return this;
        }

        public Builder refresh() {
            this.refresh = true;
            return this;
        }

        public Builder replaceUrl(String url) {
            this.replaceUrl = url;
            this.pushUrl = null;
            return this;
        }

        public Builder reswap(HtmxReswap reswap) {
            Assert.notNull((Object)reswap, (String)"reswap should not be null");
            this.reswap = reswap;
            return this;
        }

        public Builder retarget(String cssSelector) {
            Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
            this.retarget = cssSelector;
            return this;
        }

        public Builder reselect(String cssSelector) {
            Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
            this.reselect = cssSelector;
            return this;
        }

        public Builder trigger(String eventName) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            return this.trigger(eventName, null);
        }

        public Builder trigger(String eventName, Object eventDetail) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            this.triggers.add(new HtmxTrigger(eventName, eventDetail));
            return this;
        }

        public Builder triggerAfterSettle(String eventName) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            return this.triggerAfterSettle(eventName, null);
        }

        public Builder triggerAfterSettle(String eventName, Object eventDetail) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            this.triggersAfterSettle.add(new HtmxTrigger(eventName, eventDetail));
            return this;
        }

        public Builder triggerAfterSwap(String eventName) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            return this.triggerAfterSwap(eventName, null);
        }

        public Builder triggerAfterSwap(String eventName, Object eventDetail) {
            Assert.hasText((String)eventName, (String)"eventName should not be blank");
            this.triggersAfterSwap.add(new HtmxTrigger(eventName, eventDetail));
            return this;
        }

        public Builder view(String viewName) {
            Assert.hasText((String)viewName, (String)"viewName should not be blank");
            if (!this.views.stream().anyMatch(mav -> viewName.equals(mav.getViewName()))) {
                this.views.add(new ModelAndView(viewName));
            }
            return this;
        }

        public Builder view(View view) {
            Assert.notNull((Object)view, (String)"view should not be null");
            if (!this.views.stream().anyMatch(mav -> view.equals(mav.getView()))) {
                this.views.add(new ModelAndView(view));
            }
            return this;
        }

        public Builder view(ModelAndView modelAndView) {
            Assert.notNull((Object)modelAndView, (String)"modelAndView should not be null");
            this.views.add(modelAndView);
            return this;
        }

        private static void mergeTriggers(Collection<HtmxTrigger> triggers, Collection<HtmxTrigger> otherTriggers) {
            for (HtmxTrigger otherTrigger : otherTriggers) {
                Optional<HtmxTrigger> otrigger;
                if (LOGGER.isWarnEnabled() && (otrigger = triggers.stream().filter(t -> t.getEventName().equals(otherTrigger.getEventName())).findFirst()).isPresent()) {
                    LOGGER.warn("Duplicate trigger event '{}' found. Details '{}' will be overwritten by with '{}'", new Object[]{otherTrigger.getEventName(), otrigger.get().getEventDetail(), otherTrigger.getEventDetail()});
                }
                triggers.add(otherTrigger);
            }
        }

        private static boolean same(ModelAndView one, ModelAndView two) {
            if (one == two) {
                return true;
            }
            if (one == null || two == null) {
                return false;
            }
            if (one.getViewName() != null && one.getViewName().equals(two.getViewName())) {
                return true;
            }
            return one.getView() != null && one.getView().equals(two.getView());
        }
    }
}

