/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HtmxLocation {
    private String path;
    private String source;
    private String event;
    private String handler;
    private String target;
    private String swap;
    private Map<String, Object> values;
    private Map<String, String> headers;

    public HtmxLocation() {
    }

    public HtmxLocation(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmxLocation location = (HtmxLocation)o;
        return Objects.equals(this.path, location.path) && Objects.equals(this.source, location.source) && Objects.equals(this.event, location.event) && Objects.equals(this.handler, location.handler) && Objects.equals(this.target, location.target) && Objects.equals(this.swap, location.swap) && Objects.equals(this.values, location.values) && Objects.equals(this.headers, location.headers);
    }

    public String getEvent() {
        return this.event;
    }

    public String getHandler() {
        return this.handler;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getPath() {
        return this.path;
    }

    public String getSource() {
        return this.source;
    }

    public String getSwap() {
        return this.swap;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public boolean hasContextData() {
        return this.source != null || this.event != null || this.handler != null || this.target != null || this.swap != null || !CollectionUtils.isEmpty(this.values) || !CollectionUtils.isEmpty(this.headers);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.source, this.event, this.handler, this.target, this.swap, this.values, this.headers);
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSwap(String swap) {
        this.swap = swap;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }
}

