/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequest;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class HtmxHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(HtmxRequest.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return HtmxHandlerMethodArgumentResolver.createHtmxRequest(Objects.requireNonNull((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)));
    }

    public static HtmxRequest createHtmxRequest(HttpServletRequest request) {
        String hxRequestHeader = request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue());
        if (hxRequestHeader == null) {
            return HtmxRequest.empty();
        }
        HtmxRequest.Builder builder = HtmxRequest.builder();
        if (request.getHeader(HtmxRequestHeader.HX_BOOSTED.getValue()) != null) {
            builder.boosted(true);
        }
        if (request.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()) != null) {
            builder.currentUrl(request.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_HISTORY_RESTORE_REQUEST.getValue()) != null) {
            builder.historyRestoreRequest(true);
        }
        if (request.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()) != null) {
            builder.promptResponse(request.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TARGET.getValue()) != null) {
            builder.target(request.getHeader(HtmxRequestHeader.HX_TARGET.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()) != null) {
            builder.triggerName(request.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()) != null) {
            builder.triggerId(request.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()));
        }
        return builder.build();
    }
}

