/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxLocation;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponse;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHandlerMethodReturnValueHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxLocation;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxPushUrl;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxRedirect;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxRefresh;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReplaceUrl;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReselect;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxRetarget;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTrigger;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerAfterSettle;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerAfterSwap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerLifecycle;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class HtmxHandlerInterceptor
implements HandlerInterceptor {
    private final ObjectMapper objectMapper;
    private final HtmxResponseHandlerMethodReturnValueHandler htmxResponseHandlerMethodReturnValueHandler;

    public HtmxHandlerInterceptor(ObjectMapper objectMapper, HtmxResponseHandlerMethodReturnValueHandler htmxResponseHandlerMethodReturnValueHandler) {
        this.objectMapper = objectMapper;
        this.htmxResponseHandlerMethodReturnValueHandler = htmxResponseHandlerMethodReturnValueHandler;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            modelAndView.getModel().values().forEach(value -> {
                if (value instanceof HtmxResponse) {
                    this.buildAndRender((HtmxResponse)value, modelAndView, request, response);
                } else if (value instanceof HtmxResponse.Builder) {
                    this.buildAndRender(((HtmxResponse.Builder)value).build(), modelAndView, request, response);
                }
            });
        }
    }

    private void buildAndRender(HtmxResponse htmxResponse, ModelAndView mav, HttpServletRequest request, HttpServletResponse response) {
        View v = this.htmxResponseHandlerMethodReturnValueHandler.toView(htmxResponse);
        try {
            v.render(mav.getModel(), request, response);
            this.htmxResponseHandlerMethodReturnValueHandler.addHxHeaders(htmxResponse, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            this.setHxLocation(response, method);
            this.setHxPushUrl(response, method);
            this.setHxRedirect(response, method);
            this.setHxReplaceUrl(response, method);
            this.setHxReswap(response, method);
            this.setHxRetarget(response, method);
            this.setHxReselect(response, method);
            this.setHxTrigger(response, method);
            this.setHxTriggerAfterSettle(response, method);
            this.setHxTriggerAfterSwap(response, method);
            this.setHxRefresh(response, method);
            this.setVary(request, response);
        }
        return true;
    }

    private void setVary(HttpServletRequest request, HttpServletResponse response) {
        if (request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue()) != null) {
            response.addHeader("Vary", HtmxRequestHeader.HX_REQUEST.getValue());
        }
    }

    private void setHxLocation(HttpServletResponse response, Method method) {
        HxLocation methodAnnotation = (HxLocation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxLocation.class);
        if (methodAnnotation != null) {
            HtmxLocation location = this.convertToLocation(methodAnnotation);
            if (location.hasContextData()) {
                this.setHeaderJsonValue(response, HtmxResponseHeader.HX_LOCATION, location);
            } else {
                this.setHeader(response, HtmxResponseHeader.HX_LOCATION, location.getPath());
            }
        }
    }

    private void setHxPushUrl(HttpServletResponse response, Method method) {
        HxPushUrl methodAnnotation = (HxPushUrl)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxPushUrl.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_PUSH_URL, methodAnnotation.value());
        }
    }

    private void setHxRedirect(HttpServletResponse response, Method method) {
        HxRedirect methodAnnotation = (HxRedirect)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRedirect.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_REDIRECT, methodAnnotation.value());
        }
    }

    private void setHxReplaceUrl(HttpServletResponse response, Method method) {
        HxReplaceUrl methodAnnotation = (HxReplaceUrl)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReplaceUrl.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_REPLACE_URL, methodAnnotation.value());
        }
    }

    private void setHxReswap(HttpServletResponse response, Method method) {
        HxReswap methodAnnotation = (HxReswap)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReswap.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RESWAP, this.convertToReswap(methodAnnotation));
        }
    }

    private void setHxRetarget(HttpServletResponse response, Method method) {
        HxRetarget methodAnnotation = (HxRetarget)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRetarget.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RETARGET, methodAnnotation.value());
        }
    }

    private void setHxReselect(HttpServletResponse response, Method method) {
        HxReselect methodAnnotation = (HxReselect)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReselect.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RESELECT, methodAnnotation.value());
        }
    }

    private void setHxTrigger(HttpServletResponse response, Method method) {
        HxTrigger methodAnnotation = (HxTrigger)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTrigger.class);
        if (methodAnnotation != null) {
            this.setHeader(response, this.convertToHeader(methodAnnotation.lifecycle()), methodAnnotation.value());
        }
    }

    private void setHxTriggerAfterSettle(HttpServletResponse response, Method method) {
        HxTriggerAfterSettle methodAnnotation = (HxTriggerAfterSettle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTriggerAfterSettle.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SETTLE, methodAnnotation.value());
        }
    }

    private void setHxTriggerAfterSwap(HttpServletResponse response, Method method) {
        HxTriggerAfterSwap methodAnnotation = (HxTriggerAfterSwap)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTriggerAfterSwap.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SWAP, methodAnnotation.value());
        }
    }

    private void setHxRefresh(HttpServletResponse response, Method method) {
        HxRefresh methodAnnotation = (HxRefresh)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRefresh.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_REFRESH, "true");
        }
    }

    private HtmxResponseHeader convertToHeader(HxTriggerLifecycle lifecycle) {
        switch (lifecycle) {
            case RECEIVE: {
                return HtmxResponseHeader.HX_TRIGGER;
            }
            case SETTLE: {
                return HtmxResponseHeader.HX_TRIGGER_AFTER_SETTLE;
            }
            case SWAP: {
                return HtmxResponseHeader.HX_TRIGGER_AFTER_SWAP;
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle:" + lifecycle);
    }

    private void setHeaderJsonValue(HttpServletResponse response, HtmxResponseHeader header, Object value) {
        try {
            response.setHeader(header.getValue(), this.objectMapper.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to set header " + header.getValue() + " to " + value, e);
        }
    }

    private void setHeader(HttpServletResponse response, HtmxResponseHeader header, String value) {
        response.setHeader(header.getValue(), value);
    }

    private void setHeader(HttpServletResponse response, HtmxResponseHeader header, String[] values) {
        response.setHeader(header.getValue(), String.join((CharSequence)",", values));
    }

    private HtmxLocation convertToLocation(HxLocation annotation) {
        HtmxLocation location = new HtmxLocation();
        location.setPath(annotation.path());
        if (!annotation.source().isEmpty()) {
            location.setSource(annotation.source());
        }
        if (!annotation.event().isEmpty()) {
            location.setEvent(annotation.event());
        }
        if (!annotation.handler().isEmpty()) {
            location.setHandler(annotation.handler());
        }
        if (!annotation.target().isEmpty()) {
            location.setTarget(annotation.target());
        }
        if (!annotation.target().isEmpty()) {
            location.setSwap(annotation.swap());
        }
        return location;
    }

    private String convertToReswap(HxReswap annotation) {
        HtmxReswap reswap = new HtmxReswap(annotation.value());
        if (annotation.swap() != -1L) {
            reswap.swap(Duration.ofMillis(annotation.swap()));
        }
        if (annotation.settle() != -1L) {
            reswap.swap(Duration.ofMillis(annotation.settle()));
        }
        if (annotation.transition()) {
            reswap.transition();
        }
        if (annotation.focusScroll() != HxReswap.FocusScroll.UNDEFINED) {
            reswap.focusScroll(annotation.focusScroll() == HxReswap.FocusScroll.TRUE);
        }
        if (annotation.show() != HxReswap.Position.UNDEFINED) {
            reswap.show(this.convertToPosition(annotation.show()));
            if (!annotation.showTarget().isEmpty()) {
                reswap.scrollTarget(annotation.showTarget());
            }
        }
        if (annotation.scroll() != HxReswap.Position.UNDEFINED) {
            reswap.scroll(this.convertToPosition(annotation.scroll()));
            if (!annotation.scrollTarget().isEmpty()) {
                reswap.scrollTarget(annotation.scrollTarget());
            }
        }
        return reswap.toString();
    }

    private HtmxReswap.Position convertToPosition(HxReswap.Position position) {
        return switch (position) {
            case HxReswap.Position.TOP -> HtmxReswap.Position.TOP;
            case HxReswap.Position.BOTTOM -> HtmxReswap.Position.BOTTOM;
            default -> throw new IllegalStateException("Unexpected value: " + position);
        };
    }
}

