/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

public class HtmxExceptionHandlerExceptionResolver
extends ExceptionHandlerExceptionResolver {
    private final HtmxHandlerMethodHandler htmxHandlerMethodHandler;

    public HtmxExceptionHandlerExceptionResolver(HtmxHandlerMethodHandler htmxHandlerMethodHandler) {
        this.htmxHandlerMethodHandler = htmxHandlerMethodHandler;
    }

    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception exception) {
        ServletInvocableHandlerMethod exceptionHandlerMethod = this.getExceptionHandlerMethod(handlerMethod, exception);
        if (exceptionHandlerMethod != null) {
            Method method = exceptionHandlerMethod.getMethod();
            this.htmxHandlerMethodHandler.handleMethodAnnotations(method, request, response);
        }
        ModelAndView modelAndView = super.doResolveHandlerMethodException(request, response, handlerMethod, exception);
        this.htmxHandlerMethodHandler.handleMethodArgument(request, response);
        return modelAndView;
    }
}

