/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxExceptionHandlerExceptionResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerInterceptor;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodArgumentResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestMappingHandlerMapping;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHandlerMethodArgumentResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHandlerMethodReturnValueHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxViewMethodReturnValueHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxViewResolver;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@AutoConfiguration
@ConditionalOnWebApplication
public class HtmxMvcAutoConfiguration
implements WebMvcRegistrations,
WebMvcConfigurer {
    private final ObjectFactory<ViewResolver> viewResolverObjectFactory;
    private final ObjectFactory<LocaleResolver> localeResolverObjectFactory;
    private final ObjectMapper objectMapper;
    private final HtmxHandlerMethodHandler handlerMethodHandler;

    HtmxMvcAutoConfiguration(@Qualifier(value="viewResolver") ObjectFactory<ViewResolver> viewResolverObjectFactory, ObjectFactory<LocaleResolver> localeResolverObjectFactory) {
        Assert.notNull(viewResolverObjectFactory, (String)"viewResolverObjectFactory must not be null!");
        Assert.notNull(localeResolverObjectFactory, (String)"localeResolverObjectFactory must not be null!");
        this.viewResolverObjectFactory = viewResolverObjectFactory;
        this.localeResolverObjectFactory = localeResolverObjectFactory;
        this.objectMapper = JsonMapper.builder().build();
        this.handlerMethodHandler = new HtmxHandlerMethodHandler(this.objectMapper);
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new HtmxRequestMappingHandlerMapping();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HtmxHandlerInterceptor(this.handlerMethodHandler));
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new HtmxHandlerMethodArgumentResolver());
        resolvers.add(new HtmxResponseHandlerMethodArgumentResolver());
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        handlers.add(new HtmxResponseHandlerMethodReturnValueHandler((ViewResolver)this.viewResolverObjectFactory.getObject(), this.localeResolverObjectFactory, this.objectMapper));
        handlers.add(new HtmxViewMethodReturnValueHandler((ViewResolver)this.viewResolverObjectFactory.getObject(), (LocaleResolver)this.localeResolverObjectFactory.getObject()));
    }

    public ExceptionHandlerExceptionResolver getExceptionHandlerExceptionResolver() {
        return new HtmxExceptionHandlerExceptionResolver(this.handlerMethodHandler);
    }

    @Bean
    @ConditionalOnBean(value={View.class})
    @ConditionalOnMissingBean
    public HtmxViewResolver htmxViewResolver() {
        HtmxViewResolver resolver = new HtmxViewResolver();
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

