/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;

public final class HtmxRequest {
    private final boolean htmxRequest;
    private final boolean boosted;
    private final String currentUrl;
    private final boolean historyRestoreRequest;
    private final String promptResponse;
    private final String target;
    private final String triggerName;
    private final String triggerId;

    public static Builder builder() {
        return new Builder();
    }

    public static HtmxRequest empty() {
        return new HtmxRequest(false, false, null, false, null, null, null, null);
    }

    public static HtmxRequest fromRequest(HttpServletRequest request) {
        String hxRequestHeader = request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue());
        if (hxRequestHeader == null) {
            return HtmxRequest.empty();
        }
        Builder builder = HtmxRequest.builder();
        if (request.getHeader(HtmxRequestHeader.HX_BOOSTED.getValue()) != null) {
            builder.boosted(true);
        }
        if (request.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()) != null) {
            builder.currentUrl(request.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_HISTORY_RESTORE_REQUEST.getValue()) != null) {
            builder.historyRestoreRequest(true);
        }
        if (request.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()) != null) {
            builder.promptResponse(request.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TARGET.getValue()) != null) {
            builder.target(request.getHeader(HtmxRequestHeader.HX_TARGET.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()) != null) {
            builder.triggerName(request.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()));
        }
        if (request.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()) != null) {
            builder.triggerId(request.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()));
        }
        return builder.build();
    }

    HtmxRequest(boolean htmxRequest, boolean boosted, String currentUrl, boolean historyRestoreRequest, String promptResponse, String target, String triggerName, String triggerId) {
        this.htmxRequest = htmxRequest;
        this.boosted = boosted;
        this.currentUrl = currentUrl;
        this.historyRestoreRequest = historyRestoreRequest;
        this.promptResponse = promptResponse;
        this.target = target;
        this.triggerName = triggerName;
        this.triggerId = triggerId;
    }

    public boolean isHtmxRequest() {
        return this.htmxRequest;
    }

    public boolean isBoosted() {
        return this.boosted;
    }

    @Nullable
    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public boolean isHistoryRestoreRequest() {
        return this.historyRestoreRequest;
    }

    @Nullable
    public String getPromptResponse() {
        return this.promptResponse;
    }

    @Nullable
    public String getTarget() {
        return this.target;
    }

    @Nullable
    public String getTriggerName() {
        return this.triggerName;
    }

    @Nullable
    public String getTriggerId() {
        return this.triggerId;
    }

    public static final class Builder {
        private boolean boosted;
        private String currentUrl;
        private boolean historyRestoreRequest;
        private String promptResponse;
        private String target;
        private String triggerName;
        private String triggerId;

        private Builder() {
        }

        @Deprecated
        public Builder withBoosted(boolean boosted) {
            return this.boosted(boosted);
        }

        public Builder boosted(boolean boosted) {
            this.boosted = boosted;
            return this;
        }

        @Deprecated
        public Builder withCurrentUrl(String currentUrl) {
            this.currentUrl = currentUrl;
            return this;
        }

        public Builder currentUrl(String currentUrl) {
            this.currentUrl = currentUrl;
            return this;
        }

        @Deprecated
        public Builder withHistoryRestoreRequest(boolean historyRestoreRequest) {
            this.historyRestoreRequest = historyRestoreRequest;
            return this;
        }

        public Builder historyRestoreRequest(boolean historyRestoreRequest) {
            this.historyRestoreRequest = historyRestoreRequest;
            return this;
        }

        @Deprecated
        public Builder withPromptResponse(String promptResponse) {
            this.promptResponse = promptResponse;
            return this;
        }

        public Builder promptResponse(String promptResponse) {
            this.promptResponse = promptResponse;
            return this;
        }

        @Deprecated
        public Builder withTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        @Deprecated
        public Builder withTriggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        @Deprecated
        public Builder withTriggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public Builder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public HtmxRequest build() {
            return new HtmxRequest(true, this.boosted, this.currentUrl, this.historyRestoreRequest, this.promptResponse, this.target, this.triggerName, this.triggerId);
        }
    }
}

