/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class HtmxResponseHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType() == HtmxResponse.class || parameter.getParameterType() == HtmxResponse.Builder.class;
    }

    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (parameter.getParameterType() == HtmxResponse.class) {
            HtmxResponse htmxResponse = new HtmxResponse();
            request.setAttribute("htmxResponse", (Object)htmxResponse);
            return htmxResponse;
        }
        HtmxResponse.Builder htmxResponseBuilder = HtmxResponse.builder();
        request.setAttribute("htmxResponse", (Object)htmxResponseBuilder);
        return htmxResponseBuilder;
    }
}

