/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxView;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class HtmxViewMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final ViewResolver viewResolver;
    private final LocaleResolver localeResolver;

    public HtmxViewMethodReturnValueHandler(ViewResolver viewResolver, LocaleResolver localeResolver) {
        this.viewResolver = viewResolver;
        this.localeResolver = localeResolver;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return HtmxView.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue instanceof HtmxView) {
            HtmxView htmxView = (HtmxView)returnValue;
            mavContainer.setView((Object)this.toView(htmxView));
        } else if (returnValue != null) {
            throw new UnsupportedOperationException("Unexpected return type: " + returnType.getParameterType().getName() + " in method: " + returnType.getMethod());
        }
    }

    private View toView(HtmxView htmxView) {
        return (model, request, response) -> {
            Locale locale = this.localeResolver.resolveLocale(request);
            ContentCachingResponseWrapper wrapper = new ContentCachingResponseWrapper(response);
            for (ModelAndView mav : htmxView.getViews()) {
                View view;
                if (mav.isReference()) {
                    view = this.viewResolver.resolveViewName(mav.getViewName(), locale);
                    if (view == null) {
                        throw new IllegalArgumentException("Could not resolve view with name '" + mav.getViewName() + "'.");
                    }
                } else {
                    view = mav.getView();
                }
                for (String key : model.keySet()) {
                    if (mav.getModel().containsKey(key)) continue;
                    mav.getModel().put(key, model.get(key));
                }
                view.render(mav.getModel(), request, (HttpServletResponse)wrapper);
            }
            wrapper.copyBodyToResponse();
        };
    }
}

