/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponse;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxTrigger;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxPushUrl;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReplaceUrl;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReselect;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxRetarget;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTrigger;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerAfterSettle;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxTriggerAfterSwap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.RequestContextUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotatedElementUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

class HtmxHandlerMethodHandler {
    private final ObjectMapper objectMapper;

    public HtmxHandlerMethodHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void handleMethodArgument(HttpServletRequest request, HttpServletResponse response) {
        HtmxResponse htmxResponse = RequestContextUtils.getHtmxResponse(request);
        if (htmxResponse != null) {
            this.addHxTriggerHeaders(response, HtmxResponseHeader.HX_TRIGGER, htmxResponse.getTriggers());
            this.addHxTriggerHeaders(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SETTLE, htmxResponse.getTriggersAfterSettle());
            this.addHxTriggerHeaders(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SWAP, htmxResponse.getTriggersAfterSwap());
            if (htmxResponse.getReplaceUrl() != null) {
                response.setHeader(HtmxResponseHeader.HX_REPLACE_URL.getValue(), RequestContextUtils.createUrl(request, htmxResponse.getReplaceUrl(), htmxResponse.isContextRelative()));
            }
            if (htmxResponse.getPushUrl() != null) {
                response.setHeader(HtmxResponseHeader.HX_PUSH_URL.getValue(), RequestContextUtils.createUrl(request, htmxResponse.getPushUrl(), htmxResponse.isContextRelative()));
            }
            if (htmxResponse.getRetarget() != null) {
                response.setHeader(HtmxResponseHeader.HX_RETARGET.getValue(), htmxResponse.getRetarget());
            }
            if (htmxResponse.getReselect() != null) {
                response.setHeader(HtmxResponseHeader.HX_RESELECT.getValue(), htmxResponse.getReselect());
            }
            if (htmxResponse.getReswap() != null) {
                response.setHeader(HtmxResponseHeader.HX_RESWAP.getValue(), htmxResponse.getReswap().toHeaderValue());
            }
        }
    }

    public void handleMethodAnnotations(Method method, HttpServletRequest request, HttpServletResponse response) {
        this.setHxPushUrl(request, response, method);
        this.setHxReplaceUrl(request, response, method);
        this.setHxReswap(response, method);
        this.setHxRetarget(response, method);
        this.setHxReselect(response, method);
        this.setHxTrigger(response, method);
        this.setHxTriggerAfterSettle(response, method);
        this.setHxTriggerAfterSwap(response, method);
    }

    private void addHxTriggerHeaders(HttpServletResponse response, HtmxResponseHeader headerName, Collection<HtmxTrigger> triggers) {
        if (triggers.isEmpty()) {
            return;
        }
        if (triggers.stream().allMatch(t -> t.getEventDetail() == null)) {
            String value = triggers.stream().map(HtmxTrigger::getEventName).collect(Collectors.joining(","));
            response.setHeader(headerName.getValue(), value);
            return;
        }
        HashMap<String, Object> triggerMap = new HashMap<String, Object>();
        for (HtmxTrigger trigger : triggers) {
            triggerMap.put(trigger.getEventName(), trigger.getEventDetail());
        }
        this.setHeaderJsonValue(response, headerName, triggerMap);
    }

    private void setHxPushUrl(HttpServletRequest request, HttpServletResponse response, Method method) {
        HxPushUrl methodAnnotation = (HxPushUrl)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxPushUrl.class);
        if (methodAnnotation != null) {
            if ("true".equals(methodAnnotation.value())) {
                this.setHeader(response, HtmxResponseHeader.HX_PUSH_URL, this.getRequestUrl(request));
            } else {
                this.setHeader(response, HtmxResponseHeader.HX_PUSH_URL, RequestContextUtils.createUrl(request, methodAnnotation.value(), methodAnnotation.contextRelative()));
            }
        }
    }

    private void setHxReplaceUrl(HttpServletRequest request, HttpServletResponse response, Method method) {
        HxReplaceUrl methodAnnotation = (HxReplaceUrl)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReplaceUrl.class);
        if (methodAnnotation != null) {
            if ("true".equals(methodAnnotation.value())) {
                this.setHeader(response, HtmxResponseHeader.HX_REPLACE_URL, this.getRequestUrl(request));
            } else {
                this.setHeader(response, HtmxResponseHeader.HX_REPLACE_URL, RequestContextUtils.createUrl(request, methodAnnotation.value(), methodAnnotation.contextRelative()));
            }
        }
    }

    private void setHxReswap(HttpServletResponse response, Method method) {
        HxReswap methodAnnotation = (HxReswap)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReswap.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RESWAP, this.convertToReswap(methodAnnotation));
        }
    }

    private void setHxRetarget(HttpServletResponse response, Method method) {
        HxRetarget methodAnnotation = (HxRetarget)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRetarget.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RETARGET, methodAnnotation.value());
        }
    }

    private void setHxReselect(HttpServletResponse response, Method method) {
        HxReselect methodAnnotation = (HxReselect)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxReselect.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_RESELECT, methodAnnotation.value());
        }
    }

    private void setHxTrigger(HttpServletResponse response, Method method) {
        HxTrigger methodAnnotation = (HxTrigger)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTrigger.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_TRIGGER, methodAnnotation.value());
        }
    }

    private void setHxTriggerAfterSettle(HttpServletResponse response, Method method) {
        HxTriggerAfterSettle methodAnnotation = (HxTriggerAfterSettle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTriggerAfterSettle.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SETTLE, methodAnnotation.value());
        }
    }

    private void setHxTriggerAfterSwap(HttpServletResponse response, Method method) {
        HxTriggerAfterSwap methodAnnotation = (HxTriggerAfterSwap)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTriggerAfterSwap.class);
        if (methodAnnotation != null) {
            this.setHeader(response, HtmxResponseHeader.HX_TRIGGER_AFTER_SWAP, methodAnnotation.value());
        }
    }

    private void setHeader(HttpServletResponse response, HtmxResponseHeader header, String value) {
        response.setHeader(header.getValue(), value);
    }

    private void setHeader(HttpServletResponse response, HtmxResponseHeader header, String[] values) {
        response.setHeader(header.getValue(), String.join((CharSequence)",", values));
    }

    private String convertToReswap(HxReswap annotation) {
        HtmxReswap reswap = new HtmxReswap(annotation.value());
        if (annotation.swap() != -1L) {
            reswap.swap(Duration.ofMillis(annotation.swap()));
        }
        if (annotation.settle() != -1L) {
            reswap.swap(Duration.ofMillis(annotation.settle()));
        }
        if (annotation.transition()) {
            reswap.transition();
        }
        if (annotation.focusScroll() != HxReswap.FocusScroll.UNDEFINED) {
            reswap.focusScroll(annotation.focusScroll() == HxReswap.FocusScroll.TRUE);
        }
        if (annotation.show() != HxReswap.Position.UNDEFINED) {
            reswap.show(this.convertToPosition(annotation.show()));
            if (!annotation.showTarget().isEmpty()) {
                reswap.scrollTarget(annotation.showTarget());
            }
        }
        if (annotation.scroll() != HxReswap.Position.UNDEFINED) {
            reswap.scroll(this.convertToPosition(annotation.scroll()));
            if (!annotation.scrollTarget().isEmpty()) {
                reswap.scrollTarget(annotation.scrollTarget());
            }
        }
        return reswap.toString();
    }

    private HtmxReswap.Position convertToPosition(HxReswap.Position position) {
        return switch (position) {
            case HxReswap.Position.TOP -> HtmxReswap.Position.TOP;
            case HxReswap.Position.BOTTOM -> HtmxReswap.Position.BOTTOM;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)position));
        };
    }

    private String getRequestUrl(HttpServletRequest request) {
        Object path = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            path = (String)path + "?" + queryString;
        }
        return path;
    }

    private void setHeaderJsonValue(HttpServletResponse response, HtmxResponseHeader header, Object value) {
        try {
            response.setHeader(header.getValue(), this.objectMapper.writeValueAsString(value));
        }
        catch (JacksonException e) {
            throw new IllegalArgumentException("Unable to set header " + header.getValue() + " to " + String.valueOf(value), e);
        }
    }
}

