/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxExceptionHandlerExceptionResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerInterceptor;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodArgumentResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestMappingHandlerMapping;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHandlerMethodArgumentResolver;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxViewResolver;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.webmvc.autoconfigure.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnWebApplication
public class HtmxMvcAutoConfiguration
implements WebMvcRegistrations,
WebMvcConfigurer {
    private final HtmxHandlerMethodHandler handlerMethodHandler;

    HtmxMvcAutoConfiguration() {
        JsonMapper jsonMapper = JsonMapper.builder().build();
        this.handlerMethodHandler = new HtmxHandlerMethodHandler((ObjectMapper)jsonMapper);
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new HtmxRequestMappingHandlerMapping();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HtmxHandlerInterceptor(this.handlerMethodHandler));
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new HtmxHandlerMethodArgumentResolver());
        resolvers.add(new HtmxResponseHandlerMethodArgumentResolver());
    }

    public ExceptionHandlerExceptionResolver getExceptionHandlerExceptionResolver() {
        return new HtmxExceptionHandlerExceptionResolver(this.handlerMethodHandler);
    }

    @Bean
    @ConditionalOnBean(value={View.class})
    @ConditionalOnMissingBean
    public HtmxViewResolver htmxViewResolver() {
        HtmxViewResolver resolver = new HtmxViewResolver();
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

