/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxReswap;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxTrigger;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

public final class HtmxResponse {
    private final Set<HtmxTrigger> triggers = new LinkedHashSet<HtmxTrigger>();
    private final Set<HtmxTrigger> triggersAfterSettle = new LinkedHashSet<HtmxTrigger>();
    private final Set<HtmxTrigger> triggersAfterSwap = new LinkedHashSet<HtmxTrigger>();
    private String replaceUrl;
    private String reselect;
    private boolean contextRelative = true;
    private String retarget;
    private String pushUrl;
    private HtmxReswap reswap;

    public void addTrigger(String eventName) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggers.add(new HtmxTrigger(eventName, null));
    }

    public void addTrigger(String eventName, Object eventDetail) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggers.add(new HtmxTrigger(eventName, eventDetail));
    }

    public void addTriggerAfterSettle(String eventName) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggersAfterSettle.add(new HtmxTrigger(eventName, null));
    }

    public void addTriggerAfterSettle(String eventName, Object eventDetail) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggersAfterSettle.add(new HtmxTrigger(eventName, eventDetail));
    }

    public void addTriggerAfterSwap(String eventName) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggersAfterSwap.add(new HtmxTrigger(eventName, null));
    }

    public void addTriggerAfterSwap(String eventName, Object eventDetail) {
        Assert.hasText((String)eventName, (String)"eventName should not be blank");
        this.triggersAfterSwap.add(new HtmxTrigger(eventName, eventDetail));
    }

    public void preventHistoryUpdate() {
        this.pushUrl = "false";
        this.replaceUrl = null;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setPushUrl(String url) {
        Assert.hasText((String)url, (String)"url should not be blank");
        this.pushUrl = url;
        this.replaceUrl = null;
    }

    public void setReplaceUrl(String url) {
        this.replaceUrl = url;
        this.pushUrl = null;
    }

    public void setReselect(String cssSelector) {
        Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
        this.reselect = cssSelector;
    }

    public void setReswap(HtmxReswap reswap) {
        Assert.notNull((Object)reswap, (String)"reswap should not be null");
        this.reswap = reswap;
    }

    public void setRetarget(String cssSelector) {
        Assert.hasText((String)cssSelector, (String)"cssSelector should not be blank");
        this.retarget = cssSelector;
    }

    public String getPushUrl() {
        return this.pushUrl;
    }

    public String getReplaceUrl() {
        return this.replaceUrl;
    }

    public String getReselect() {
        return this.reselect;
    }

    public HtmxReswap getReswap() {
        return this.reswap;
    }

    public String getRetarget() {
        return this.retarget;
    }

    public Collection<HtmxTrigger> getTriggers() {
        return this.triggers;
    }

    public Collection<HtmxTrigger> getTriggersAfterSettle() {
        return this.triggersAfterSettle;
    }

    public Collection<HtmxTrigger> getTriggersAfterSwap() {
        return this.triggersAfterSwap;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }
}

