/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodHandler;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class HtmxResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private final HtmxHandlerMethodHandler htmxHandlerMethodHandler;

    public HtmxResponseBodyAdvice(HtmxHandlerMethodHandler htmxHandlerMethodHandler) {
        this.htmxHandlerMethodHandler = htmxHandlerMethodHandler;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest servletRequest = (ServletServerHttpRequest)request;
            if (response instanceof ServletServerHttpResponse) {
                ServletServerHttpResponse servletResponse = (ServletServerHttpResponse)response;
                this.htmxHandlerMethodHandler.handleMethodArgument(servletRequest.getServletRequest(), servletResponse.getServletResponse());
            }
        }
        return body;
    }
}

