/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.testcontainers.cypress;

import com.github.dockerjava.api.model.Bind;
import io.github.wimdeblauwe.testcontainers.cypress.CypressTestResults;
import io.github.wimdeblauwe.testcontainers.cypress.GatherTestResultsStrategy;
import io.github.wimdeblauwe.testcontainers.cypress.MochawesomeGatherTestResultsStrategy;
import io.github.wimdeblauwe.testcontainers.cypress.util.FilenameUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.utility.DockerImageName;

public class CypressContainer
extends GenericContainer<CypressContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CypressContainer.class);
    private static final String CYPRESS_IMAGE = "cypress/included";
    private static final String CYPRESS_VERSION = "13.14.2";
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_BASE_URL = "http://host.testcontainers.internal";
    private static final String DEFAULT_URL = "http://host.testcontainers.internal:8080";
    private static final String DEFAULT_CLASSPATH_RESOURCE_PATH = "e2e";
    private static final Duration DEFAULT_MAX_TOTAL_TEST_DURATION = Duration.ofMinutes(10L);
    private static final GatherTestResultsStrategy DEFAULT_GATHER_TEST_RESULTS_STRATEGY = new MochawesomeGatherTestResultsStrategy();
    private static final boolean DEFAULT_AUTO_CLEAN_REPORTS = true;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private String baseUrl = "http://host.testcontainers.internal:8080";
    private String browser;
    private String spec;
    private boolean record;
    private String recordKey;
    private String classpathResourcePath = "e2e";
    private Duration maximumTotalTestDuration = DEFAULT_MAX_TOTAL_TEST_DURATION;
    private GatherTestResultsStrategy gatherTestResultsStrategy = DEFAULT_GATHER_TEST_RESULTS_STRATEGY;
    private boolean autoCleanReports = true;

    public CypressContainer() {
        this("cypress/included:13.14.2");
    }

    public CypressContainer(String dockerImageName) {
        super(dockerImageName);
        this.setWorkingDirectory("/e2e");
    }

    public CypressContainer(Future<String> dockerImageName) {
        super(dockerImageName);
        this.setWorkingDirectory("/e2e");
    }

    public CypressContainer(RemoteDockerImage remoteDockerImage) {
        super(remoteDockerImage);
        this.setWorkingDirectory("/e2e");
    }

    public CypressContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.setWorkingDirectory("/e2e");
    }

    protected void configure() {
        this.addEnv("CYPRESS_baseUrl", this.baseUrl);
        this.withClasspathResourceMapping(this.classpathResourcePath, "/e2e", BindMode.READ_WRITE);
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"bash", "-c", this.buildEntryPoint()}));
    }

    public void start() {
        super.start();
        CypressContainerOutputFollower follower = new CypressContainerOutputFollower(this.countDownLatch);
        this.followOutput(follower);
    }

    public CypressContainer withLocalServerPort(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("port should be a positive integer, but was " + port);
        }
        this.baseUrl = "http://host.testcontainers.internal:" + port;
        return (CypressContainer)this.self();
    }

    public CypressContainer withBaseUrl(String baseUrl) {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("baseUrl should not be blank");
        }
        this.baseUrl = baseUrl;
        return (CypressContainer)this.self();
    }

    public CypressContainer withBrowser(String browser) {
        if (browser == null || browser.trim().isEmpty()) {
            throw new IllegalArgumentException("browser should not be blank");
        }
        this.browser = browser;
        return (CypressContainer)this.self();
    }

    public CypressContainer withSpec(String spec) {
        if (spec == null || spec.trim().isEmpty()) {
            throw new IllegalArgumentException("spec should not be blank");
        }
        this.spec = spec;
        return (CypressContainer)this.self();
    }

    public CypressContainer withRecord() {
        this.record = true;
        this.recordKey = null;
        return (CypressContainer)this.self();
    }

    public CypressContainer withRecord(String recordKey) {
        this.record = true;
        this.recordKey = recordKey;
        return (CypressContainer)this.self();
    }

    public CypressContainer withClasspathResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.trim().isEmpty()) {
            throw new IllegalArgumentException("resourcePath should not be blank");
        }
        this.classpathResourcePath = resourcePath;
        return (CypressContainer)this.self();
    }

    public CypressContainer withMaximumTotalTestDuration(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration should not be null");
        }
        this.maximumTotalTestDuration = duration;
        return (CypressContainer)this.self();
    }

    public CypressContainer withGatherTestResultsStrategy(GatherTestResultsStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy should not be null");
        }
        this.gatherTestResultsStrategy = strategy;
        return (CypressContainer)this.self();
    }

    public CypressContainer withMochawesomeReportsAt(Path path) {
        return this.withGatherTestResultsStrategy(new MochawesomeGatherTestResultsStrategy(path));
    }

    public CypressContainer withAutoCleanReports(boolean autoCleanReports) {
        this.autoCleanReports = autoCleanReports;
        return (CypressContainer)this.self();
    }

    public CypressTestResults getTestResults() throws InterruptedException, TimeoutException, IOException {
        boolean success = this.countDownLatch.await(this.maximumTotalTestDuration.toMillis(), TimeUnit.MILLISECONDS);
        if (success) {
            CypressTestResults results = this.gatherTestResultsStrategy.gatherTestResults();
            LOGGER.info("{}", (Object)results);
            if (results.getNumberOfFailingTests() > 0) {
                LOGGER.warn("There was a failure running the Cypress tests!\n\n{}", (Object)results);
            }
            return results;
        }
        LOGGER.warn("Cypress tests did not finish within {} duration", (Object)this.maximumTotalTestDuration);
        throw new TimeoutException(String.format("Cypress tests did not finish within %s duration", this.maximumTotalTestDuration));
    }

    @Nonnull
    private String buildCypressRunArguments() {
        StringBuilder builder = new StringBuilder();
        builder.append("--headless");
        if (this.browser != null) {
            builder.append(" --browser ").append(this.browser);
        }
        if (this.spec != null) {
            builder.append(" --spec \"").append(this.spec).append('\"');
        }
        if (this.record) {
            builder.append(" --record");
            if (this.recordKey != null) {
                builder.append(" --key ").append(this.recordKey);
            }
        }
        return builder.toString();
    }

    @Nonnull
    private String buildEntryPoint() {
        StringBuilder builder = new StringBuilder();
        if (this.autoCleanReports) {
            String reportsPathInContainer = this.getReportsPathInContainer();
            if (reportsPathInContainer.equals("/")) {
                throw new IllegalArgumentException("Reports path was /, not allowing to delete everything");
            }
            LOGGER.debug("Removing reports from {}", (Object)reportsPathInContainer);
            builder.append("rm -rf ").append(reportsPathInContainer).append(" && ");
        }
        builder.append("npm install && ");
        builder.append("cypress run ").append(this.buildCypressRunArguments());
        return builder.toString();
    }

    @Nonnull
    private String getReportsPathInContainer() {
        Path pathOnHost = this.gatherTestResultsStrategy.getReportsPath().toAbsolutePath();
        String pathInContainer = null;
        List binds = this.getBinds();
        for (Bind bind : binds) {
            String path = FilenameUtils.separatorsToSystem(bind.getPath());
            if (!pathOnHost.startsWith(path)) continue;
            pathInContainer = FilenameUtils.separatorsToUnix(Paths.get(path, new String[0]).relativize(pathOnHost).toString());
        }
        if (pathInContainer == null) {
            throw new IllegalArgumentException("Could not find matching container path in the binds: " + binds);
        }
        return pathInContainer;
    }

    private static class CypressContainerOutputFollower
    implements Consumer<OutputFrame> {
        private final CountDownLatch countDownLatch;

        CypressContainerOutputFollower(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void accept(OutputFrame outputFrame) {
            String logLine = StringUtils.strip((String)outputFrame.getUtf8String());
            LOGGER.debug(logLine);
            if (logLine.contains("Run Finished")) {
                this.countDownLatch.countDown();
            }
        }
    }
}

