/*
 * Decompiled with CFR 0.152.
 */
package io.agora.transcription_widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.RecyclerView;
import io.agora.transcription_widget.R;
import io.agora.transcription_widget.internal.TranscriptSubtitleMachine;
import io.agora.transcription_widget.internal.adapter.SubtitleAdapter;
import io.agora.transcription_widget.internal.model.ListChangeItem;
import io.agora.transcription_widget.internal.utils.LogUtils;
import io.agora.transcription_widget.internal.utils.WrapContentLinearLayoutManager;
import io.agora.transcription_widget.utils.Utils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020+J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020)H\u0014J\b\u00101\u001a\u00020)H\u0014J\u0018\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010R$\u0010#\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00066"}, d2={"Lio/agora/transcription_widget/TranscriptSubtitleView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "adapter", "Lio/agora/transcription_widget/internal/adapter/SubtitleAdapter;", "value", "finalTextColor", "getFinalTextColor", "()I", "setFinalTextColor", "(I)V", "handler", "Landroid/os/Handler;", "isDestroyed", "", "nonFinalTextColor", "getNonFinalTextColor", "setNonFinalTextColor", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "showTranscriptContent", "getShowTranscriptContent", "()Z", "setShowTranscriptContent", "(Z)V", "textAreaBackgroundColor", "getTextAreaBackgroundColor", "setTextAreaBackgroundColor", "", "textSize", "getTextSize", "()F", "setTextSize", "(F)V", "clear", "", "getAllTranscriptText", "", "getAllTranslateText", "invalidate", "item", "Lio/agora/transcription_widget/internal/model/ListChangeItem;", "onAttachedToWindow", "onDetachedFromWindow", "pushMessageData", "data", "", "uid", "transcription-widget_release"})
public final class TranscriptSubtitleView
extends FrameLayout {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final SubtitleAdapter adapter;
    @NotNull
    private final Handler handler;
    private boolean isDestroyed;
    private int finalTextColor;
    private int nonFinalTextColor;
    private float textSize;
    private int textAreaBackgroundColor;
    private boolean showTranscriptContent;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public TranscriptSubtitleView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        float f;
        SubtitleAdapter subtitleAdapter;
        FrameLayout.LayoutParams layoutParams;
        SubtitleAdapter subtitleAdapter2;
        FrameLayout.LayoutParams layoutParams2;
        SubtitleAdapter subtitleAdapter3;
        FrameLayout.LayoutParams layoutParams3;
        SubtitleAdapter subtitleAdapter4;
        SubtitleAdapter subtitleAdapter5;
        RecyclerView recyclerView;
        Handler handler;
        void var3_3;
        void var2_2;
        FrameLayout.LayoutParams layoutParams4;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((Context)layoutParams4, (AttributeSet)var2_2, (int)var3_3);
        Handler handler2 = handler;
        handler = new Handler(Looper.getMainLooper());
        this.handler = handler2;
        this.finalTextColor = -16777216;
        this.nonFinalTextColor = -7829368;
        this.textSize = this.getResources().getDimension(R.dimen.subtitle_text_size);
        this.textAreaBackgroundColor = Color.argb((int)63, (int)0, (int)0, (int)0);
        this.showTranscriptContent = true;
        LogUtils.INSTANCE.enableLog((Context)layoutParams4, true, true, "");
        handler2 = recyclerView;
        new RecyclerView((Context)layoutParams4).setLayoutManager((RecyclerView.LayoutManager)new WrapContentLinearLayoutManager((Context)layoutParams4));
        this.recyclerView = handler2;
        this.adapter = subtitleAdapter5 = subtitleAdapter4;
        new SubtitleAdapter().setItems(TranscriptSubtitleMachine.INSTANCE.getTranscriptionDataList());
        handler2.setAdapter((RecyclerView.Adapter)subtitleAdapter5);
        handler2.addItemDecoration((RecyclerView.ItemDecoration)new SubtitleAdapter.MyItemDecoration(Utils.dpToPx(10, (Context)layoutParams4)));
        layoutParams4 = layoutParams3;
        layoutParams3 = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)handler2, (ViewGroup.LayoutParams)layoutParams4);
        layoutParams4 = context2.getTheme().obtainStyledAttributes((AttributeSet)var2_2, R.styleable.TranscriptSubtitleView, (int)var3_3, 0);
        try {
            subtitleAdapter3 = subtitleAdapter5;
            layoutParams2 = layoutParams4;
            subtitleAdapter2 = subtitleAdapter5;
            layoutParams = layoutParams4;
            subtitleAdapter = subtitleAdapter5;
            this.setFinalTextColor(layoutParams4.getColor(R.styleable.TranscriptSubtitleView_finalTextColor, this.finalTextColor));
            subtitleAdapter5.setFinalTextColor(this.finalTextColor);
            this.setNonFinalTextColor(layoutParams4.getColor(R.styleable.TranscriptSubtitleView_nonFinalTextColor, this.nonFinalTextColor));
            subtitleAdapter5.setNonFinalTextColor(this.nonFinalTextColor);
            this.setTextSize(layoutParams4.getDimension(R.styleable.TranscriptSubtitleView_textSize, this.textSize));
            f = this.textSize / layoutParams4.getResources().getDisplayMetrics().scaledDensity;
        }
        catch (Throwable throwable) {
            layoutParams4.recycle();
            throw throwable;
        }
        subtitleAdapter.setTextSize(f);
        this.setTextAreaBackgroundColor(layoutParams.getColor(R.styleable.TranscriptSubtitleView_textAreaBackgroundColor, this.textAreaBackgroundColor));
        subtitleAdapter2.setTextAreaBackgroundColor(this.textAreaBackgroundColor);
        this.setShowTranscriptContent(layoutParams2.getBoolean(R.styleable.TranscriptSubtitleView_showTranscriptContent, this.showTranscriptContent));
        subtitleAdapter3.setShowTranscriptContent(this.showTranscriptContent);
        layoutParams4.recycle();
    }

    public /* synthetic */ TranscriptSubtitleView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void invalidate(ListChangeItem item) {
        void var1_1;
        LogUtils logUtils = LogUtils.INSTANCE;
        logUtils.d("TranscriptSubtitleView invalidate type:" + var1_1.getType() + " position:" + var1_1.getPosition());
        if (this.isDestroyed) {
            logUtils.i("TranscriptSubtitleView is destroyed, can't invalidate.");
            return;
        }
        if (var1_1.getPosition() >= 0 && (var1_1.getPosition() == 0 || var1_1.getPosition() < this.adapter.getItemCount())) {
            this.handler.post(() -> TranscriptSubtitleView.invalidate$lambda$2((ListChangeItem)var1_1, this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public TranscriptSubtitleView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        this((Context)var1_1, (AttributeSet)var2_2, 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public TranscriptSubtitleView(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        this((Context)var1_1, null, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void invalidate$lambda$2(ListChangeItem $item, TranscriptSubtitleView this$0) {
        void var1_1;
        ListChangeItem listChangeItem;
        Intrinsics.checkNotNullParameter((Object)listChangeItem, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"this$0");
        switch ($item.getType()) {
            default: {
                LogUtils.INSTANCE.i("invalidate type:" + listChangeItem.getType() + " is invalid.");
                break;
            }
            case 3: {
                var1_1.adapter.notifyDataSetChanged();
                break;
            }
            case 2: {
                var1_1.adapter.notifyItemChanged(listChangeItem.getPosition(), new Bundle());
                break;
            }
            case 1: {
                var1_1.adapter.notifyItemRemoved(listChangeItem.getPosition());
                break;
            }
            case 0: {
                var1_1.adapter.notifyItemInserted(listChangeItem.getPosition());
            }
        }
        if (var1_1.adapter.getItemCount() >= 1) {
            var1_1.recyclerView.smoothScrollToPosition(var1_1.adapter.getItemCount() - 1);
        }
    }

    public final int getFinalTextColor() {
        return this.finalTextColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFinalTextColor(int value) {
        void var1_1;
        this.finalTextColor = var1_1;
        this.adapter.setFinalTextColor((int)var1_1);
    }

    public final int getNonFinalTextColor() {
        return this.nonFinalTextColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNonFinalTextColor(int value) {
        void var1_1;
        this.nonFinalTextColor = var1_1;
        this.adapter.setNonFinalTextColor((int)var1_1);
    }

    public final float getTextSize() {
        return this.textSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextSize(float value) {
        void var1_2;
        this.textSize = var1_2;
        void var0_1 = var1_2 / this.getResources().getDisplayMetrics().scaledDensity;
        this.adapter.setTextSize((float)var0_1);
    }

    public final int getTextAreaBackgroundColor() {
        return this.textAreaBackgroundColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextAreaBackgroundColor(int value) {
        void var1_1;
        this.textAreaBackgroundColor = var1_1;
        this.adapter.setTextAreaBackgroundColor((int)var1_1);
    }

    public final boolean getShowTranscriptContent() {
        return this.showTranscriptContent;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShowTranscriptContent(boolean value) {
        void var1_1;
        this.showTranscriptContent = var1_1;
        this.adapter.setShowTranscriptContent((boolean)var1_1);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        LogUtils.INSTANCE.i("TranscriptSubtitleView onAttachedToWindow");
        this.isDestroyed = false;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        LogUtils.INSTANCE.i("TranscriptSubtitleView onDetachedFromWindow");
        TranscriptSubtitleMachine.INSTANCE.clear();
        this.isDestroyed = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushMessageData(@Nullable byte[] data, int uid) {
        void var2_2;
        void var1_1;
        if (this.isDestroyed) {
            LogUtils.INSTANCE.i("TranscriptSubtitleView is destroyed, can't pushMessageData.");
            return;
        }
        this.invalidate(TranscriptSubtitleMachine.INSTANCE.handleMessageData((byte[])var1_1, (int)var2_2));
    }

    @NotNull
    public final String getAllTranscriptText() {
        LogUtils.INSTANCE.d("TranscriptSubtitleView getAllTranscriptText");
        return TranscriptSubtitleMachine.INSTANCE.getAllTranscriptText();
    }

    @NotNull
    public final String getAllTranslateText() {
        LogUtils.INSTANCE.d("TranscriptSubtitleView getAllTranslateText");
        return TranscriptSubtitleMachine.INSTANCE.getAllTranslateText();
    }

    public final void clear() {
        LogUtils.INSTANCE.d("TranscriptSubtitleView clear");
        TranscriptSubtitleMachine.INSTANCE.clear();
        this.invalidate(new ListChangeItem(0, 3));
    }
}

