/*
 * Decompiled with CFR 0.152.
 */
package io.agora.transcription_widget.internal.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.agora.transcription_widget.R;
import io.agora.transcription_widget.internal.model.TranscriptionData;
import io.agora.transcription_widget.internal.model.TranslateText;
import io.agora.transcription_widget.utils.Utils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010 \u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0005H\u0016J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0014\u0010,\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lio/agora/transcription_widget/internal/adapter/SubtitleAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/agora/transcription_widget/internal/adapter/SubtitleAdapter$SubtitleViewHolder;", "()V", "value", "", "finalTextColor", "getFinalTextColor", "()I", "setFinalTextColor", "(I)V", "items", "", "Lio/agora/transcription_widget/internal/model/TranscriptionData;", "nonFinalTextColor", "getNonFinalTextColor", "setNonFinalTextColor", "", "showTranscriptContent", "getShowTranscriptContent", "()Z", "setShowTranscriptContent", "(Z)V", "textAreaBackgroundColor", "getTextAreaBackgroundColor", "setTextAreaBackgroundColor", "", "textSize", "getTextSize", "()F", "setTextSize", "(F)V", "getItemCount", "onBindViewHolder", "", "holder", "position", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "MyItemDecoration", "SubtitleViewHolder", "transcription-widget_release"})
public final class SubtitleAdapter
extends RecyclerView.Adapter<SubtitleViewHolder> {
    @Nullable
    private List<TranscriptionData> items;
    private int finalTextColor = -16777216;
    private int nonFinalTextColor = -7829368;
    private float textSize = 15.0f;
    private int textAreaBackgroundColor = Color.argb((int)63, (int)0, (int)0, (int)0);
    private boolean showTranscriptContent = true;

    public final int getFinalTextColor() {
        return this.finalTextColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFinalTextColor(int value) {
        void var1_1;
        this.finalTextColor = var1_1;
        this.notifyDataSetChanged();
    }

    public final int getNonFinalTextColor() {
        return this.nonFinalTextColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNonFinalTextColor(int value) {
        void var1_1;
        this.nonFinalTextColor = var1_1;
        this.notifyDataSetChanged();
    }

    public final float getTextSize() {
        return this.textSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextSize(float value) {
        void var1_1;
        this.textSize = var1_1;
        this.notifyDataSetChanged();
    }

    public final int getTextAreaBackgroundColor() {
        return this.textAreaBackgroundColor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextAreaBackgroundColor(int value) {
        void var1_1;
        this.textAreaBackgroundColor = var1_1;
        this.notifyDataSetChanged();
    }

    public final boolean getShowTranscriptContent() {
        return this.showTranscriptContent;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShowTranscriptContent(boolean value) {
        void var1_1;
        this.showTranscriptContent = var1_1;
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SubtitleViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        void var1_1;
        ViewGroup viewGroup = parent;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        SubtitleAdapter subtitleAdapter = this = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_subtitle, (ViewGroup)var1_1, false);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)subtitleAdapter), (String)"view");
        return new SubtitleViewHolder((View)subtitleAdapter);
    }

    /*
     * WARNING - void declaration
     */
    public void onBindViewHolder(@NotNull SubtitleViewHolder holder, int position) {
        void var2_4;
        TranscriptionData transcriptionData;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"holder");
        List<TranscriptionData> list = this.items;
        if (list != null && (transcriptionData = list.get((int)var2_4)) != null) {
            SubtitleAdapter subtitleAdapter = this;
            int n = subtitleAdapter.finalTextColor;
            int n2 = subtitleAdapter.nonFinalTextColor;
            float f = subtitleAdapter.textSize;
            int n3 = subtitleAdapter.textAreaBackgroundColor;
            boolean bl = subtitleAdapter.showTranscriptContent;
            var1_2.bind(transcriptionData, n, n2, f, n3, bl);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onBindViewHolder(@NotNull SubtitleViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        void var2_4;
        TranscriptionData transcriptionData;
        List<TranscriptionData> list;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)list, (String)"payloads");
        list = this.items;
        if (list != null && (transcriptionData = list.get((int)var2_4)) != null) {
            SubtitleAdapter subtitleAdapter = this;
            int n = subtitleAdapter.finalTextColor;
            int n2 = subtitleAdapter.nonFinalTextColor;
            float f = subtitleAdapter.textSize;
            int n3 = subtitleAdapter.textAreaBackgroundColor;
            boolean bl = subtitleAdapter.showTranscriptContent;
            var1_2.bind(transcriptionData, n, n2, f, n3, bl);
            return;
        }
    }

    public int getItemCount() {
        List<TranscriptionData> this_ = ((SubtitleAdapter)((Object)this_)).items;
        return this_ != null ? this_.size() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void setItems(@NotNull List<TranscriptionData> items) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"items");
        this.items = var1_1;
        this.notifyDataSetChanged();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/agora/transcription_widget/internal/adapter/SubtitleAdapter$SubtitleViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "subtitleLayout", "Landroid/view/ViewGroup;", "kotlin.jvm.PlatformType", "transcriptText", "Landroid/widget/TextView;", "bind", "", "data", "Lio/agora/transcription_widget/internal/model/TranscriptionData;", "finalTextColor", "", "nonFinalTextColor", "textFontSize", "", "textAreaBackgroundColor", "showTranscriptContent", "", "transcription-widget_release"})
    public static final class SubtitleViewHolder
    extends RecyclerView.ViewHolder {
        private final ViewGroup subtitleLayout;
        @NotNull
        private final TextView transcriptText;

        /*
         * WARNING - void declaration
         */
        public SubtitleViewHolder(@NotNull View itemView) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"itemView");
            super((View)v0);
            this.subtitleLayout = (ViewGroup)var1_1.findViewById(R.id.subtitleLayout);
            View view = var1_1.findViewById(R.id.transcriptText);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.transcriptText)");
            this.transcriptText = (TextView)view;
        }

        /*
         * WARNING - void declaration
         */
        public final void bind(@NotNull TranscriptionData data, int finalTextColor, int nonFinalTextColor, float textFontSize, int textAreaBackgroundColor, boolean showTranscriptContent) {
            int n;
            void var4_4;
            void var3_3;
            void var2_2;
            int n2;
            int n3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
            ViewGroup viewGroup = this.subtitleLayout;
            Intrinsics.checkNotNullExpressionValue((Object)viewGroup, (String)"subtitleLayout");
            Utils.setRoundedBackground((View)viewGroup, n3, 20.0f);
            if (data.getTranslateTextList().isEmpty()) {
                n2 = this.subtitleLayout.getChildCount();
                for (n3 = 0; n3 < n2; ++n3) {
                    View view = this.subtitleLayout.getChildAt(n3);
                    if (view == null || view.getTag() == null) continue;
                    this.subtitleLayout.removeView(view);
                }
            }
            n3 = var1_1.getTranscriptText().isFinal() ? var2_2 : var3_3;
            SubtitleViewHolder subtitleViewHolder = this;
            subtitleViewHolder.transcriptText.setTextSize(2, (float)var4_4);
            subtitleViewHolder.transcriptText.setTextColor(n3);
            subtitleViewHolder.transcriptText.setText((CharSequence)var1_1.getTranscriptText().getText());
            Object object = subtitleViewHolder.transcriptText;
            n = n != 0 ? 0 : 8;
            object.setVisibility(n);
            object = var1_1.getTranslateTextList().iterator();
            n = 0;
            while (object.hasNext()) {
                block7: {
                    n2 = n + 1;
                    TranslateText translateText = (TranslateText)object.next();
                    void var9_13 = translateText.isFinal() ? var2_2 : var3_3;
                    int n4 = 0;
                    int n5 = this.subtitleLayout.getChildCount();
                    for (int i = 0; i < n5; ++i) {
                        View view = this.subtitleLayout.getChildAt(i);
                        if (view == null || !Intrinsics.areEqual((Object)view.getTag(), (Object)translateText.getLang())) continue;
                        n4 = 1;
                        if (!(view instanceof TextView)) continue;
                        TextView textView = (TextView)view;
                        textView.setText((CharSequence)translateText.getText());
                        textView.setTextSize(2, (float)var4_4);
                        textView.setTextColor((int)var9_13);
                        break block7;
                    }
                    if (n4 == 0) {
                        TextView textView;
                        TextView textView2 = textView;
                        new TextView(this.itemView.getContext()).setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                        if (n == CollectionsKt.getLastIndex(var1_1.getTranslateTextList())) {
                            Context context = this.itemView.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                            n4 = Utils.dpToPx(8, context);
                        } else {
                            Context context = this.itemView.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                            n4 = Utils.dpToPx(2, context);
                        }
                        TranslateText translateText2 = translateText;
                        TranslateText translateText3 = translateText;
                        TextView textView3 = textView2;
                        translateText = this.itemView.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)translateText, (String)"itemView.context");
                        int n6 = Utils.dpToPx(8, (Context)translateText);
                        SubtitleViewHolder subtitleViewHolder2 = this;
                        translateText = subtitleViewHolder2.itemView.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)translateText, (String)"itemView.context");
                        int n7 = Utils.dpToPx(2, (Context)translateText);
                        Context context = subtitleViewHolder2.itemView.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                        textView3.setPadding(n6, n7, Utils.dpToPx(8, context), n4);
                        textView3.setTextSize(2, (float)var4_4);
                        textView2.setText((CharSequence)translateText3.getText());
                        textView2.setTextColor((int)var9_13);
                        textView2.setTag((Object)translateText2.getLang());
                        this.subtitleLayout.addView((View)textView2);
                    }
                }
                n = n2;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/agora/transcription_widget/internal/adapter/SubtitleAdapter$MyItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "space", "", "(I)V", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "transcription-widget_release"})
    public static final class MyItemDecoration
    extends RecyclerView.ItemDecoration {
        private final int space;

        /*
         * WARNING - void declaration
         */
        public MyItemDecoration(int space) {
            void var1_1;
            this.space = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"outRect");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)var4_4, (String)"state");
            v0.left = 0;
            v0.right = 0;
            v0.bottom = 0;
            var1_1.top = this.space;
            if (parent.getChildAdapterPosition((View)var2_2) == 0) {
                var1_1.top = 0;
            }
        }
    }
}

