/*
 * Decompiled with CFR 0.152.
 */
package io.github.wiverson;

import io.github.wiverson.RunTool;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.moditect.commands.AddModuleInfo;

@Mojo(name="collect-modules", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ModuleUtilities
extends AbstractMojo {
    public final String GENERATE_INFO = "info";
    public final String GENERATE_OPEN = "open";
    private Log logger;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(required=true, defaultValue="${project.build.directory}/module-info-work")
    private File moduleInfoWorkDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/declared-modules")
    private File foundModulesDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/declared-not-modules")
    private File notModulesDirectory;
    @Parameter
    private List<File> providedModuleDirectories;
    @Parameter(alias="ignoreJars")
    private List<String> ignoreJars;
    @Parameter(alias="stripJars")
    private List<String> stripJars;
    @Parameter
    private int javaVersion = Runtime.version().feature();
    @Parameter
    private boolean debug;
    @Parameter(name="autoClean", defaultValue="true")
    private boolean autoClean;
    @Parameter
    private Properties moduleInfoOverrides;
    @Parameter(defaultValue="false")
    private boolean skip = false;

    public void setLog(Log log) {
        this.logger = log;
    }

    private boolean isModule(JarFile jar) {
        ZipEntry zipEntry = jar.getEntry("module-info.class");
        if (zipEntry != null) {
            return true;
        }
        zipEntry = jar.getEntry("META-INF/versions");
        if (zipEntry == null) {
            return false;
        }
        for (int i = 8; i < this.javaVersion; ++i) {
            zipEntry = jar.getEntry("META-INF/versions/" + i + "/module-info.class");
            if (zipEntry == null) continue;
            return true;
        }
        return false;
    }

    private void stripModuleInfo(File jarFile) throws IOException {
        if (this.debug) {
            this.logger.info((CharSequence)"Removing module-info...");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "false");
        URI fileUri = jarFile.toURI();
        URI uri = URI.create("jar:" + fileUri.toString());
        ArrayList<Object> removeList = new ArrayList<Object>();
        removeList.add("module-info.class");
        for (int i = 8; i < this.javaVersion; ++i) {
            removeList.add("META-INF/versions/" + i + "/module-info.class");
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            for (String string : removeList) {
                if (!Files.exists(zipfs.getPath(string, new String[0]), new LinkOption[0])) continue;
                Files.delete(zipfs.getPath(string, new String[0]));
                if (!this.debug) continue;
                this.logger.info((CharSequence)("Removed " + string));
            }
        }
    }

    private void generateModuleInfo(File jarFile) throws MojoExecutionException, IOException {
        String provided = this.isProvided(jarFile);
        if (provided != null) {
            String basePath = this.moduleInfoWorkDirectory.getAbsolutePath() + File.separatorChar + jarFile.getName().replace(".jar", "");
            basePath = basePath + "copied" + File.separatorChar + "versions" + File.separatorChar + this.javaVersion + File.separatorChar;
            FileUtils.copyFileToDirectory((String)provided, (String)basePath);
            if (this.debug) {
                this.logger.info((CharSequence)("Copied " + provided + " to " + basePath));
            }
            return;
        }
        RunTool runTool = new RunTool(this.getLog(), this.debug, this.debug, true);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--ignore-missing-deps");
        arguments.add("--add-modules=ALL-MODULE-PATH");
        arguments.add("--multi-release");
        arguments.add(Integer.toString(this.javaVersion));
        arguments.add("--module-path");
        arguments.add(this.buildModulesDirectory());
        if (this.isGenerated(jarFile)) {
            arguments.add("--generate-module-info");
        } else {
            arguments.add("--generate-open-module");
        }
        arguments.add(this.moduleInfoWorkDirectory.getAbsolutePath() + File.separatorChar + jarFile.getName().replace(".jar", ""));
        arguments.add(jarFile.getAbsolutePath());
        if (this.debug) {
            for (String s : arguments) {
                this.logger.info((CharSequence)s);
            }
        }
        runTool.runTool("jdeps", arguments, true);
    }

    private boolean isGenerated(File jarFile) {
        for (Object key : this.moduleInfoOverrides.keySet()) {
            String keyString = key.toString();
            if (!jarFile.getName().contains(keyString) || "info".compareToIgnoreCase(this.moduleInfoOverrides.get(key).toString()) != 0) continue;
            return true;
        }
        return false;
    }

    private String isProvided(File jarFile) {
        for (Object key : this.moduleInfoOverrides.keySet()) {
            String keyString = key.toString();
            if (!jarFile.getName().contains(keyString)) continue;
            if ("info".compareToIgnoreCase(this.moduleInfoOverrides.get(key).toString()) == 0) {
                return null;
            }
            if ("open".compareToIgnoreCase(this.moduleInfoOverrides.get(key).toString()) == 0) {
                return null;
            }
            return this.moduleInfoOverrides.get(key).toString();
        }
        return null;
    }

    private void addModuleInfo(File jarFile) throws IOException {
        AddModuleInfo addModuleInfo = new AddModuleInfo(this.findModInfo(jarFile), null, Integer.toString(1), jarFile.toPath(), this.notModulesDirectory.toPath(), null, true);
        addModuleInfo.run();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.autoClean) {
            this.cleanUp();
        }
        ArrayList<File> needsModuleInfo = new ArrayList<File>();
        this.checkCustomProperties();
        int foundModules = 0;
        int foundWithoutModules = 0;
        int strippedModules = 0;
        for (String s : this.compilePath) {
            File entry = new File(s);
            if (entry.isDirectory()) continue;
            try {
                JarFile jarFile = new JarFile(entry);
                if (this.matches(jarFile, this.ignoreJars, "ignoreJars")) continue;
                if (this.isModule(jarFile)) {
                    if (this.debug) {
                        this.logger.info((CharSequence)(s + " IS a module"));
                    }
                    ++foundModules;
                    FileUtils.copyFileToDirectory((File)entry, (File)this.foundModulesDirectory);
                    if (this.matches(jarFile, this.stripJars, "stripJars")) {
                        File newFile = new File(this.foundModulesDirectory, entry.getName());
                        ++strippedModules;
                        if (this.debug) {
                            this.logger.info((CharSequence)("Stripping info from " + newFile.getAbsolutePath()));
                        }
                        this.stripModuleInfo(newFile);
                        needsModuleInfo.add(newFile);
                        continue;
                    }
                    if (!this.debug) continue;
                    this.logger.info((CharSequence)(jarFile.getName() + " didn't match strip"));
                    continue;
                }
                if (this.debug) {
                    this.logger.info((CharSequence)(s + " is NOT a module, generating module info"));
                }
                FileUtils.copyFileToDirectory((File)entry, (File)this.notModulesDirectory);
                File added = new File(this.notModulesDirectory, entry.getName());
                ++foundWithoutModules;
                needsModuleInfo.add(added);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
                throw new MojoFailureException(e.getMessage());
            }
        }
        for (File jar : needsModuleInfo) {
            try {
                if (this.debug) {
                    this.logger.info((CharSequence)("Generating info for " + jar.getName()));
                }
                this.generateModuleInfo(jar);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
                throw new MojoFailureException(e.getMessage());
            }
        }
        for (File jar : needsModuleInfo) {
            try {
                if (this.debug) {
                    this.logger.info((CharSequence)("Adding info for " + jar.getName()));
                }
                this.addModuleInfo(jar);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
                throw new MojoFailureException(e.getMessage());
            }
        }
        this.logger.info((CharSequence)("Found " + foundModules + " modular jars (stripped " + strippedModules + ") and " + foundWithoutModules + " ordinary jars."));
    }

    private void checkCustomProperties() throws MojoFailureException {
        Iterator<Object> iterator;
        if (this.moduleInfoOverrides == null) {
            this.moduleInfoOverrides = new Properties();
        }
        if ((iterator = this.moduleInfoOverrides.keySet().iterator()).hasNext()) {
            File file;
            Object key = iterator.next();
            Object value = this.moduleInfoOverrides.get(key);
            if (value == null) {
                throw new MojoFailureException("Set " + key.toString() + " but missing value");
            }
            String valueString = value.toString();
            if (!("info".compareToIgnoreCase(valueString) == 0 || "open".compareToIgnoreCase(valueString) == 0 || (file = new File(valueString)).exists() && file.isFile() && file.getName().compareToIgnoreCase("module-info.java") == 0)) {
                throw new MojoFailureException("Set " + key.toString() + " but value should be [open,info] or a valid path to a module-info.java file.");
            }
        }
    }

    private void cleanUp() throws MojoFailureException {
        List<File> toClean = List.of(this.moduleInfoWorkDirectory, this.foundModulesDirectory, this.notModulesDirectory);
        for (File clean : toClean) {
            try {
                if (!clean.exists()) continue;
                Files.walk(clean.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
                clean.mkdirs();
                if (!this.debug) continue;
                this.logger.info((CharSequence)("Reset directory " + clean.getAbsolutePath()));
            }
            catch (IOException ioException) {
                this.logger.error((Throwable)ioException);
                throw new MojoFailureException(ioException.getMessage());
            }
        }
    }

    private String buildModulesDirectory() {
        StringBuilder result = new StringBuilder();
        result.append(this.foundModulesDirectory.getAbsolutePath());
        result.append(File.pathSeparator);
        result.append(this.notModulesDirectory.getAbsolutePath());
        if (this.providedModuleDirectories.size() > 0) {
            for (File file : this.providedModuleDirectories) {
                result.append(File.pathSeparator);
                result.append(file.getAbsolutePath());
            }
        }
        return result.toString();
    }

    private String findModInfo(File jar) throws IOException {
        String matchName = jar.getName().replace("-", ".");
        if (this.moduleInfoWorkDirectory == null) {
            throw new IOException("No module info output directory set");
        }
        if (!this.moduleInfoWorkDirectory.exists()) {
            Files.createDirectories(this.moduleInfoWorkDirectory.toPath(), new FileAttribute[0]);
        }
        if (!this.moduleInfoWorkDirectory.isDirectory()) {
            throw new IOException("module info output directory is not a directory");
        }
        try {
            File moduleInfoLocation = new File(this.moduleInfoWorkDirectory.getAbsolutePath() + File.separatorChar + jar.getName().replace(".jar", ""));
            File generatedInfo = moduleInfoLocation.listFiles()[0].listFiles()[0].listFiles()[0].listFiles()[0];
            return Files.readString(Path.of(generatedInfo.getAbsolutePath(), new String[0]), StandardCharsets.US_ASCII);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Unable to find a module info for " + jar);
        }
    }

    private boolean matches(JarFile jarFile, List<String> matcher, String description) {
        if (matcher == null && this.debug) {
            this.logger.warn((CharSequence)("No matcher for " + description + " defined"));
        }
        if (matcher != null) {
            for (String s : matcher) {
                if (!jarFile.getName().contains(s)) continue;
                return true;
            }
        }
        return false;
    }
}

