/*
 * Decompiled with CFR 0.152.
 */
package io.github.wiverson;

import io.github.wiverson.ToolProviderAdapterCore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.spi.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class RunTool {
    private final Log log;
    private boolean writeOutputToLog;
    private boolean writeErrorsToLog;
    public boolean failed;
    public int errorCode;
    public boolean echoArguments = false;

    public RunTool(Log log, boolean echoArguments, boolean writeOutputToLog, boolean writeErrorsToLog) {
        this.log = log;
        this.writeOutputToLog = writeOutputToLog;
        this.writeErrorsToLog = writeErrorsToLog;
        this.echoArguments = echoArguments;
    }

    public RunTool(Log log, boolean echoArguments) {
        this.log = log;
        this.writeErrorsToLog = true;
        this.writeOutputToLog = true;
        this.echoArguments = echoArguments;
    }

    protected void log(String entry, ToolProviderAdapterCore.LogLevel level) {
        if (this.log != null) {
            switch (level) {
                case WARN: {
                    this.log.warn((CharSequence)entry);
                    break;
                }
                case INFO: {
                    this.log.info((CharSequence)entry);
                    break;
                }
                case ERROR: {
                    this.log.error((CharSequence)entry);
                    break;
                }
                case DEBUG: {
                    this.log.debug((CharSequence)entry);
                }
            }
        } else {
            switch (level) {
                case WARN: 
                case INFO: {
                    if (!this.writeOutputToLog) break;
                    System.out.println(entry);
                    break;
                }
                case ERROR: {
                    if (!this.writeErrorsToLog) break;
                    System.err.println("ERROR>" + entry);
                    break;
                }
                case DEBUG: {
                    if (!this.writeOutputToLog) break;
                    System.out.println("DEBUG>" + entry);
                }
            }
        }
    }

    protected ToolProvider result(String toolname) {
        Optional<ToolProvider> result = ToolProvider.findFirst(toolname);
        if (result.isPresent()) {
            ToolProvider t = result.get();
            return result.get();
        }
        this.log("No " + toolname + " found", ToolProviderAdapterCore.LogLevel.ERROR);
        this.failed = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTool(String toolName, List<String> args, boolean failOnError) throws MojoExecutionException {
        this.errorCode = -1;
        ToolProvider tool = this.result(toolName);
        if (tool == null) {
            if (failOnError) {
                throw new MojoExecutionException("Unable to find ToolProvider [" + toolName + "]");
            }
            this.log("Unable to find ToolProvider [" + toolName + "]", ToolProviderAdapterCore.LogLevel.ERROR);
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        String utf8 = StandardCharsets.UTF_8.name();
        try (PrintStream output = new PrintStream((OutputStream)outputStream, true, utf8);){
            try (PrintStream error = new PrintStream((OutputStream)outputStream, true, utf8);){
                this.errorCode = tool.run(output, error, args.toArray(new String[0]));
            }
            finally {
                errorStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.errorCode != 0) {
            this.log(toolName + " failed with error code [" + this.errorCode + "]", ToolProviderAdapterCore.LogLevel.ERROR);
            for (String arg : args) {
                this.log("   " + arg, ToolProviderAdapterCore.LogLevel.ERROR);
            }
        } else if (this.echoArguments) {
            for (String arg : args) {
                this.log("   " + arg, ToolProviderAdapterCore.LogLevel.INFO);
            }
        }
        String normalOutput = null;
        String errorOutput = null;
        try {
            String output = outputStream.toString(utf8);
            String error = errorStream.toString(utf8);
            if (output.endsWith("\n")) {
                output = output.substring(0, output.length() - 1);
            }
            if (error.endsWith("\n")) {
                error = output.substring(0, output.length() - 1);
            }
            if (output.length() > 0) {
                normalOutput = output;
            }
            if (error.length() > 0) {
                errorOutput = error;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if ((this.writeOutputToLog || this.errorCode != 0) && normalOutput != null && normalOutput.length() > 0) {
            this.log(normalOutput, ToolProviderAdapterCore.LogLevel.INFO);
        }
        if ((this.writeErrorsToLog || this.errorCode != 0) && errorOutput != null && errorOutput.length() > 0) {
            this.log(errorOutput, ToolProviderAdapterCore.LogLevel.ERROR);
        }
        if (failOnError && this.errorCode != 0) {
            throw new MojoExecutionException(toolName + " " + this.errorCode);
        }
    }
}

