/*
 * Decompiled with CFR 0.152.
 */
package io.github.wiverson;

import io.github.wiverson.RunTool;
import io.github.wiverson.ToolProviderAdapterCore;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="java-tool")
public class ToolProviderAdapterHints
extends ToolProviderAdapterCore {
    public static final String CLASS_PATH = "class-path";
    public static final String MODULE_PATH = "module-path";
    public static final String ADD_MODULES = "add-modules";
    public static final String GENERATE_MODULE_INFO = "generate-module-info";
    public static final String LAUNCHER = "launcher";
    public static final String OUTPUT = "output";
    public static final String JLINK_OPTIONS = "jlink-options";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String MODULE = "module";
    public static final String DEST = "dest";
    public static final String TYPE = "type";
    public static final String WIN_MENU_GROUP = "win-menu-group";
    public static final String APP_VERSION = "app-version";
    public static final String COPYRIGHT = "copyright";
    public static final String DESCRIPTION = "description";
    public static final String TEMP = "temp";
    public static final String VENDOR = "vendor";
    public static final String RUNTIME_IMAGE = "runtime-image";
    public static final String INPUT = "input";
    public static final String JAVA_OPTIONS = "java-options";
    public static final String MAIN_JAR = "main-jar";
    public static final String MAC_PACKAGE_IDENTIFIER = "mac-package-identifier";
    public static final String MAC_PACKAGE_NAME = "mac-package-name";
    public static final String MAC_PACKAGE_SIGNING_PREFIX = "mac-package-signing-prefix";
    public static final String MAC_SIGNING_KEYCHAIN = "mac-signing-keychain";
    public static final String MAC_SIGNING_KEY_USER_NAME = "mac-signing-key-user-name";
    public static final String APP_IMAGE = "app-image";
    public static final String FILE_ASSOCIATIONS = "file-associations";
    public static final String INSTALL_DIR = "install-dir";
    public static final String LICENSE_FILE = "license-file";
    public static final String RESOURCE_DIR = "resource-dir";
    public static final String UPGRADE_MODULE_PATH = "upgrade-module-path";
    public static final String SYSTEM = "system";
    public static final String MULTI_RELEASE = "multi-release";
    public static final String GENERATE_OPEN_MODULE = "generate-open-module";
    public static final String CHECK = "check";
    public static final String REGEX = "regex";
    public static final String REQUIRE = "require";
    public static final String COMPRESS = "compress";
    public static final String DISABLE_PLUGIN = "disable-plugin";
    public static final String LIMIT_MODULES = "limit-modules";
    public static final String POST_PROCESS_PATH = "post-process-path";
    public static final String RESOURCES_LAST_SORTER = "resources-last-sorter";
    public static final String SAVE_OPTS = "save-opts";
    public static final String SUGGEST_PROVIDERS = "suggest-providers";
    public static final String DIR = "dir";
    public static final String EXCLUDE = "exclude";
    public static final String HASH_MODULES = "hash-modules";
    public static final String HEADER_FILES = "header-files";
    @Parameter(property="class-path")
    public String classPath = "";
    @Parameter(property="module-path")
    public String modulePath = "";
    @Parameter(property="add-modules")
    public String addModules = "";
    @Parameter(property="generate-module-info")
    public String generateModuleInfo = "";
    @Parameter(property="launcher")
    public String launcher = "";
    @Parameter(property="output")
    public String output = "";
    @Parameter(property="jlink-options")
    public String jlinkOptions = "";
    @Parameter(property="name")
    public String name = "";
    @Parameter(property="icon")
    public String icon = "";
    @Parameter(property="module")
    public String module = "";
    @Parameter(property="dest")
    public String dest = "";
    @Parameter(property="type")
    public String type = "";
    @Parameter(property="win-menu-group")
    public String winMenuGroup = "";
    @Parameter(property="app-version")
    public String appVersion = "";
    @Parameter(property="copyright")
    public String copyright = "";
    @Parameter(property="description")
    public String description = "";
    @Parameter(property="temp")
    public String temp = "";
    @Parameter(property="vendor")
    public String vendor = "";
    @Parameter(property="runtime-image")
    public String runtimeImage = "";
    @Parameter(property="input")
    public String input = "";
    @Parameter(property="java-options")
    public String javaOptions = "";
    @Parameter(property="main-jar")
    public String mainJar = "";
    @Parameter(property="mac-package-identifier")
    public String macPackageIdentifier = "";
    @Parameter(property="mac-package-name")
    public String macPackageName = "";
    @Parameter(property="mac-package-signing-prefix")
    public String macPackageSigningPrefix = "";
    @Parameter(property="mac-signing-keychain")
    public String macSigningKeychain = "";
    @Parameter(property="mac-signing-key-user-name")
    public String macSigningKeyUserName = "";
    @Parameter(property="app-image")
    public String appImage = "";
    @Parameter(property="file-associations")
    public String fileAssociations = "";
    @Parameter(property="install-dir")
    public String installDir = "";
    @Parameter(property="license-file")
    public String licenseFile = "";
    @Parameter(property="resource-dir")
    public String resourceDir = "";
    @Parameter(property="upgrade-module-path")
    public String upgradeModulePath = "";
    @Parameter(property="system")
    public String system = "";
    @Parameter(property="multi-release")
    public String multiRelease = "";
    @Parameter(property="generate-open-module")
    public String generateOpenModule = "";
    @Parameter(property="check")
    public String check = "";
    @Parameter(property="regex")
    public String regex = "";
    @Parameter(property="require")
    public String require = "";
    @Parameter(property="compress")
    public String compress = "";
    @Parameter(property="disable-plugin")
    public String disablePlugin = "";
    @Parameter(property="limit-modules")
    public String limitModules = "";
    @Parameter(property="post-process-path")
    public String postProcessPath = "";
    @Parameter(property="resources-last-sorter")
    public String resourcesLastSorter = "";
    @Parameter(property="save-opts")
    public String saveOpts = "";
    @Parameter(property="suggest-providers")
    public String suggestProviders = "";
    @Parameter(property="dir")
    public String dir = "";
    @Parameter(property="exclude")
    public String exclude = "";
    @Parameter(property="hash-modules")
    public String hashModules = "";
    @Parameter(property="header-files")
    public String headerFiles = "";
    @Parameter
    public List<File> cleanDirectories;
    @Parameter
    public List<File> removeDirectories;
    @Parameter(defaultValue="false")
    private boolean skip = false;
    private boolean failed;

    private void add(List<String> list, String arg, String value) {
        if (value == null) {
            return;
        }
        if (value.isEmpty()) {
            return;
        }
        list.add("--" + arg);
        list.add(value);
    }

    public List<String> addShortcutArguments() {
        ArrayList<String> result = new ArrayList<String>();
        this.add(result, CLASS_PATH, this.classPath);
        this.add(result, ADD_MODULES, this.addModules);
        this.add(result, APP_IMAGE, this.appImage);
        this.add(result, APP_VERSION, this.appVersion);
        this.add(result, CHECK, this.check);
        this.add(result, COMPRESS, this.compress);
        this.add(result, COPYRIGHT, this.copyright);
        this.add(result, DESCRIPTION, this.description);
        this.add(result, DEST, this.dest);
        this.add(result, DIR, this.dir);
        this.add(result, DISABLE_PLUGIN, this.disablePlugin);
        this.add(result, EXCLUDE, this.exclude);
        this.add(result, FILE_ASSOCIATIONS, this.fileAssociations);
        this.add(result, GENERATE_MODULE_INFO, this.generateModuleInfo);
        this.add(result, GENERATE_OPEN_MODULE, this.generateOpenModule);
        this.add(result, HASH_MODULES, this.hashModules);
        this.add(result, HEADER_FILES, this.headerFiles);
        this.add(result, ICON, this.icon);
        this.add(result, INPUT, this.input);
        this.add(result, INSTALL_DIR, this.installDir);
        this.add(result, JAVA_OPTIONS, this.javaOptions);
        this.add(result, JLINK_OPTIONS, this.jlinkOptions);
        this.add(result, LAUNCHER, this.launcher);
        this.add(result, LICENSE_FILE, this.licenseFile);
        this.add(result, LIMIT_MODULES, this.limitModules);
        this.add(result, MAC_PACKAGE_IDENTIFIER, this.macPackageIdentifier);
        this.add(result, MAC_PACKAGE_NAME, this.macPackageName);
        this.add(result, MAC_PACKAGE_SIGNING_PREFIX, this.macPackageSigningPrefix);
        this.add(result, MAC_SIGNING_KEY_USER_NAME, this.macSigningKeyUserName);
        this.add(result, MAC_SIGNING_KEYCHAIN, this.macSigningKeychain);
        this.add(result, MAIN_JAR, this.mainJar);
        this.add(result, MODULE_PATH, this.modulePath);
        this.add(result, MODULE, this.module);
        this.add(result, MULTI_RELEASE, this.multiRelease);
        this.add(result, NAME, this.name);
        this.add(result, OUTPUT, this.output);
        this.add(result, POST_PROCESS_PATH, this.postProcessPath);
        this.add(result, REGEX, this.regex);
        this.add(result, REQUIRE, this.require);
        this.add(result, RESOURCE_DIR, this.resourceDir);
        this.add(result, RESOURCES_LAST_SORTER, this.resourcesLastSorter);
        this.add(result, RUNTIME_IMAGE, this.runtimeImage);
        this.add(result, SAVE_OPTS, this.saveOpts);
        this.add(result, SUGGEST_PROVIDERS, this.suggestProviders);
        this.add(result, SYSTEM, this.system);
        this.add(result, TEMP, this.temp);
        this.add(result, TYPE, this.type);
        this.add(result, UPGRADE_MODULE_PATH, this.upgradeModulePath);
        this.add(result, VENDOR, this.vendor);
        this.add(result, WIN_MENU_GROUP, this.winMenuGroup);
        return result;
    }

    public boolean failed() {
        return this.failed;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        this.clean(this.cleanDirectories, true);
        this.clean(this.removeDirectories, false);
        RunTool runTool = new RunTool(this.getLog(), this.debug, this.writeOutputToLog, this.writeErrorsToLog);
        List<String> arguments = this.addShortcutArguments();
        arguments.addAll(Arrays.asList(this.args));
        runTool.runTool(this.toolName, arguments, this.failOnError);
        this.errorCode = runTool.errorCode;
        this.failed = runTool.failed;
    }

    private void clean(List<File> directory, boolean replace) throws MojoFailureException {
        if (directory == null) {
            return;
        }
        if (directory.size() == 0) {
            return;
        }
        for (File clean : directory) {
            try {
                if (!clean.exists()) continue;
                Files.walk(clean.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
                if (replace) {
                    clean.mkdirs();
                }
                if (!this.debug) continue;
                if (replace) {
                    this.getLog().info((CharSequence)("Cleaned directory " + clean.getAbsolutePath()));
                    continue;
                }
                this.getLog().info((CharSequence)("Reset directory " + clean.getAbsolutePath()));
            }
            catch (IOException ioException) {
                this.getLog().error((Throwable)ioException);
                throw new MojoFailureException(ioException.getMessage());
            }
        }
    }
}

