/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.elements.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pitest.classinfo.ClassInfo;
import org.pitest.mutationtest.MutationResult;

public class MutationTestSummaryData {
    private final String fileName;
    private final Collection<MutationResult> mutations = new ArrayList<MutationResult>();
    private final Set<ClassInfo> classes = new HashSet<ClassInfo>();

    public MutationTestSummaryData(String fileName, Collection<MutationResult> results, Collection<ClassInfo> classes) {
        this.fileName = fileName;
        this.mutations.addAll(results);
        this.classes.addAll(classes);
    }

    public String getPackageName() {
        String packageName = this.classes.iterator().next().getName().asJavaName().replace(".", "/");
        int lastSlash = packageName.lastIndexOf(47);
        return lastSlash > 0 ? packageName.substring(0, lastSlash) : "default";
    }

    public void addTestSummary(MutationTestSummaryData data) {
        this.mutations.addAll(data.mutations);
        this.classes.addAll(data.classes);
    }

    public String getFileName() {
        return this.fileName;
    }

    public Collection<MutationResult> getResults() {
        return this.mutations;
    }

    public Collection<ClassInfo> getClasses() {
        return this.classes;
    }
}

