/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.elements.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pitest.classinfo.ClassInfo;
import org.pitest.elements.models.Line;
import org.pitest.elements.models.MutationTestSummaryData;
import org.pitest.elements.models.PackageSummaryData;
import org.pitest.elements.models.PackageSummaryMap;
import org.pitest.elements.models.json.JsonFile;
import org.pitest.elements.models.json.JsonLocation;
import org.pitest.elements.models.json.JsonMutant;
import org.pitest.elements.models.json.JsonMutantStatus;
import org.pitest.elements.models.json.JsonReport;
import org.pitest.elements.utils.LineFactory;
import org.pitest.elements.utils.MutationIdCounter;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.SourceLocator;

public class JsonParser {
    private final Collection<SourceLocator> sourceRoots;
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final MutationIdCounter mutationIdCounter = new MutationIdCounter();

    public JsonParser(Collection<SourceLocator> sourceRoots) {
        this.sourceRoots = sourceRoots;
    }

    public String toJson(PackageSummaryMap packageSummaryMap) throws IOException {
        this.mutationIdCounter.reset();
        HashMap<String, JsonFile> collectedJsonFiles = new HashMap<String, JsonFile>();
        List<PackageSummaryData> sortedPackageData = packageSummaryMap.valuesList();
        Collections.sort(sortedPackageData);
        for (PackageSummaryData packageData : sortedPackageData) {
            for (MutationTestSummaryData testData : packageData.getSummaryData()) {
                this.addToJsonFiles(collectedJsonFiles, testData);
            }
        }
        JsonReport report = new JsonReport(collectedJsonFiles);
        return this.gson.toJson((Object)report, JsonReport.class);
    }

    private void addToJsonFiles(Map<String, JsonFile> collectedJsonFiles, MutationTestSummaryData data) throws IOException {
        List<Line> lines = this.getLines(data);
        String fullPath = data.getPackageName() + "/" + data.getFileName();
        if (collectedJsonFiles.get(fullPath) == null) {
            collectedJsonFiles.put(fullPath, new JsonFile());
        }
        JsonFile file = collectedJsonFiles.get(fullPath);
        file.addSource(this.getSourceFromLines(lines));
        file.addMutants(this.getMutantsFromLines(lines, data));
    }

    private List<JsonMutant> getMutantsFromLines(List<Line> lines, MutationTestSummaryData data) {
        ArrayList<JsonMutant> jsonMutants = new ArrayList<JsonMutant>();
        if (lines.isEmpty()) {
            for (MutationResult mutationResult : data.getResults()) {
                jsonMutants.add(this.mapToJsonMutant(mutationResult, JsonLocation.empty()));
            }
        } else {
            for (Line line : lines) {
                for (MutationResult mutationResult : line.getMutations()) {
                    jsonMutants.add(this.mapToJsonMutant(mutationResult, JsonLocation.ofLine(line)));
                }
            }
        }
        return jsonMutants;
    }

    private String getSourceFromLines(List<Line> lines) {
        if (lines.isEmpty()) {
            return "   ";
        }
        StringBuilder builder = new StringBuilder();
        for (Line line : lines) {
            builder.append(line.getText());
            builder.append("\n");
        }
        return builder.toString();
    }

    private List<Line> getLines(MutationTestSummaryData summaryData) throws IOException {
        String fileName = summaryData.getFileName();
        Collection<ClassInfo> classes = summaryData.getClasses();
        Optional<Reader> reader = this.findReaderForSource(classes, fileName);
        if (reader.isPresent()) {
            LineFactory lineFactory = new LineFactory(summaryData.getResults());
            return lineFactory.convert(reader.get());
        }
        return Collections.emptyList();
    }

    private Optional<Reader> findReaderForSource(Collection<ClassInfo> classes, String fileName) {
        for (SourceLocator each : this.sourceRoots) {
            Optional maybe = each.locate(this.classInfoToNames(classes), fileName);
            if (!maybe.isPresent()) continue;
            return maybe;
        }
        return Optional.empty();
    }

    private Collection<String> classInfoToNames(Collection<ClassInfo> classes) {
        return FCollection.map(classes, a -> a.getName().asJavaName());
    }

    private JsonMutant mapToJsonMutant(MutationResult mutation, JsonLocation location) {
        String fullMutatorName = mutation.getDetails().getMutator();
        String mutatorName = fullMutatorName.substring(fullMutatorName.lastIndexOf(".") + 1);
        JsonMutantStatus status = JsonMutantStatus.fromPitestStatus(mutation.getStatus());
        return new JsonMutant(Integer.toString(this.mutationIdCounter.next()), mutatorName, mutation.getDetails().getDescription(), location, status);
    }
}

