/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.elements.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.elements.models.Line;
import org.pitest.elements.utils.InputStreamLineIterable;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;

public class LineFactory {
    private final Collection<MutationResult> mutations;

    public LineFactory(Collection<MutationResult> mutations) {
        this.mutations = mutations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Line> convert(Reader source) throws IOException {
        try {
            InputStreamLineIterable lines = new InputStreamLineIterable(source);
            List list = FCollection.map((Iterable)lines, this.stringToAnnotatedLine());
            return list;
        }
        finally {
            source.close();
        }
    }

    private Function<String, Line> stringToAnnotatedLine() {
        return new Function<String, Line>(){
            private int lineNumber = 1;

            @Override
            public Line apply(String a) {
                Line l = new Line(this.lineNumber, a, LineFactory.this.getMutationsForLine(this.lineNumber));
                ++this.lineNumber;
                return l;
            }
        };
    }

    private List<MutationResult> getMutationsForLine(int lineNumber) {
        return this.mutations.stream().filter(this.isAtLineNumber(lineNumber)).collect(Collectors.toList());
    }

    private Predicate<MutationResult> isAtLineNumber(int lineNumber) {
        return result -> result.getDetails().getLineNumber() == lineNumber;
    }
}

