/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.elements.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pitest.coverage.ClassLines;
import org.pitest.mutationtest.MutationResult;

public class MutationTestSummaryData {
    private final String fileName;
    private final Collection<MutationResult> mutations = new ArrayList<MutationResult>();
    private final Set<ClassLines> classLines = new HashSet<ClassLines>();

    public MutationTestSummaryData(String fileName, Collection<MutationResult> results, Collection<ClassLines> classLines) {
        this.fileName = fileName;
        this.mutations.addAll(results);
        this.classLines.addAll(classLines);
    }

    public String getPackageName() {
        String packageName = this.classLines.iterator().next().name().asJavaName().replace(".", "/");
        int lastSlash = packageName.lastIndexOf(47);
        return lastSlash > 0 ? packageName.substring(0, lastSlash) : "default";
    }

    public void addTestSummary(MutationTestSummaryData data) {
        this.mutations.addAll(data.mutations);
        this.classLines.addAll(data.classLines);
    }

    public String getFileName() {
        return this.fileName;
    }

    public Collection<MutationResult> getResults() {
        return this.mutations;
    }

    public Collection<ClassLines> getClassLines() {
        return this.classLines;
    }
}

