/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.elements.models.json;

import org.pitest.elements.models.Line;
import org.pitest.elements.models.json.LineAndColumn;

public class JsonLocation {
    private LineAndColumn start;
    private LineAndColumn end;

    public JsonLocation(LineAndColumn start, LineAndColumn end) {
        this.start = start;
        this.end = end;
    }

    public static JsonLocation ofLine(Line line) {
        LineAndColumn start = new LineAndColumn((int)line.getNumber(), 1 + JsonLocation.indexOfFirstNonWhitespace(line.getText()));
        LineAndColumn end = new LineAndColumn((int)line.getNumber(), line.getText().length());
        return new JsonLocation(start, end);
    }

    private static int indexOfFirstNonWhitespace(String text) {
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.isWhitespace(charArray[i])) continue;
            return i;
        }
        return 0;
    }

    public static JsonLocation empty() {
        return new JsonLocation(new LineAndColumn(1, 1), new LineAndColumn(1, 2));
    }
}

