/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileUtil {
    FileUtil() {
    }

    static void ensureParentDirExists(File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
            throw new BuildException("Failed to create directory " + parent.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(String fromResource, File to) throws BuildException {
        int bufferSize = 8192;
        FileUtil.ensureParentDirExists(to);
        InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(fromResource);
        if (in == null) {
            throw new BuildException("Resource not found: " + fromResource);
        }
        try {
            in = new BufferedInputStream(in, bufferSize);
            byte[] buffer = new byte[bufferSize];
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to), bufferSize);
            try {
                int read;
                while ((read = in.read(buffer, 0, bufferSize)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
                ((OutputStream)out).flush();
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new BuildException("Error copying resource " + fromResource, (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<Node> getClasspathEntriesOfKind(File baseDir, String desiredKind) throws SAXException, IOException, ParserConfigurationException {
        LinkedList<Node> classpathEntryNodes = new LinkedList<Node>();
        File classpathFile = new File(baseDir, ".classpath");
        if (!classpathFile.exists()) {
            throw new BuildException("You specified eclipse = 'true', but " + classpathFile + " does not exist.");
        }
        Document classpathDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(classpathFile);
        classpathDocument.normalize();
        NodeList classpathentries = classpathDocument.getElementsByTagName("classpathentry");
        for (int classpathentryNum = 0; classpathentryNum < classpathentries.getLength(); ++classpathentryNum) {
            Node classpathentry = classpathentries.item(classpathentryNum);
            NamedNodeMap attributes = classpathentry.getAttributes();
            Node kindAttribute = attributes.getNamedItem("kind");
            String kind = kindAttribute.getTextContent();
            if (!desiredKind.equals(kind)) continue;
            classpathEntryNodes.add(classpathentry);
        }
        return classpathEntryNodes;
    }
}

