/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.ManifestTask;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplication;
import org.objectstyle.woproject.ant.JApplicationWorker;

class JApplicationJavaWorker
implements JApplicationWorker {
    protected JApplication task;
    protected File baseDir;
    protected File scratchDir;
    protected Collection unpackedJarDirs;
    protected File manifestFile;

    JApplicationJavaWorker() {
    }

    public void execute(JApplication task) throws BuildException {
        this.task = task;
        this.baseDir = task.getDestDir();
        this.unpackedJarDirs = new ArrayList();
        try {
            this.executeInternal();
        }
        finally {
            if (!this.recursiveDelete(this.scratchDir)) {
                throw new BuildException("Failed to clean up temp directory: " + this.scratchDir);
            }
        }
    }

    protected void executeInternal() throws BuildException {
        this.createDirectories();
        this.createManifest();
        this.unpackJars();
        this.createFatJar();
    }

    void createManifest() throws BuildException {
        this.manifestFile = new File(this.scratchDir, "MANIFEST.MF");
        Manifest.Attribute mainClass = new Manifest.Attribute();
        mainClass.setName("Main-Class");
        mainClass.setValue(this.task.getMainClass());
        ManifestTask manifest = (ManifestTask)this.task.createSubtask(ManifestTask.class);
        manifest.setFile(this.manifestFile);
        try {
            manifest.addConfiguredAttribute(mainClass);
        }
        catch (ManifestException e) {
            throw new BuildException("Manifest error", (Throwable)e);
        }
        manifest.execute();
    }

    void createFatJar() throws BuildException {
        File fatJar = new File(this.baseDir, this.task.getName() + ".jar");
        fatJar.delete();
        Jar jar = (Jar)this.task.createSubtask(Jar.class);
        jar.setDestFile(fatJar);
        jar.setManifest(this.manifestFile);
        for (File jarDir : this.unpackedJarDirs) {
            FileSet fs = new FileSet();
            fs.setDir(jarDir);
            jar.addFileset(fs);
        }
        jar.execute();
    }

    void unpackJars() throws BuildException {
        int jarId = 0;
        for (FileSet fs : this.task.getLibs()) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.task.getProject());
            String[] files = scanner.getIncludedFiles();
            Expand unjar = (Expand)this.task.createSubtask(Expand.class);
            for (int i = 0; i < files.length; ++i) {
                File unpackDir = new File(this.scratchDir, jarId++ + "");
                unpackDir.mkdirs();
                this.unpackedJarDirs.add(unpackDir);
                unjar.setDest(unpackDir);
                unjar.setSrc(new File(scanner.getBasedir(), files[i]));
                unjar.execute();
            }
        }
    }

    void createDirectories() throws BuildException {
        if (!this.baseDir.isDirectory() && !this.baseDir.mkdirs()) {
            throw new BuildException("Can't create directory " + this.baseDir.getAbsolutePath());
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String label = "japplication-" + System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            File dir = new File(tmpDir, label + i);
            if (dir.exists() || !dir.mkdirs()) continue;
            this.scratchDir = dir;
            break;
        }
        if (!this.scratchDir.isDirectory()) {
            throw new BuildException("Can't create scratch directory");
        }
    }

    boolean recursiveDelete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            if (this.recursiveDelete(new File(file, list[i]))) continue;
            return false;
        }
        return file.delete();
    }
}

