/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.objectstyle.woproject.ant.FileUtil;
import org.objectstyle.woproject.ant.JApplicationJavaWorker;
import org.objectstyle.woproject.ant.TokenFilter;

class JApplicationWindowsWorker
extends JApplicationJavaWorker {
    static final String EMBEDDED_NSIS_PATH = "japplication/windows/nsis-2.20";
    protected String nsisExe;
    protected File nsiScript;

    JApplicationWindowsWorker() {
    }

    protected void executeInternal() throws BuildException {
        super.executeInternal();
        this.createNsisScript();
        this.initNsis();
        this.execNsis();
    }

    void execNsis() throws BuildException {
        ExecTask exec = (ExecTask)this.task.createSubtask(ExecTask.class);
        exec.setDir(this.baseDir);
        exec.setExecutable(this.nsisExe);
        exec.setFailonerror(true);
        exec.createArg().setLine(this.nsiScript.getAbsolutePath());
        exec.execute();
    }

    void initNsis() throws BuildException {
        this.task.log("Extracting embedded NSIS", 4);
        File nsisDir = new File(this.scratchDir, "nsis");
        this.extractResource("makensis.exe", nsisDir);
        this.extractResource("Stubs/bzip2", nsisDir);
        this.extractResource("Stubs/bzip2_solid", nsisDir);
        this.extractResource("Stubs/lzma", nsisDir);
        this.extractResource("Stubs/lzma_solid", nsisDir);
        this.extractResource("Stubs/uninst", nsisDir);
        this.extractResource("Stubs/zlib", nsisDir);
        this.extractResource("Stubs/zlib_solid", nsisDir);
        this.nsisExe = new File(nsisDir, "makensis.exe").getAbsolutePath();
    }

    void createNsisScript() throws BuildException {
        String targetIcon = this.task.getIcon() != null && this.task.getIcon().isFile() ? "Icon \"" + this.task.getIcon().getAbsolutePath() + "\"" : "";
        String jvmOptions = this.task.getJvmOptions() != null ? this.task.getJvmOptions() : "";
        String outFile = new File(this.baseDir, this.task.getName() + ".exe").getAbsolutePath();
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("@NAME@", this.task.getName());
        tokens.put("@LONG_NAME@", this.task.getLongName());
        tokens.put("@MAIN_CLASS@", this.task.getMainClass());
        tokens.put("@ICON@", targetIcon);
        tokens.put("@JVM_OPTIONS@", jvmOptions);
        tokens.put("@OUT_FILE@", outFile);
        this.nsiScript = new File(this.scratchDir, "app.nsi");
        new TokenFilter(tokens).copy("japplication/windows/app.nsi", this.nsiScript);
    }

    void extractResource(String resourceName, File dir) {
        String path = "japplication/windows/nsis-2.20/" + resourceName;
        String name = '/' != File.separatorChar ? resourceName.replace('/', File.separatorChar) : resourceName;
        FileUtil.copy(path, new File(dir, name));
    }
}

