/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.objectstyle.woproject.ant.WOTask;

public class WOMapper
extends Mapper {
    private final String LPROJ_SUFFIX = ".lproj";
    private final String SUBPROJ_SUFFIX = ".subproj";
    private final String NON_LOCALIZED = "Nonlocalized.lproj";
    WOTask wotask;
    String[] pattern;

    public WOMapper(Project project, Task parent) {
        super(project);
        if (parent != null && parent instanceof WOTask) {
            this.wotask = (WOTask)parent;
        }
    }

    public FileNameMapper getImplementation() throws BuildException {
        return new WOFileNameMapper();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WOFileNameMapper
    extends IdentityMapper {
        WOFileNameMapper() {
        }

        public String[] mapFileName(String sourceFileName) {
            if ("Nonlocalized.lproj".equals(sourceFileName)) {
                return null;
            }
            String subprojPath = this.subprojFilter(sourceFileName);
            String localizedPath = this.localizationFilter(subprojPath);
            String wocompPath = this.wocompFilter(localizedPath);
            String resourcesPath = this.resourcesFilter(wocompPath);
            String webserverresourcesPath = this.webserverResourcesFilter(resourcesPath);
            String miscFilter = this.miscFilter(webserverresourcesPath);
            String flattenfilesFilter = this.applyFlattenfiles(miscFilter);
            String finalPath = this.eomodelFilter(flattenfilesFilter);
            return new String[]{finalPath};
        }

        private final String resourcesFilter(String path) {
            File f = new File(path);
            String parent = f.getParent();
            if (parent != null && parent.equals("Resources")) {
                return this.flatten(f);
            }
            String resourcesPattern = "Resources" + File.separator;
            int index = path.indexOf(resourcesPattern);
            if (index >= 0) {
                return path.substring(index + resourcesPattern.length());
            }
            return path;
        }

        private final String webserverResourcesFilter(String path) {
            File f = new File(path);
            String parent = f.getParent();
            if (parent != null && parent.equals("WebServerResources")) {
                return this.flatten(new File(path));
            }
            String webServerResourcesPattern = "WebServerResources" + File.separator;
            int index = path.indexOf(webServerResourcesPattern);
            if (index >= 0) {
                return path.substring(index + webServerResourcesPattern.length());
            }
            return path;
        }

        private final String miscFilter(String path) {
            File f = new File(path);
            if (path.endsWith(".strings")) {
                return this.flatten(f);
            }
            if (path.endsWith(".plist") && path.indexOf(".eomodeld") <= 0) {
                return this.flatten(f);
            }
            return path;
        }

        private final String wocompFilter(String path) {
            File f = new File(path);
            if (path.endsWith(".wo") || path.endsWith(".api")) {
                return this.flatten(f);
            }
            String parent = f.getParent();
            if (parent != null && parent.endsWith(".wo")) {
                return this.flattenWithParent(f);
            }
            return path;
        }

        private final String eomodelFilter(String path) {
            File f = new File(path);
            if (path.endsWith(".eomodeld") && !path.endsWith("index.eomodeld")) {
                return this.flatten(f);
            }
            String parent = f.getParent();
            if (parent != null && parent.endsWith(".eomodeld")) {
                return this.flattenWithParent(f);
            }
            return path;
        }

        private String subprojFilter(String path) {
            String topmostParent;
            File f = new File(path);
            File p2 = null;
            for (File p1 = f.getParentFile(); p1 != null; p1 = p1.getParentFile()) {
                p2 = p1;
            }
            if (p2 != null && (topmostParent = p2.getName()).endsWith(".subproj")) {
                return path.substring(topmostParent.length());
            }
            return path;
        }

        private String localizationFilter(String path) {
            String result = path;
            String localizationPattern = "Nonlocalized.lproj" + File.separator;
            int index = path.indexOf(localizationPattern);
            if (index >= 0) {
                result = path.substring(index + localizationPattern.length());
            } else {
                localizationPattern = ".lproj" + File.separator;
                index = path.indexOf(localizationPattern);
                if (index >= 0) {
                    result = path.replaceFirst(".*?(\\w+\\..lproj)", "$1");
                }
            }
            return result;
        }

        private String flatten(File f) {
            String topmostParent;
            String result = null;
            File p2 = null;
            for (File p1 = f.getParentFile(); p1 != null; p1 = p1.getParentFile()) {
                p2 = p1;
                if (p1.getName().endsWith(".lproj")) break;
            }
            if (p2 != null && (topmostParent = p2.getName()).endsWith(".lproj")) {
                result = topmostParent + File.separator + f.getName();
            }
            if (result == null) {
                result = f.getName();
            }
            return result;
        }

        private String[] pattern() {
            if (WOMapper.this.wotask != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator<String> iterator = WOMapper.this.wotask.getFlattenfileNames();
                while (iterator.hasNext()) {
                    String fileName = iterator.next();
                    this.addPattern(fileName, arrayList);
                }
                WOMapper.this.pattern = arrayList.toArray(new String[arrayList.size()]);
            }
            return WOMapper.this.pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPattern(String fileName, ArrayList<String> arrayList) {
            BufferedReader patternReader = null;
            try {
                patternReader = new BufferedReader(new FileReader(new File(fileName)));
                String line = patternReader.readLine();
                while (line != null) {
                    if (line.length() > 0) {
                        arrayList.add(line);
                    }
                    line = patternReader.readLine();
                }
            }
            catch (IOException ioe) {
                WOMapper.this.log("Error while reading file: " + ioe.getMessage());
            }
            finally {
                if (null != patternReader) {
                    try {
                        patternReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private String applyFlattenfiles(String path) {
            if (this.pattern() == null) {
                return path;
            }
            File f = new File(path);
            for (int i = 0; i < WOMapper.this.pattern.length; ++i) {
                if (!SelectorUtils.matchPath((String)WOMapper.this.pattern[i], (String)path)) continue;
                return this.flatten(f);
            }
            return path;
        }

        private String flattenWithParent(File f) {
            String name = f.getName();
            String parentName = this.flatten(f.getParentFile());
            return parentName + File.separator + name;
        }
    }
}

