/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.SubtaskFactory;
import org.objectstyle.woproject.ant.WOFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WOTask
extends Task {
    protected Vector<WOFileSet> classes = new Vector();
    protected String name;
    protected String destDir;
    protected String wsDestDir;
    protected String principalClass;
    protected String servletAdaptor = "com.webobjects.jspservlet.WOServletAdaptor";
    protected String manifest;
    protected String jarName;
    protected String customInfoPListContent;
    protected Vector<WOFileSet> sources = new Vector();
    protected Vector<WOFileSet> resources = new Vector();
    protected Vector<WOFileSet> wsresources = new Vector();
    protected Vector<FileSet> flattenfiles = new Vector();
    protected Vector<FileSet> lib = new Vector();
    protected boolean hasComponents = true;
    protected String version;
    protected String cfbundleversion;
    protected String cfbundleshortversion;
    protected String cfbundleID;
    protected String javaVersion;
    private SubtaskFactory subtaskFactory;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getCFBundleVersion() {
        return this.cfbundleversion == null || this.cfbundleversion.equals("${cfBundleVersion}") ? "" : this.cfbundleversion;
    }

    public void setCFBundleVersion(String value) {
        this.cfbundleversion = value;
    }

    public String getCFBundleShortVersion() {
        return this.cfbundleshortversion == null || this.cfbundleshortversion.equals("${cfBundleShortVersion}") ? "" : this.cfbundleshortversion;
    }

    public void setCFBundleShortVersion(String value) {
        this.cfbundleshortversion = value;
    }

    public String getCFBundleID() {
        return this.cfbundleID == null || this.cfbundleID.equals("${cfBundleID}") ? "com.apple.myapp" : this.cfbundleID;
    }

    public void setCFBundleID(String value) {
        this.cfbundleID = value;
    }

    public String getJavaVersion() {
        return this.javaVersion == null || this.javaVersion.equals("${javaVersion}") ? "1.5+" : this.javaVersion;
    }

    public void setJavaVersion(String value) {
        this.javaVersion = value;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getJarName() {
        if (this.jarName == null) {
            this.jarName = this.getName().toLowerCase();
        }
        return this.jarName;
    }

    public void setPrincipalClass(String principalClass) {
        if (principalClass.equals("${principalClass}")) {
            principalClass = "Application";
        }
        this.principalClass = principalClass;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setWsDestDir(String wsDestDir) {
        this.wsDestDir = wsDestDir;
    }

    public String getPrincipalClass() {
        return this.principalClass;
    }

    public void setServletAdaptor(String servletAdaptor) {
        this.servletAdaptor = servletAdaptor;
    }

    public String getServletAdaptor() {
        return this.servletAdaptor;
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getCustomInfoPListContent() {
        return this.customInfoPListContent;
    }

    public void setCustomInfoPListContent(String customInfoPListContent) {
        this.customInfoPListContent = customInfoPListContent;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public void addClasses(WOFileSet set) {
        this.classes.addElement(set);
    }

    public void addSources(WOFileSet set) {
        this.sources.addElement(set);
    }

    public void addResources(WOFileSet set) {
        this.resources.addElement(set);
    }

    public void addLib(FileSet set) {
        this.lib.addElement(set);
    }

    public void addWsresources(WOFileSet set) {
        this.wsresources.addElement(set);
    }

    public void addFlattenfiles(FileSet set) {
        this.flattenfiles.addElement(set);
    }

    protected File webServerDir() {
        return this.getProject().resolveFile(this.wsDestDir);
    }

    protected abstract File taskDir();

    protected abstract File resourcesDir();

    protected abstract File wsresourcesDir();

    protected abstract File wsresourcesDestDir();

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("'name' attribute is missing.");
        }
        if (this.destDir == null) {
            throw new BuildException("'destDir' attribute is missing.");
        }
    }

    protected void createDirectories() throws BuildException {
        Mkdir mkdir = this.getSubtaskFactory().getMkdir();
        File taskDir = this.taskDir();
        mkdir.setDir(taskDir);
        mkdir.execute();
        File resourceDir = this.resourcesDir();
        mkdir.setDir(resourceDir);
        mkdir.execute();
        mkdir.setDir(new File(resourceDir, "Java"));
        mkdir.execute();
        if (this.hasWs()) {
            mkdir.setDir(this.wsresourcesDir());
            mkdir.execute();
        }
    }

    public boolean hasWs() {
        return this.wsresources.size() > 0;
    }

    public boolean hasFlattenfiles() {
        return this.flattenfiles.size() > 0;
    }

    public boolean doingSplitInstall() {
        return this.wsDestDir != null && this.hasWs();
    }

    public boolean hasResources() {
        return this.resources.size() > 0;
    }

    public boolean hasSources() {
        return this.sources.size() > 0;
    }

    public boolean hasClasses() {
        return this.classes.size() > 0;
    }

    public boolean hasManifest() {
        return this.manifest != null;
    }

    public File getManifestFile() {
        return new File(this.manifest);
    }

    protected void jarSources() throws BuildException {
        Jar jar = this.getSubtaskFactory().getJar();
        File taskJar = new File(this.resourcesDir(), "Java" + File.separator + "src.jar");
        jar.setDestFile(taskJar);
        boolean hasFileSets = false;
        if (this.hasSources()) {
            Enumeration<WOFileSet> en = this.sources.elements();
            while (en.hasMoreElements()) {
                WOFileSet wofs = en.nextElement();
                if (!wofs.testIfCondition()) continue;
                jar.addFileset((FileSet)wofs);
                hasFileSets = true;
            }
        }
        if (hasFileSets) {
            jar.execute();
        }
    }

    protected void jarClasses() throws BuildException {
        Jar jar = this.getSubtaskFactory().getJar();
        File taskJar = new File(this.resourcesDir(), "Java" + File.separator + this.getJarName() + ".jar");
        jar.setDestFile(taskJar);
        if (this.hasClasses()) {
            Enumeration<WOFileSet> en = this.classes.elements();
            while (en.hasMoreElements()) {
                WOFileSet wofs = en.nextElement();
                if (!wofs.testIfCondition()) continue;
                jar.addFileset((FileSet)wofs);
            }
        }
        if (this.hasManifest()) {
            jar.setManifest(this.getManifestFile());
        }
        jar.execute();
    }

    protected void copyResources() throws BuildException {
        Copy cp = this.getSubtaskFactory().getResourceCopy();
        cp.setTodir(this.resourcesDir());
        int count = 0;
        Enumeration<WOFileSet> en = this.resources.elements();
        while (en.hasMoreElements()) {
            WOFileSet wofs = en.nextElement();
            if (!wofs.testIfCondition()) continue;
            cp.addFileset((FileSet)wofs);
            ++count;
        }
        if (count > 0) {
            cp.execute();
        }
    }

    protected void copyWsresources() throws BuildException {
        Copy cp = this.getSubtaskFactory().getResourceCopy();
        cp.setTodir(this.wsresourcesDir());
        int count = 0;
        Enumeration<WOFileSet> en = this.wsresources.elements();
        while (en.hasMoreElements()) {
            WOFileSet wofs = en.nextElement();
            if (!wofs.testIfCondition()) continue;
            cp.addFileset((FileSet)wofs);
            ++count;
        }
        if (count > 0) {
            cp.execute();
            if (this.doingSplitInstall()) {
                this.log("Split install WebServerResources of " + this.name + " in " + this.wsDestDir);
                cp.setTodir(this.wsresourcesDestDir());
                cp.execute();
            }
        }
    }

    protected void copyLibs() throws BuildException {
        Copy cp = this.getSubtaskFactory().getResourceCopy();
        cp.setTodir(new File(this.resourcesDir(), "Java"));
        cp.setFlatten(true);
        Enumeration<FileSet> en = this.lib.elements();
        while (en.hasMoreElements()) {
            cp.addFileset(en.nextElement());
        }
        cp.execute();
    }

    protected boolean hasLib() {
        return this.lib.size() > 0;
    }

    protected boolean hasJava() {
        return this.classes.size() > 0 || this.lib.size() > 0;
    }

    public Iterator<String> getLibNames() {
        ArrayList<String> libNames = new ArrayList<String>();
        Enumeration<FileSet> en = this.lib.elements();
        while (en.hasMoreElements()) {
            FileSet fs = en.nextElement();
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] libs = scanner.getIncludedFiles();
            for (int i = 0; i < libs.length; ++i) {
                File libFile = new File(libs[i]);
                libNames.add(libFile.getPath());
            }
        }
        return libNames.iterator();
    }

    public SubtaskFactory getSubtaskFactory() {
        if (this.subtaskFactory == null) {
            this.subtaskFactory = new SubtaskFactory(this);
        }
        return this.subtaskFactory;
    }

    public void release() {
        this.subtaskFactory.release();
        this.subtaskFactory = null;
    }

    public Iterator<String> getFlattenfileNames() {
        ArrayList<String> flattenfilesNames = new ArrayList<String>();
        Enumeration<FileSet> en = this.flattenfiles.elements();
        while (en.hasMoreElements()) {
            FileSet fs = en.nextElement();
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                flattenfilesNames.add(files[i]);
            }
        }
        return flattenfilesNames.iterator();
    }

    public boolean getHasComponents() {
        return this.hasComponents;
    }

    public void setHasComponents(boolean value) {
        this.hasComponents = value;
    }
}

