/*
 * Decompiled with CFR 0.152.
 */
package wolfendale.scalacheck.regexp;

import java.io.Serializable;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wolfendale.scalacheck.regexp.ast.And;
import wolfendale.scalacheck.regexp.ast.AnyChar$;
import wolfendale.scalacheck.regexp.ast.BOS$;
import wolfendale.scalacheck.regexp.ast.CharacterClass;
import wolfendale.scalacheck.regexp.ast.CharacterClass$DigitChar$;
import wolfendale.scalacheck.regexp.ast.CharacterClass$SpaceChar$;
import wolfendale.scalacheck.regexp.ast.CharacterClass$WordChar$;
import wolfendale.scalacheck.regexp.ast.DigitChar$;
import wolfendale.scalacheck.regexp.ast.EOS$;
import wolfendale.scalacheck.regexp.ast.Group;
import wolfendale.scalacheck.regexp.ast.Length;
import wolfendale.scalacheck.regexp.ast.Literal;
import wolfendale.scalacheck.regexp.ast.Negated;
import wolfendale.scalacheck.regexp.ast.NonCapturingGroup;
import wolfendale.scalacheck.regexp.ast.OneOrMore;
import wolfendale.scalacheck.regexp.ast.Optional;
import wolfendale.scalacheck.regexp.ast.Or;
import wolfendale.scalacheck.regexp.ast.Range;
import wolfendale.scalacheck.regexp.ast.RangeFrom;
import wolfendale.scalacheck.regexp.ast.RegularExpression;
import wolfendale.scalacheck.regexp.ast.SpaceChar$;
import wolfendale.scalacheck.regexp.ast.Substitution;
import wolfendale.scalacheck.regexp.ast.WordBoundary$;
import wolfendale.scalacheck.regexp.ast.WordChar$;
import wolfendale.scalacheck.regexp.ast.ZeroOrMore;

public final class ASTProcessor$ {
    public static final ASTProcessor$ MODULE$ = new ASTProcessor$();
    private static final Gen<String> wordChar = Gen$.MODULE$.oneOf(Gen$.MODULE$.alphaNumChar(), Gen$.MODULE$.const((Object)BoxesRunTime.boxToCharacter((char)'_')), (Seq)Nil$.MODULE$).map((Function1 & Serializable)x$12 -> ASTProcessor$.$anonfun$wordChar$1(BoxesRunTime.unboxToChar((Object)x$12)));
    private static final Gen<String> spaceChar = Gen$.MODULE$.oneOf((Object)" ", (Object)"\t", (Seq)Nil$.MODULE$);
    private static final Gen<String> digitChar = Gen$.MODULE$.numChar().map((Function1 & Serializable)x$13 -> ASTProcessor$.$anonfun$digitChar$1(BoxesRunTime.unboxToChar((Object)x$13)));

    private Gen<String> negated(Negated re, Arbitrary<Object> ev) {
        RegularExpression regularExpression;
        RegularExpression regularExpression2;
        RegularExpression regularExpression3;
        RegularExpression regularExpression4;
        Gen gen;
        RegularExpression regularExpression5;
        Gen arbitraryString = Arbitrary$.MODULE$.arbitrary(ev).map((Function1 & Serializable)x$1 -> ASTProcessor$.$anonfun$negated$1(BoxesRunTime.unboxToChar((Object)x$1)));
        Negated negated = re;
        if (negated != null && WordChar$.MODULE$.equals(regularExpression5 = negated.term())) {
            gen = arbitraryString.suchThat((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matches("\\W")));
        } else if (negated != null && DigitChar$.MODULE$.equals(regularExpression4 = negated.term())) {
            gen = arbitraryString.suchThat((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matches("\\D")));
        } else if (negated != null && SpaceChar$.MODULE$.equals(regularExpression3 = negated.term())) {
            gen = arbitraryString.suchThat((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.matches("\\S")));
        } else if (negated != null && WordBoundary$.MODULE$.equals(regularExpression2 = negated.term())) {
            gen = Gen$.MODULE$.const((Object)"");
        } else if (negated != null && (regularExpression = negated.term()) instanceof CharacterClass) {
            CharacterClass characterClass = (CharacterClass)regularExpression;
            Seq<CharacterClass.Term> terms = characterClass.terms();
            gen = arbitraryString.suchThat((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.matches(new StringBuilder(3).append("[^").append(((IterableOnceOps)terms.map((Function1 & Serializable)term -> ASTProcessor$.termToString$1(term))).mkString("")).append("]").toString())));
        } else {
            throw scala.sys.package$.MODULE$.error("invalid negated term");
        }
        return gen;
    }

    public Gen<String> apply(RegularExpression re, Arbitrary<Object> ev) {
        Gen gen;
        block30: {
            RegularExpression regularExpression;
            while (true) {
                RegularExpression inner;
                if ((regularExpression = re) instanceof Literal) {
                    Literal literal = (Literal)regularExpression;
                    String str = literal.value();
                    gen = this.literal(str);
                    break block30;
                }
                if (WordChar$.MODULE$.equals(regularExpression)) {
                    gen = this.wordChar();
                    break block30;
                }
                if (SpaceChar$.MODULE$.equals(regularExpression)) {
                    gen = this.spaceChar();
                    break block30;
                }
                if (DigitChar$.MODULE$.equals(regularExpression)) {
                    gen = this.digitChar();
                    break block30;
                }
                if (AnyChar$.MODULE$.equals(regularExpression)) {
                    gen = Arbitrary$.MODULE$.arbitrary(ev).map((Function1 & Serializable)x$6 -> ASTProcessor$.$anonfun$apply$1(BoxesRunTime.unboxToChar((Object)x$6)));
                    break block30;
                }
                if (regularExpression instanceof Group) {
                    RegularExpression inner2;
                    Group group = (Group)regularExpression;
                    re = inner2 = group.term();
                    continue;
                }
                if (!(regularExpression instanceof NonCapturingGroup)) break;
                NonCapturingGroup nonCapturingGroup = (NonCapturingGroup)regularExpression;
                re = inner = nonCapturingGroup.term();
            }
            if (regularExpression instanceof Or) {
                Or or = (Or)regularExpression;
                RegularExpression left = or.t1();
                RegularExpression right = or.t2();
                gen = Gen$.MODULE$.oneOf(this.apply(left, ev), this.apply(right, ev), (Seq)Nil$.MODULE$);
            } else if (regularExpression instanceof And) {
                And and = (And)regularExpression;
                RegularExpression left = and.t1();
                RegularExpression right = and.t2();
                gen = this.apply(left, ev).flatMap((Function1 & Serializable)l -> MODULE$.apply(right, ev).map((Function1 & Serializable)r -> new StringBuilder(0).append((String)l).append((String)r).toString()));
            } else if (regularExpression instanceof Optional) {
                Optional optional = (Optional)regularExpression;
                RegularExpression inner = optional.term();
                gen = this.optional(this.apply(inner, ev));
            } else if (regularExpression instanceof OneOrMore) {
                OneOrMore oneOrMore = (OneOrMore)regularExpression;
                RegularExpression inner = oneOrMore.term();
                gen = Gen$.MODULE$.nonEmptyListOf((Function0 & Serializable)() -> MODULE$.apply(inner, ev)).map((Function1 & Serializable)x$7 -> x$7.mkString(""));
            } else if (regularExpression instanceof ZeroOrMore) {
                ZeroOrMore zeroOrMore = (ZeroOrMore)regularExpression;
                RegularExpression inner = zeroOrMore.term();
                gen = Gen$.MODULE$.listOf((Function0 & Serializable)() -> MODULE$.apply(inner, ev)).map((Function1 & Serializable)x$8 -> x$8.mkString(""));
            } else if (regularExpression instanceof RangeFrom) {
                RangeFrom rangeFrom = (RangeFrom)regularExpression;
                RegularExpression inner = rangeFrom.term();
                int min = rangeFrom.min();
                gen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)min), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)length -> ASTProcessor$.$anonfun$apply$8(inner, ev, BoxesRunTime.unboxToInt((Object)length)));
            } else if (regularExpression instanceof Range) {
                Range range = (Range)regularExpression;
                RegularExpression inner = range.term();
                int min = range.min();
                int max = range.max();
                gen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)min), (Object)BoxesRunTime.boxToInteger((int)max), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)length -> ASTProcessor$.$anonfun$apply$10(inner, ev, BoxesRunTime.unboxToInt((Object)length)));
            } else if (regularExpression instanceof Length) {
                Length length2 = (Length)regularExpression;
                RegularExpression inner = length2.term();
                int length3 = length2.min();
                gen = Gen$.MODULE$.listOfN(length3, this.apply(inner, ev)).map((Function1 & Serializable)x$9 -> x$9.mkString(""));
            } else if (regularExpression instanceof CharacterClass) {
                CharacterClass characterClass = (CharacterClass)regularExpression;
                Seq<CharacterClass.Term> terms = characterClass.terms();
                gen = this.processClass(terms);
            } else if (regularExpression instanceof Negated) {
                Negated negated = (Negated)regularExpression;
                gen = this.negated(negated, ev);
            } else {
                if (regularExpression instanceof Substitution) {
                    throw scala.sys.package$.MODULE$.error("backreferences are not supported");
                }
                boolean bl = WordBoundary$.MODULE$.equals(regularExpression) ? true : (BOS$.MODULE$.equals(regularExpression) ? true : EOS$.MODULE$.equals(regularExpression));
                if (bl) {
                    gen = Gen$.MODULE$.const((Object)"");
                } else {
                    throw new MatchError((Object)regularExpression);
                }
            }
        }
        return gen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Gen<String> processClass(Seq<CharacterClass.Term> terms) {
        List gens = terms.toList().map((Function1 & Serializable)x0$1 -> {
            Object object;
            CharacterClass.Term term = x0$1;
            if (term instanceof CharacterClass.Literal) {
                CharacterClass.Literal literal = (CharacterClass.Literal)term;
                String str = literal.value();
                object = MODULE$.literal(str);
            } else if (term instanceof CharacterClass.DigitRange) {
                CharacterClass.DigitRange digitRange = (CharacterClass.DigitRange)term;
                int min = digitRange.min();
                int max = digitRange.max();
                object = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)min), (Object)BoxesRunTime.boxToInteger((int)max), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)x$10 -> ASTProcessor$.$anonfun$processClass$2(BoxesRunTime.unboxToInt((Object)x$10)));
            } else if (term instanceof CharacterClass.CharRange) {
                CharacterClass.CharRange charRange = (CharacterClass.CharRange)term;
                char min = charRange.min();
                char max = charRange.max();
                object = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToCharacter((char)min), (Object)BoxesRunTime.boxToCharacter((char)max), Gen.Choose$.MODULE$.chooseChar()).map((Function1 & Serializable)x$11 -> ASTProcessor$.$anonfun$processClass$3(BoxesRunTime.unboxToChar((Object)x$11)));
            } else {
                object = CharacterClass$WordChar$.MODULE$.equals(term) ? MODULE$.wordChar() : (CharacterClass$SpaceChar$.MODULE$.equals(term) ? MODULE$.spaceChar() : (CharacterClass$DigitChar$.MODULE$.equals(term) ? MODULE$.digitChar() : Gen$.MODULE$.const((Object)"")));
            }
            return object;
        });
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = gens;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Gen a = (Gen)colon2.head();
            List list2 = colon2.next$access$1();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (nil$ == null) {
                if (list3 == null) return a;
            } else if (nil$.equals(list3)) {
                return a;
            }
        }
        if (!bl) return Gen$.MODULE$.const((Object)"");
        Gen a = (Gen)colon2.head();
        List list4 = colon2.next$access$1();
        if (!(list4 instanceof .colon.colon)) return Gen$.MODULE$.const((Object)"");
        .colon.colon colon3 = (.colon.colon)list4;
        Gen b = (Gen)colon3.head();
        List xs = colon3.next$access$1();
        return Gen$.MODULE$.oneOf(a, b, (Seq)xs);
    }

    private Gen<String> wordChar() {
        return wordChar;
    }

    private Gen<String> spaceChar() {
        return spaceChar;
    }

    private Gen<String> digitChar() {
        return digitChar;
    }

    private Gen<String> literal(String str) {
        return Gen$.MODULE$.const((Object)str);
    }

    private Gen<String> optional(Gen<String> inner) {
        return Gen$.MODULE$.frequency((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), inner), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Gen$.MODULE$.const((Object)""))}));
    }

    public static final /* synthetic */ String $anonfun$negated$1(char x$1) {
        return Character.toString(x$1);
    }

    private static final String termToString$1(CharacterClass.Term term) {
        String string;
        CharacterClass.Term term2 = term;
        if (term2 instanceof CharacterClass.Literal) {
            String str;
            CharacterClass.Literal literal = (CharacterClass.Literal)term2;
            string = str = literal.value();
        } else if (term2 instanceof CharacterClass.CharRange) {
            CharacterClass.CharRange charRange = (CharacterClass.CharRange)term2;
            char min = charRange.min();
            char max = charRange.max();
            string = new StringBuilder(1).append(min).append("-").append(max).toString();
        } else if (term2 instanceof CharacterClass.DigitRange) {
            CharacterClass.DigitRange digitRange = (CharacterClass.DigitRange)term2;
            int min = digitRange.min();
            int max = digitRange.max();
            string = new StringBuilder(1).append(min).append("-").append(max).toString();
        } else {
            string = CharacterClass$DigitChar$.MODULE$.equals(term2) ? "\\d" : (CharacterClass$WordChar$.MODULE$.equals(term2) ? "\\w" : (CharacterClass$SpaceChar$.MODULE$.equals(term2) ? "\\s" : ""));
        }
        return string;
    }

    public static final /* synthetic */ String $anonfun$apply$1(char x$6) {
        return Character.toString(x$6);
    }

    public static final /* synthetic */ Gen $anonfun$apply$8(RegularExpression inner$3, Arbitrary ev$1, int length) {
        return Gen$.MODULE$.listOfN(length, MODULE$.apply(inner$3, (Arbitrary<Object>)ev$1)).map((Function1 & Serializable)list -> list.mkString(""));
    }

    public static final /* synthetic */ Gen $anonfun$apply$10(RegularExpression inner$4, Arbitrary ev$1, int length) {
        return Gen$.MODULE$.listOfN(length, MODULE$.apply(inner$4, (Arbitrary<Object>)ev$1)).map((Function1 & Serializable)list -> list.mkString(""));
    }

    public static final /* synthetic */ String $anonfun$processClass$2(int x$10) {
        return Integer.toString(x$10);
    }

    public static final /* synthetic */ String $anonfun$processClass$3(char x$11) {
        return Character.toString(x$11);
    }

    public static final /* synthetic */ String $anonfun$wordChar$1(char x$12) {
        return Character.toString(x$12);
    }

    public static final /* synthetic */ String $anonfun$digitChar$1(char x$13) {
        return Character.toString(x$13);
    }

    private ASTProcessor$() {
    }
}

