/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Seq;
import com.github.wolray.seq.SeqList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class ArraySeq<T>
extends ArrayList<T>
implements SeqList<T> {
    public ArraySeq(int initialCapacity) {
        super(initialCapacity);
    }

    public ArraySeq() {
    }

    public ArraySeq(Collection<? extends T> c) {
        super(c);
    }

    public void swap(int i, int j) {
        Object t = this.get(i);
        this.set(i, this.get(j));
        this.set(j, t);
    }

    public Seq<ArraySeq<T>> permute(boolean inplace) {
        return c -> this.permute((Consumer<ArraySeq<T>>)c, inplace, 0);
    }

    private void permute(Consumer<ArraySeq<T>> c, boolean inplace, int i) {
        int n = this.size();
        if (i == n) {
            c.accept(inplace ? this : new ArraySeq<T>(this));
            return;
        }
        for (int j = i; j < n; ++j) {
            this.swap(i, j);
            this.permute(c, inplace, i + 1);
            this.swap(i, j);
        }
    }
}

