/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.SizedSeq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Consumer;

public class BatchedSeq<T>
implements SizedSeq<T> {
    private transient int batchSize = 10;
    private final transient LinkedList<ArrayList<T>> list = new LinkedList();
    private transient int size;
    private transient ArrayList<T> cur;

    @Override
    public void consume(Consumer<T> consumer) {
        this.list.forEach(ls -> ls.forEach(consumer));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<ArrayList<T>> iterator;
            Iterator<T> cur;
            {
                this.iterator = BatchedSeq.this.list.iterator();
                this.cur = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                if (!this.cur.hasNext()) {
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    this.cur = this.iterator.next().iterator();
                }
                return true;
            }

            @Override
            public T next() {
                return this.cur.next();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(T t) {
        if (this.cur == null) {
            this.cur = new ArrayList(this.batchSize);
            this.list.add(this.cur);
        }
        this.cur.add(t);
        ++this.size;
        if (this.cur.size() == this.batchSize) {
            this.cur = null;
            this.batchSize = Math.min(300, Math.max(this.batchSize, this.size >> 1));
        }
    }

    public String toString() {
        return this.toList().toString();
    }
}

