/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.IOChain;
import com.github.wolray.seq.ItrUtil;
import com.github.wolray.seq.Seq;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.UnaryOperator;

public interface ByteSource {
    public byte[] toBytes();

    public InputStream toInputStream();

    public static ArraySource of(byte[] bytes) {
        return () -> bytes;
    }

    public static PathSource of(File file) {
        return ByteSource.of(file.toPath());
    }

    public static ISSource of(InputStream is) {
        return () -> is;
    }

    public static ByteSource of(Iterable<String> iterable) {
        return ByteSource.of(iterable, "\n");
    }

    public static ISSource of(Iterable<String> iterable, String separator) {
        return () -> ItrUtil.toInputStream(iterable.iterator(), separator);
    }

    public static PathSource of(Path path) {
        return () -> path;
    }

    public static PathSource of(String file) {
        return ByteSource.of(Paths.get(file, new String[0]));
    }

    public static ISSource of(URL url) {
        return url::openStream;
    }

    public static ArraySource ofArray(IOChain<byte[]> bytes) {
        return bytes::call;
    }

    public static PathSource ofPath(IOChain<Path> path) {
        return path::call;
    }

    public static ByteSource ofResource(Class<?> cls, String resource) {
        return IOChain.apply(cls.getResource(resource), url -> {
            try {
                if (url == null) {
                    throw new FileNotFoundException(resource);
                }
                return ByteSource.of(Paths.get(url.toURI()));
            }
            catch (URISyntaxException | FileSystemNotFoundException e) {
                return ByteSource.of(url);
            }
        });
    }

    public static ByteSource ofResource(String resource) {
        return ByteSource.ofResource(ByteSource.class, resource);
    }

    public static ISSource ofStream(IOChain<InputStream> is) {
        return is::call;
    }

    public static ByteSource ofUrl(String url) {
        return IOChain.apply(url, u -> ByteSource.of(new URL((String)u)));
    }

    default public String asString() {
        return new String(this.toBytes(), this.charset());
    }

    default public ByteSource cache() {
        return ByteSource.of(this.toBytes());
    }

    default public Charset charset() {
        return Charset.defaultCharset();
    }

    default public IOChain<Properties> toProperties() {
        return this.toReader().map(r -> {
            Properties p = new Properties();
            p.load((Reader)r);
            return p;
        });
    }

    default public IOChain<BufferedReader> toReader() {
        return IOChain.ofReader(() -> new InputStreamReader(this.toInputStream(), this.charset()));
    }

    default public Seq<String> toSeq() {
        IOChain<BufferedReader> chain = this.toReader();
        return c -> chain.use(reader -> {
            String s;
            while ((s = reader.readLine()) != null) {
                c.accept(s);
            }
        });
    }

    default public Seq<String> toSeq(int n, UnaryOperator<String> replace) {
        if (n <= 0 || replace == null) {
            return this.toSeq();
        }
        IOChain<BufferedReader> chain = this.toReader();
        return c -> chain.use(reader -> {
            String s;
            for (int i = 0; i < n; ++i) {
                s = reader.readLine();
                if (s == null) {
                    return;
                }
                c.accept(replace.apply(s));
            }
            while ((s = reader.readLine()) != null) {
                c.accept(s);
            }
        });
    }

    default public ByteSource withCharset(final Charset charset) {
        final ByteSource origin = this;
        return new ByteSource(){

            @Override
            public byte[] toBytes() {
                return origin.toBytes();
            }

            @Override
            public InputStream toInputStream() {
                return origin.toInputStream();
            }

            @Override
            public Charset charset() {
                return charset;
            }
        };
    }

    default public Path write(Path target) {
        IOChain.apply(this.toInputStream(), is -> Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING));
        return target;
    }

    default public Path writeTemp(String suffix) {
        return (Path)((Object)IOChain.of(() -> this.write(Files.createTempFile("", suffix, new FileAttribute[0]))).get());
    }

    public static interface PathSource
    extends ByteSource,
    IOChain<Path> {
        @Override
        default public byte[] toBytes() {
            return this.apply(Files::readAllBytes);
        }

        @Override
        default public InputStream toInputStream() {
            return this.apply(x$0 -> Files.newInputStream(x$0, new OpenOption[0]));
        }

        @Override
        default public Path write(Path target) {
            this.use(path -> {
                if (!path.equals(target)) {
                    Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
                }
            });
            return target;
        }

        @Override
        default public IOChain<BufferedReader> toReader() {
            return () -> Files.newBufferedReader((Path)this.call(), this.charset());
        }
    }

    public static interface ISSource
    extends ByteSource,
    IOChain<InputStream> {
        default public byte[] toBytes(int bufferSize) {
            byte[] buff = new byte[bufferSize];
            ArrayList list = new ArrayList();
            int[] total = new int[]{0};
            this.use(is -> {
                int len;
                while ((len = is.read(buff, 0, buff.length)) > 0) {
                    list.add(Arrays.copyOf(buff, len));
                    total[0] = total[0] + len;
                }
            });
            byte[] res = new byte[total[0]];
            int pos = 0;
            for (byte[] bytes : list) {
                System.arraycopy(bytes, 0, res, pos, bytes.length);
                pos += bytes.length;
            }
            return res;
        }

        @Override
        default public byte[] toBytes() {
            return this.toBytes(8192);
        }

        @Override
        default public InputStream toInputStream() {
            return (InputStream)this.get();
        }
    }

    public static interface ArraySource
    extends ByteSource,
    IOChain<byte[]> {
        @Override
        default public byte[] toBytes() {
            return (byte[])this.get();
        }

        @Override
        default public InputStream toInputStream() {
            return new ByteArrayInputStream((byte[])this.get());
        }

        @Override
        default public ByteSource cache() {
            return this;
        }
    }
}

