/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Lazy;
import com.github.wolray.seq.Seq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.function.UnaryOperator;

public interface IOChain<T> {
    public T call() throws IOException;

    public static <T, E> E apply(T t, Function<T, E> function) {
        try {
            return function.apply(t);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> IOChain<T> of(IOChain<T> supplier) {
        return supplier;
    }

    public static <T> IOChain<T> of(T t) {
        return () -> t;
    }

    public static IOChain<BufferedReader> ofReader(IOChain<Reader> supplier) {
        return () -> {
            Reader reader = (Reader)supplier.call();
            return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        };
    }

    public static IOChain<BufferedWriter> ofWriter(IOChain<Writer> supplier) {
        return () -> {
            Writer writer = (Writer)supplier.call();
            return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        };
    }

    default public <E> E apply(Function<T, E> function) {
        try {
            return function.apply(this.call());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public Lazy<T> asLazy() {
        return Lazy.of(this::get);
    }

    default public T get() {
        try {
            return this.call();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public <E> IOChain<E> map(Function<T, E> function) {
        return () -> function.apply(this.call());
    }

    default public <C extends Closeable> IOChain<C> mapClosable(Function<T, C> function) {
        return () -> (Closeable)function.apply(this.call());
    }

    default public IOChain<T> peek(Consumer<T> consumer) {
        return () -> {
            T t = this.call();
            consumer.accept(t);
            return t;
        };
    }

    default public <E> Seq<E> toSeq(Function<T, E> provider) {
        return c -> this.use(t -> {
            Object e;
            while ((e = provider.apply(t)) != null) {
                c.accept(e);
            }
        });
    }

    default public <E> Seq<E> toSeq(Function<T, E> provider, int n, UnaryOperator<E> replace) {
        return c -> this.use(t -> {
            Object e;
            for (int i = 0; i < n; ++i) {
                e = provider.apply(t);
                if (e == null) {
                    return;
                }
                c.accept(replace.apply(e));
            }
            while ((e = provider.apply(t)) != null) {
                c.accept(e);
            }
        });
    }

    default public <E> Seq<E> toSeq(Function<T, E> provider, int skip) {
        return c -> this.use(t -> {
            Object e;
            for (int i = 0; i < skip; ++i) {
                e = provider.apply(t);
                if (e != null) continue;
                return;
            }
            while ((e = provider.apply(t)) != null) {
                c.accept(e);
            }
        });
    }

    default public void use(Consumer<T> consumer) {
        this.useAndGet(consumer);
    }

    default public T useAndGet(Consumer<T> consumer) {
        try {
            T t = this.call();
            consumer.accept(t);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static interface Runnable {
        public void run() throws IOException;
    }

    public static interface Function<T, E> {
        public E apply(T var1) throws IOException;
    }

    public static interface Consumer<T> {
        public void accept(T var1) throws IOException;
    }

    public static interface Closable<C extends Closeable>
    extends IOChain<C> {
        @Override
        default public void use(Consumer<C> consumer) {
            try (Closeable closable = (Closeable)this.call();){
                consumer.accept(closable);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

