/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.IntPair;
import com.github.wolray.seq.Mutable;
import com.github.wolray.seq.Seq;
import com.github.wolray.seq.Seq0;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.OptionalInt;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;

public interface IntSeq
extends Seq0<IntConsumer> {
    public static final IntSeq empty = c -> {};
    public static final IntConsumer nothing = t -> {};

    public static IntSeq gen(int seed, IntUnaryOperator operator) {
        return c -> {
            int t = seed;
            c.accept(t);
            while (true) {
                t = operator.applyAsInt(t);
                c.accept(t);
            }
        };
    }

    public static IntSeq gen(int seed1, int seed2, IntBinaryOperator operator) {
        return c -> {
            int t1 = seed1;
            int t2 = seed2;
            c.accept(t1);
            c.accept(t2);
            while (true) {
                int n = t1;
                t1 = t2;
                t2 = operator.applyAsInt(n, t1);
                c.accept(t2);
            }
        };
    }

    public static IntSeq gen(IntSupplier supplier) {
        return c -> {
            while (true) {
                c.accept(supplier.getAsInt());
            }
        };
    }

    public static IntSeq of(CharSequence cs) {
        return c -> {
            for (int i = 0; i < cs.length(); ++i) {
                c.accept(cs.charAt(i));
            }
        };
    }

    public static IntSeq of(int ... ts) {
        return c -> {
            for (int t : ts) {
                c.accept(t);
            }
        };
    }

    public static IntSeq range(int start, int stop) {
        return IntSeq.range(start, stop, 1);
    }

    public static IntSeq range(int start, int stop, int step) {
        if (step == 0) {
            throw new IllegalArgumentException("step is 0");
        }
        return c -> {
            if (step > 0) {
                for (int i = start; i < stop; i += step) {
                    c.accept(i);
                }
            } else {
                for (int i = start; i > stop; i += step) {
                    c.accept(i);
                }
            }
        };
    }

    public static IntSeq range(int stop) {
        return IntSeq.range(0, stop, 1);
    }

    public static IntSeq repeat(int n, int value) {
        return c -> {
            for (int i = 0; i < n; ++i) {
                c.accept(value);
            }
        };
    }

    default public boolean all(IntPredicate predicate) {
        return !this.find(predicate.negate()).isPresent();
    }

    default public boolean any(IntPredicate predicate) {
        return this.find(predicate).isPresent();
    }

    default public boolean anyNot(IntPredicate predicate) {
        return this.any(predicate.negate());
    }

    default public IntSeq append(int t) {
        return c -> {
            this.consume(c);
            c.accept(t);
        };
    }

    default public IntSeq append(int ... t) {
        return c -> {
            this.consume(c);
            for (int x : t) {
                c.accept(x);
            }
        };
    }

    default public IntSeq appendWith(IntSeq seq) {
        return c -> {
            this.consume(c);
            seq.consume(c);
        };
    }

    default public double average() {
        return this.average(null);
    }

    default public double average(IntToDoubleFunction weightFunction) {
        double[] a = new double[]{0.0, 0.0};
        this.consume(t -> {
            if (weightFunction != null) {
                double w = weightFunction.applyAsDouble(t);
                a[0] = a[0] + (double)t * w;
                a[1] = a[1] + w;
            } else {
                a[0] = a[0] + (double)t;
                a[1] = a[1] + 1.0;
            }
        });
        return a[1] != 0.0 ? a[0] / a[1] : 0.0;
    }

    default public Seq<Integer> boxed() {
        return c -> this.consume(c::accept);
    }

    default public IntSeq circle() {
        return c -> {
            while (true) {
                this.consume(c);
            }
        };
    }

    default public void consume(IntConsumer consumer, int n, IntConsumer substitute) {
        if (n > 0) {
            int[] a = new int[]{n - 1};
            this.consume(t -> {
                if (a[0] < 0) {
                    consumer.accept(t);
                } else {
                    a[0] = a[0] - 1;
                    substitute.accept(t);
                }
            });
        } else {
            this.consume(consumer);
        }
    }

    default public void consumeIndexed(IndexIntConsumer consumer) {
        int[] a = new int[]{0};
        this.consume(t -> {
            int n = a[0];
            a[0] = n + 1;
            consumer.accept(n, t);
        });
    }

    default public void consumeIndexedTillStop(IndexIntConsumer consumer) {
        int[] a = new int[]{0};
        this.consumeTillStop(t -> {
            int n = a[0];
            a[0] = n + 1;
            consumer.accept(n, t);
        });
    }

    default public int count() {
        return this.reduce(new int[1], (a, t) -> {
            a[0] = a[0] + 1;
        })[0];
    }

    default public int count(IntPredicate predicate) {
        return this.reduce(new int[1], (a, t) -> {
            if (predicate.test(t)) {
                a[0] = a[0] + 1;
            }
        })[0];
    }

    default public int countNot(IntPredicate predicate) {
        return this.count(predicate.negate());
    }

    default public IntSeq distinct() {
        return this.distinctBy(i -> i);
    }

    default public <E> IntSeq distinctBy(IntFunction<E> function) {
        return c -> this.reduce(new HashSet(), (set, t) -> {
            if (set.add(function.apply(t))) {
                c.accept(t);
            }
        });
    }

    default public IntSeq drop(int n) {
        return n <= 0 ? this : this.partial(n, nothing);
    }

    default public IntSeq dropWhile(IntPredicate predicate) {
        return c -> this.foldBoolean(false, (b, t) -> {
            if (b || !predicate.test(t)) {
                c.accept(t);
                return true;
            }
            return false;
        });
    }

    default public IntSeq duplicateAll(int times) {
        return c -> {
            for (int i = 0; i < times; ++i) {
                this.consume(c);
            }
        };
    }

    default public IntSeq duplicateEach(int times) {
        return c -> this.consume(t -> {
            for (int i = 0; i < times; ++i) {
                c.accept(t);
            }
        });
    }

    default public IntSeq duplicateIf(int times, IntPredicate predicate) {
        return c -> this.consume(t -> {
            if (predicate.test(t)) {
                for (int i = 0; i < times; ++i) {
                    c.accept(t);
                }
            } else {
                c.accept(t);
            }
        });
    }

    default public IntSeq filter(int n, IntPredicate predicate) {
        return c -> this.consume((IntConsumer)c, n, t -> {
            if (predicate.test(t)) {
                c.accept(t);
            }
        });
    }

    default public IntSeq filter(IntPredicate predicate) {
        return c -> this.consume(t -> {
            if (predicate.test(t)) {
                c.accept(t);
            }
        });
    }

    default public IntSeq filterIndexed(IndexIntPredicate predicate) {
        return c -> this.consumeIndexed((i, t) -> {
            if (predicate.test(i, t)) {
                c.accept(t);
            }
        });
    }

    default public IntSeq filterNot(IntPredicate predicate) {
        return this.filter(predicate.negate());
    }

    default public OptionalInt find(IntPredicate predicate) {
        Mutable<Object> m = new Mutable<Object>(null);
        this.consumeTillStop(t -> {
            if (predicate.test(t)) {
                m.set(t);
                Seq.stop();
            }
        });
        return m.isSet ? OptionalInt.of((Integer)m.it) : OptionalInt.empty();
    }

    default public OptionalInt findNot(IntPredicate predicate) {
        return this.find(predicate.negate());
    }

    default public OptionalInt first() {
        return this.find(t -> true);
    }

    default public IntSeq flatMap(IntFunction<IntSeq> function) {
        return c -> this.consume(t -> ((IntSeq)function.apply(t)).consume(c));
    }

    default public <E> E fold(E init, ObjIntToObj<E> function) {
        Mutable<E> m = new Mutable<E>(init);
        this.consume(t -> {
            m.it = function.apply(m.it, t);
        });
        return (E)m.it;
    }

    default public int foldInt(int init, IntBinaryOperator function) {
        int[] a = new int[]{init};
        this.consume(i -> {
            a[0] = function.applyAsInt(a[0], i);
        });
        return a[0];
    }

    default public double foldDouble(double init, DoubleIntToDouble function) {
        double[] a = new double[]{init};
        this.consume(i -> {
            a[0] = function.apply(a[0], i);
        });
        return a[0];
    }

    default public long foldLong(long init, LongIntToLong function) {
        long[] a = new long[]{init};
        this.consume(i -> {
            a[0] = function.apply(a[0], i);
        });
        return a[0];
    }

    default public boolean foldBoolean(boolean init, BoolIntToBool function) {
        boolean[] a = new boolean[]{init};
        this.consume(i -> {
            a[0] = function.apply(a[0], i);
        });
        return a[0];
    }

    default public OptionalInt last() {
        Mutable<Object> m = new Mutable<Object>(null);
        this.consume(m::set);
        return m.isSet ? OptionalInt.of((Integer)m.it) : OptionalInt.empty();
    }

    default public OptionalInt last(IntPredicate predicate) {
        return this.filter(predicate).last();
    }

    default public OptionalInt lastNot(IntPredicate predicate) {
        return this.last(predicate.negate());
    }

    default public IntSeq map(IntUnaryOperator function) {
        return c -> this.consume(t -> c.accept(function.applyAsInt(t)));
    }

    default public IntSeq mapIndexed(IndexIntToInt function) {
        return c -> this.consumeIndexed((i, t) -> c.accept(function.apply(i, t)));
    }

    default public <E> Seq<E> mapToObj(IntFunction<E> function) {
        return c -> this.consume(t -> c.accept(function.apply(t)));
    }

    default public <E> Seq<E> mapToObj(IntFunction<E> function, int n, IntFunction<E> substitute) {
        return n <= 0 ? this.mapToObj(function) : c -> {
            int[] a = new int[]{n - 1};
            this.consume(t -> {
                if (a[0] < 0) {
                    c.accept(function.apply(t));
                } else {
                    a[0] = a[0] - 1;
                    c.accept(substitute.apply(t));
                }
            });
        };
    }

    default public Integer max() {
        return this.fold(null, (f, t) -> f == null || f < t ? t : f);
    }

    default public <V extends Comparable<V>> IntPair<V> max(IntFunction<V> function) {
        return this.reduce(new IntPair<Object>(0, null), (p, t) -> {
            Comparable v = (Comparable)function.apply(t);
            if (p.it == null || ((Comparable)p.it).compareTo(v) < 0) {
                p.intVal = t;
                p.it = v;
            }
        });
    }

    default public Integer min() {
        return this.fold(null, (f, t) -> f == null || f > t ? t : f);
    }

    default public <V extends Comparable<V>> IntPair<V> min(IntFunction<V> function) {
        return this.reduce(new IntPair<Object>(0, null), (p, t) -> {
            Comparable v = (Comparable)function.apply(t);
            if (p.it == null || ((Comparable)p.it).compareTo(v) > 0) {
                p.intVal = t;
                p.it = v;
            }
        });
    }

    default public boolean none(IntPredicate predicate) {
        return !this.find(predicate).isPresent();
    }

    default public IntSeq onEach(int n, IntConsumer consumer) {
        return c -> this.consume((IntConsumer)c, n, consumer.andThen((IntConsumer)c));
    }

    default public IntSeq onEach(IntConsumer consumer) {
        return c -> this.consume(consumer.andThen((IntConsumer)c));
    }

    default public IntSeq onEachIndexed(IndexIntConsumer consumer) {
        return c -> this.consumeIndexed((i, t) -> {
            consumer.accept(i, t);
            c.accept(t);
        });
    }

    default public IntSeq partial(int n, IntConsumer substitute) {
        return c -> this.consume((IntConsumer)c, n, substitute);
    }

    default public <E> E reduce(E des, ObjIntConsumer<E> consumer) {
        this.consume(t -> consumer.accept(des, t));
        return des;
    }

    default public IntSeq replace(int n, IntUnaryOperator operator) {
        return c -> this.consume((IntConsumer)c, n, t -> c.accept(operator.applyAsInt(t)));
    }

    default public IntSeq runningFold(int init, IntBinaryOperator function) {
        return c -> this.foldInt(init, (acc, t) -> {
            acc = function.applyAsInt(acc, t);
            c.accept(acc);
            return acc;
        });
    }

    default public int sum() {
        return this.reduce(new int[1], (a, t) -> {
            a[0] = a[0] + t;
        })[0];
    }

    default public int sum(IntUnaryOperator function) {
        return this.reduce(new int[1], (a, t) -> {
            a[0] = a[0] + function.applyAsInt(t);
        })[0];
    }

    default public IntSeq take(int n) {
        return n <= 0 ? empty : c -> {
            int[] i = new int[]{n};
            this.consumeTillStop(t -> {
                int n = i[0];
                i[0] = n - 1;
                if (n > 0) {
                    c.accept(t);
                } else {
                    Seq.stop();
                }
            });
        };
    }

    default public IntSeq takeWhile(IntPredicate predicate) {
        return c -> this.consumeTillStop(t -> {
            if (predicate.test(t)) {
                c.accept(t);
            } else {
                Seq.stop();
            }
        });
    }

    default public int[] toArray() {
        return this.toBatched().toArray();
    }

    default public Batched toBatched() {
        return this.reduce(new Batched(), Batched::add);
    }

    public static class Batched
    implements IntSeq {
        private final LinkedList<int[]> list = new LinkedList();
        private int batchSize = 10;
        public int size;
        private int[] cur;
        private int index;

        @Override
        public void consume(IntConsumer consumer) {
            this.list.forEach(a -> {
                int size = this.sizeOf((int[])a);
                for (int i = 0; i < size; ++i) {
                    consumer.accept(a[i]);
                }
            });
        }

        @Override
        public int[] toArray() {
            int[] a = new int[this.size];
            int pos = 0;
            for (int[] sub : this.list) {
                System.arraycopy(sub, 0, a, pos, this.sizeOf(sub));
                pos += sub.length;
            }
            return a;
        }

        public void add(int t) {
            if (this.cur == null) {
                this.cur = new int[this.batchSize];
                this.list.add(this.cur);
                this.index = 0;
            }
            this.cur[this.index++] = t;
            ++this.size;
            if (this.index == this.batchSize) {
                this.cur = null;
                this.batchSize = Math.min(300, Math.max(this.batchSize, this.size >> 1));
            }
        }

        private int sizeOf(int[] a) {
            return a != this.cur ? a.length : this.index;
        }
    }

    public static interface IndexIntToInt {
        public int apply(int var1, int var2);
    }

    public static interface IndexIntPredicate {
        public boolean test(int var1, int var2);
    }

    public static interface IndexIntConsumer {
        public void accept(int var1, int var2);
    }

    public static interface BoolIntToBool {
        public boolean apply(boolean var1, int var2);
    }

    public static interface LongIntToLong {
        public long apply(long var1, int var3);
    }

    public static interface DoubleIntToDouble {
        public long apply(double var1, int var3);
    }

    public static interface ObjIntToObj<E> {
        public E apply(E var1, int var2);
    }

    public static interface ObjIntConsumer<E> {
        public void accept(E var1, int var2);
    }
}

