/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ItrUtil;
import com.github.wolray.seq.MapItr;
import com.github.wolray.seq.PickItr;
import com.github.wolray.seq.Seq;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ItrSeq<T>
extends Iterable<T>,
Seq<T> {
    @Override
    default public ItrSeq<T> asIterable() {
        return this;
    }

    @Override
    default public void consume(Consumer<T> consumer) {
        this.forEach(consumer);
    }

    @Override
    default public ItrSeq<T> drop(int n) {
        return () -> ItrUtil.drop(this.iterator(), n);
    }

    @Override
    default public ItrSeq<T> dropWhile(Predicate<T> predicate) {
        return () -> ItrUtil.dropWhile(this.iterator(), predicate);
    }

    @Override
    default public ItrSeq<T> filter(Predicate<T> predicate) {
        return predicate == null ? this : () -> ItrUtil.filter(this.iterator(), predicate);
    }

    @Override
    default public <E> ItrSeq<E> filterInstance(final Class<E> cls) {
        return () -> new PickItr<E>(){
            Iterator iterator;
            {
                this.iterator = ItrSeq.this.iterator();
            }

            @Override
            public E pick() {
                while (this.iterator.hasNext()) {
                    Object t = this.iterator.next();
                    if (!cls.isInstance(t)) continue;
                    return cls.cast(t);
                }
                return Seq.stop();
            }
        };
    }

    @Override
    default public Optional<T> find(Predicate<T> predicate) {
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    @Override
    default public T first() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            Object t = iterator.next();
            return t;
        }
        return null;
    }

    @Override
    default public <E> ItrSeq<E> flatIterable(Function<T, Iterable<E>> function) {
        return () -> ItrUtil.flat(this.iterator(), function);
    }

    @Override
    default public <E> ItrSeq<E> flatOptional(Function<T, Optional<E>> function) {
        return () -> ItrUtil.flatOptional(ItrUtil.map(this.iterator(), function));
    }

    @Override
    default public <E> E fold(E init, BiFunction<E, T, E> function) {
        E acc = init;
        for (Object t : this) {
            acc = function.apply(acc, t);
        }
        return acc;
    }

    @Override
    default public T last() {
        T res = null;
        for (Object t : this) {
            res = t;
        }
        return res;
    }

    @Override
    default public <E> ItrSeq<E> map(Function<T, E> function) {
        return () -> ItrUtil.map(this.iterator(), function);
    }

    @Override
    default public <E> ItrSeq<E> map(Function<T, E> function, int n, Function<T, E> substitute) {
        return n <= 0 ? this.map((Function)function) : () -> ItrUtil.map(this.iterator(), function, n, substitute);
    }

    @Override
    default public <E> ItrSeq<E> mapIndexed(Seq.IndexObjFunction<T, E> function) {
        return () -> ItrUtil.mapIndexed(this.iterator(), function);
    }

    @Override
    default public <E> ItrSeq<E> mapMaybe(final Function<T, E> function) {
        return () -> new PickItr<E>(){
            Iterator iterator;
            {
                this.iterator = ItrSeq.this.iterator();
            }

            @Override
            public E pick() {
                while (this.iterator.hasNext()) {
                    Object t = this.iterator.next();
                    if (t == null) continue;
                    return function.apply(t);
                }
                return Seq.stop();
            }
        };
    }

    @Override
    default public <E> ItrSeq<E> mapNotNull(final Function<T, E> function) {
        return () -> new PickItr<E>(){
            Iterator iterator;
            {
                this.iterator = ItrSeq.this.iterator();
            }

            @Override
            public E pick() {
                while (this.iterator.hasNext()) {
                    Object e = function.apply(this.iterator.next());
                    if (e == null) continue;
                    return e;
                }
                return Seq.stop();
            }
        };
    }

    @Override
    default public ItrSeq<T> onEach(Consumer<T> consumer) {
        return this.map((T t) -> {
            consumer.accept(t);
            return t;
        });
    }

    @Override
    default public ItrSeq<T> onEach(int n, Consumer<T> consumer) {
        return this.map((T t) -> t, n, (T t) -> {
            consumer.accept(t);
            return t;
        });
    }

    @Override
    default public <E> ItrSeq<E> runningFold(final E init, final BiFunction<E, T, E> function) {
        return () -> new MapItr<T, E>(this.iterator()){
            Object acc;
            {
                super(iterator);
                this.acc = init;
            }

            @Override
            public E apply(T t) {
                this.acc = function.apply(this.acc, t);
                return this.acc;
            }
        };
    }

    @Override
    default public ItrSeq<T> take(int n) {
        return () -> ItrUtil.take(this.iterator(), n);
    }

    @Override
    default public <E> ItrSeq<T> takeWhile(Function<T, E> function, BiPredicate<E, E> testPrevCurr) {
        return () -> ItrUtil.takeWhile(this.iterator(), function, testPrevCurr);
    }

    @Override
    default public ItrSeq<T> takeWhile(Predicate<T> predicate) {
        return () -> ItrUtil.takeWhile(this.iterator(), predicate);
    }

    default public ItrSeq<T> zip(T t) {
        return () -> ItrUtil.zip(this.iterator(), t);
    }
}

