/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.MapItr;
import com.github.wolray.seq.PickItr;
import com.github.wolray.seq.Seq;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ItrUtil {
    public static <T> Iterator<T> drop(final Iterator<T> iterator, final int n) {
        return n <= 0 ? iterator : new PickItr<T>(){
            int i;
            {
                this.i = n;
            }

            @Override
            public T pick() {
                while (this.i > 0) {
                    ItrUtil.pop(iterator);
                    --this.i;
                }
                return ItrUtil.pop(iterator);
            }
        };
    }

    public static <T> Iterator<T> dropWhile(final Iterator<T> iterator, final Predicate<T> predicate) {
        return new PickItr<T>(){
            boolean flag = true;

            @Override
            public T pick() {
                Object t = ItrUtil.pop(iterator);
                if (this.flag) {
                    while (predicate.test(t)) {
                        t = ItrUtil.pop(iterator);
                    }
                    this.flag = false;
                }
                return t;
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> iterator, final Predicate<T> predicate) {
        return new PickItr<T>(){

            @Override
            public T pick() {
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!predicate.test(t)) continue;
                    return t;
                }
                return Seq.stop();
            }
        };
    }

    public static <T> PickItr<T> flat(final Iterator<? extends Iterable<T>> iterator) {
        return new PickItr<T>(){
            Iterator<T> cur = Collections.emptyIterator();

            @Override
            public T pick() {
                while (!this.cur.hasNext()) {
                    this.cur = ((Iterable)ItrUtil.pop(iterator)).iterator();
                }
                return this.cur.next();
            }
        };
    }

    public static <T, E> PickItr<E> flat(Iterator<T> iterator, Function<T, ? extends Iterable<E>> function) {
        return ItrUtil.flat(ItrUtil.map(iterator, function));
    }

    public static <T> PickItr<T> flatOptional(final Iterator<Optional<T>> iterator) {
        return new PickItr<T>(){

            @Override
            public T pick() {
                while (iterator.hasNext()) {
                    Optional opt = (Optional)iterator.next();
                    if (!opt.isPresent()) continue;
                    return opt.get();
                }
                return Seq.stop();
            }
        };
    }

    public static <T, E> Iterator<E> map(Iterator<T> iterator, final Function<T, E> function) {
        return new MapItr<T, E>(iterator){

            @Override
            public E apply(T t) {
                return function.apply(t);
            }
        };
    }

    public static <T, E> Iterator<E> map(Iterator<T> iterator, final Function<T, E> function, final int n, final Function<T, E> substitute) {
        return new MapItr<T, E>(iterator){
            int i;
            {
                super(iterator);
                this.i = n - 1;
            }

            @Override
            public E apply(T t) {
                if (this.i < 0) {
                    return function.apply(t);
                }
                --this.i;
                return substitute.apply(t);
            }
        };
    }

    public static <T, E> Iterator<E> mapIndexed(Iterator<T> iterator, final Seq.IndexObjFunction<T, E> function) {
        return new MapItr<T, E>(iterator){
            int i;
            {
                super(iterator);
                this.i = 0;
            }

            @Override
            public E apply(T t) {
                return function.apply(this.i++, t);
            }
        };
    }

    public static <T> T pop(Iterator<T> iterator) {
        return iterator.hasNext() ? iterator.next() : Seq.stop();
    }

    public static <T> Iterator<T> take(final Iterator<T> iterator, final int n) {
        return n <= 0 ? Collections.emptyIterator() : new PickItr<T>(){
            int i;
            {
                this.i = n;
            }

            @Override
            public T pick() {
                return this.i-- > 0 ? ItrUtil.pop(iterator) : Seq.stop();
            }
        };
    }

    public static <T, E> Iterator<T> takeWhile(final Iterator<T> iterator, final Function<T, E> function, final BiPredicate<E, E> testPrevCurr) {
        return new PickItr<T>(){
            E last = null;

            @Override
            public T pick() {
                Object t = ItrUtil.pop(iterator);
                Object curr = function.apply(t);
                if (this.last == null || testPrevCurr.test(this.last, curr)) {
                    this.last = curr;
                    return t;
                }
                return Seq.stop();
            }
        };
    }

    public static <T> Iterator<T> takeWhile(final Iterator<T> iterator, final Predicate<T> predicate) {
        return new PickItr<T>(){

            @Override
            public T pick() {
                Object t = ItrUtil.pop(iterator);
                return predicate.test(t) ? t : Seq.stop();
            }
        };
    }

    public static InputStream toInputStream(Iterable<String> iterable, String separator) {
        return ItrUtil.toInputStream(iterable.iterator(), separator);
    }

    public static InputStream toInputStream(Iterator<String> iterator, String separator) {
        return new InputItr(iterator, separator);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Iterator<T> zip(final Iterator<T> iterator, final T t) {
        return new PickItr<T>(){
            boolean flag = false;

            @Override
            public T pick() {
                this.flag = !this.flag;
                return this.flag ? ItrUtil.pop(iterator) : t;
            }
        };
    }

    public static class InputItr
    extends InputStream {
        final Iterator<byte[]> iterator;
        byte[] cur = new byte[0];
        int i;

        public InputItr(Iterator<String> itr, String sep) {
            Iterator<byte[]> bytesIterator = ItrUtil.map(itr, String::getBytes);
            this.iterator = sep.isEmpty() ? bytesIterator : ItrUtil.zip(bytesIterator, sep.getBytes());
        }

        @Override
        public int read() {
            if (this.i < this.cur.length) {
                return this.cur[this.i++] & 0xFF;
            }
            this.i = 0;
            while (this.iterator.hasNext()) {
                this.cur = this.iterator.next();
                if (this.cur.length <= 0) continue;
                return this.cur[this.i++] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int srcRest = this.cur.length - this.i;
            if (srcRest >= len) {
                System.arraycopy(this.cur, this.i, b, off, len);
                this.i += len;
                return len;
            }
            int count = 0;
            if (srcRest > 0) {
                System.arraycopy(this.cur, this.i, b, off, srcRest);
                off += srcRest;
                count += srcRest;
                this.i = this.cur.length;
            }
            while (count < len && this.iterator.hasNext()) {
                byte[] bytes = this.iterator.next();
                if (bytes.length <= 0) continue;
                int desRest = len - count;
                if (bytes.length >= desRest) {
                    this.cur = bytes;
                    System.arraycopy(bytes, 0, b, off, desRest);
                    this.i = desRest;
                    count = len;
                    continue;
                }
                System.arraycopy(bytes, 0, b, off, bytes.length);
                off += bytes.length;
                count += bytes.length;
            }
            return count > 0 ? count : -1;
        }
    }
}

