/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Function3;
import com.github.wolray.seq.Function4;
import com.github.wolray.seq.Function5;
import com.github.wolray.seq.Function6;
import com.github.wolray.seq.Mutable;
import com.github.wolray.seq.Seq;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface Lazy<T>
extends Supplier<T> {
    public T forkJoin(ForkJoinPool var1);

    public static <T> Lazy<T> of(Seq<T> seq) {
        return seq.lazyLast();
    }

    public static <A, T> Lazy<T> of(Supplier<A> s1, Function<A, T> function) {
        return Lazy.of(() -> function.apply(s1.get()));
    }

    public static <A, B, T> Lazy<T> of(final Supplier<A> s1, final Supplier<B> s2, final BiFunction<A, B, T> function) {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = function.apply(s1.get(), s2.get());
            }

            @Override
            protected void eval(ForkJoinPool pool) {
                Supplier a = Lazy.submit(pool, s1);
                Supplier b = Lazy.submit(pool, s2);
                this.it = function.apply(a.get(), b.get());
            }
        };
    }

    public static <A, B, C, T> Lazy<T> of(final Supplier<A> s1, final Supplier<B> s2, final Supplier<C> s3, final Function3<A, B, C, T> function) {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = function.apply(s1.get(), s2.get(), s3.get());
            }

            @Override
            protected void eval(ForkJoinPool pool) {
                Supplier u = Lazy.submit(pool, s1);
                Supplier v = Lazy.submit(pool, s2);
                Supplier w = Lazy.submit(pool, s3);
                this.it = function.apply(u.get(), v.get(), w.get());
            }
        };
    }

    public static <A, B, C, D, T> Lazy<T> of(final Supplier<A> s1, final Supplier<B> s2, final Supplier<C> s3, final Supplier<D> s4, final Function4<A, B, C, D, T> function) {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = function.apply(s1.get(), s2.get(), s3.get(), s4.get());
            }

            @Override
            protected void eval(ForkJoinPool pool) {
                Supplier a = Lazy.submit(pool, s1);
                Supplier b = Lazy.submit(pool, s2);
                Supplier c = Lazy.submit(pool, s3);
                Supplier d = Lazy.submit(pool, s4);
                this.it = function.apply(a.get(), b.get(), c.get(), d.get());
            }
        };
    }

    public static <A, B, C, D, E, T> Lazy<T> of(final Supplier<A> s1, final Supplier<B> s2, final Supplier<C> s3, final Supplier<D> s4, final Supplier<E> s5, final Function5<A, B, C, D, E, T> function) {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = function.apply(s1.get(), s2.get(), s3.get(), s4.get(), s5.get());
            }

            @Override
            protected void eval(ForkJoinPool pool) {
                Supplier a = Lazy.submit(pool, s1);
                Supplier b = Lazy.submit(pool, s2);
                Supplier c = Lazy.submit(pool, s3);
                Supplier d = Lazy.submit(pool, s4);
                Supplier e = Lazy.submit(pool, s5);
                this.it = function.apply(a.get(), b.get(), c.get(), d.get(), e.get());
            }
        };
    }

    public static <A, B, C, D, E, F, T> Lazy<T> of(final Supplier<A> s1, final Supplier<B> s2, final Supplier<C> s3, final Supplier<D> s4, final Supplier<E> s5, final Supplier<F> s6, final Function6<A, B, C, D, E, F, T> function) {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = function.apply(s1.get(), s2.get(), s3.get(), s4.get(), s5.get(), s6.get());
            }

            @Override
            protected void eval(ForkJoinPool pool) {
                Supplier a = Lazy.submit(pool, s1);
                Supplier b = Lazy.submit(pool, s2);
                Supplier c = Lazy.submit(pool, s3);
                Supplier d = Lazy.submit(pool, s4);
                Supplier e = Lazy.submit(pool, s5);
                Supplier f = Lazy.submit(pool, s6);
                this.it = function.apply(a.get(), b.get(), c.get(), d.get(), e.get(), f.get());
            }
        };
    }

    public static <T> Lazy<T> of(final Supplier<T> supplier) {
        if (supplier instanceof Lazy) {
            return (Lazy)supplier;
        }
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                this.it = supplier.get();
            }
        };
    }

    public static <T> Supplier<T> submit(final ForkJoinPool pool, final Supplier<T> supplier) {
        RecursiveTask task;
        if (supplier instanceof Lazy) {
            final Lazy lazy = (Lazy)supplier;
            if (lazy.isSet()) {
                return lazy;
            }
            task = new RecursiveTask<T>(){

                @Override
                protected T compute() {
                    return lazy.forkJoin(pool);
                }
            };
        } else {
            task = new RecursiveTask<T>(){

                @Override
                protected T compute() {
                    return supplier.get();
                }
            };
        }
        pool.submit(task);
        return task::join;
    }

    public static <T> Lazy<T> unset() {
        return Lazy.of(() -> {
            throw new UnsetException();
        });
    }

    default public Lazy<T> andThen(Consumer<T> consumer) {
        return Lazy.of(() -> {
            Object t = this.get();
            consumer.accept(t);
            return t;
        });
    }

    default public T forkJoin() {
        return this.forkJoin(ForkJoinPool.commonPool());
    }

    default public void ifSet(Consumer<T> consumer) {
        if (this.isSet()) {
            consumer.accept(this.get());
        }
    }

    default public boolean isSet() {
        throw new UnsupportedOperationException();
    }

    default public <E> Lazy<E> map(Function<T, E> function) {
        return Lazy.of(this, function);
    }

    default public T set(T value) {
        throw new UnsupportedOperationException();
    }

    default public Lazy<T> wrap(UnaryOperator<Supplier<T>> operator) {
        return Lazy.of((Supplier)operator.apply(this));
    }

    public static class UnsetException
    extends RuntimeException {
    }
}

