/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ArraySeq;
import com.github.wolray.seq.BatchedSeq;
import com.github.wolray.seq.ConcurrentSeq;
import com.github.wolray.seq.DoublePair;
import com.github.wolray.seq.IntPair;
import com.github.wolray.seq.LinkedSeq;
import com.github.wolray.seq.LinkedSeqSet;
import com.github.wolray.seq.LongPair;
import com.github.wolray.seq.Pair;
import com.github.wolray.seq.SeqMap;
import com.github.wolray.seq.SeqSet;
import com.github.wolray.seq.Transducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface Reducer<T, V> {
    public Supplier<V> supplier();

    public BiConsumer<V, T> accumulator();

    public Consumer<V> finisher();

    public static <T> Transducer<T, ?, Double> average(ToDoubleFunction<T> function) {
        return Reducer.average(function, null);
    }

    public static <T> Transducer<T, ?, Double> average(ToDoubleFunction<T> function, ToDoubleFunction<T> weightFunction) {
        BiConsumer<double[], Object> biConsumer = weightFunction != null ? (a, t) -> {
            double v = function.applyAsDouble(t);
            double w = weightFunction.applyAsDouble(t);
            a[0] = a[0] + v * w;
            a[1] = a[1] + w;
        } : (a, t) -> {
            a[0] = a[0] + function.applyAsDouble(t);
            a[1] = a[1] + 1.0;
        };
        return Transducer.of(() -> new double[2], biConsumer, (V a) -> a[1] != 0.0 ? a[0] / a[1] : 0.0);
    }

    public static <T, C extends Collection<T>> Reducer<T, C> collect(Supplier<C> des) {
        return Reducer.of(des, Collection::add);
    }

    public static <T> Transducer<T, ?, Integer> count() {
        return Transducer.of(() -> new int[1], (V a, T t) -> {
            a[0] = a[0] + 1;
        }, (V a) -> a[0]);
    }

    public static <T> Transducer<T, ?, Integer> count(Predicate<T> predicate) {
        return Transducer.of(() -> new int[1], (V a, T t) -> {
            if (predicate.test(t)) {
                a[0] = a[0] + 1;
            }
        }, (V a) -> a[0]);
    }

    public static <T> Transducer<T, ?, Integer> countNot(Predicate<T> predicate) {
        return Reducer.count(predicate.negate());
    }

    public static <T> Reducer<T, ArraySeq<T>> filtering(Predicate<T> predicate) {
        return Reducer.filtering(predicate, Reducer.toList());
    }

    public static <T, V> Reducer<T, V> filtering(Predicate<T> predicate, Reducer<T, V> reducer) {
        BiConsumer accumulator = reducer.accumulator();
        return Reducer.of(reducer.supplier(), (v, t) -> {
            if (predicate.test(t)) {
                accumulator.accept(v, t);
            }
        }, reducer.finisher());
    }

    public static <T, V, E> Transducer<T, V, E> filtering(Predicate<T> predicate, Transducer<T, V, E> transducer) {
        return Transducer.of(Reducer.filtering(predicate, transducer.reducer()), transducer.transformer());
    }

    public static <T, K, V> Reducer<T, SeqMap<K, V>> groupBy(Function<T, K> toKey, Reducer<T, V> reducer) {
        Supplier supplier = reducer.supplier();
        BiConsumer accumulator = reducer.accumulator();
        Consumer finisher = reducer.finisher();
        return Reducer.of(SeqMap::hash, (m, t) -> accumulator.accept(m.computeIfAbsent(toKey.apply(t), arg_0 -> Reducer.lambda$null$11((Supplier)supplier, arg_0)), t), finisher == null ? null : m -> m.justValues().consume(finisher));
    }

    public static <T, K, V, E> Transducer<T, ?, SeqMap<K, E>> groupBy(Function<T, K> toKey, Transducer<T, V, E> transducer) {
        return Transducer.of(Reducer.groupBy(toKey, transducer.reducer()), (V m) -> m.replaceValue(transducer.transformer()));
    }

    public static <T> Transducer<T, ?, String> join(String sep, Function<T, String> function) {
        return Transducer.of(() -> new StringJoiner(sep), (V j, T t) -> j.add((CharSequence)function.apply(t)), StringJoiner::toString);
    }

    public static <T, E> Reducer<T, ArraySeq<E>> mapping(Function<T, E> mapper) {
        return Reducer.mapping(mapper, Reducer.toList());
    }

    public static <T, E, V> Reducer<T, V> mapping(Function<T, E> mapper, Reducer<E, V> reducer) {
        BiConsumer accumulator = reducer.accumulator();
        return Reducer.of(reducer.supplier(), (v, t) -> {
            Object e = mapper.apply(t);
            accumulator.accept(v, e);
        }, reducer.finisher());
    }

    public static <T, R, V, E> Transducer<T, V, E> mapping(Function<T, R> mapper, Transducer<R, V, E> transducer) {
        return Transducer.of(Reducer.mapping(mapper, transducer.reducer()), transducer.transformer());
    }

    public static <T> Transducer<T, ?, T> max(Comparator<T> comparator) {
        return Transducer.of((t1, t2) -> comparator.compare(t1, t2) < 0 ? t2 : t1);
    }

    public static <T, V extends Comparable<V>> Reducer<T, AtomicReference<Pair<T, V>>> maxAtomicBy(V initValue, Function<T, V> function) {
        return Reducer.of(() -> new AtomicReference<Pair<Object, Comparable>>(new Pair<Object, Comparable>(null, initValue)), (ref, t) -> {
            Comparable v = (Comparable)function.apply(t);
            ref.updateAndGet(p -> {
                if (((Comparable)p.second).compareTo(v) < 0) {
                    p.set(t, v);
                }
                return p;
            });
        });
    }

    public static <T, V extends Comparable<V>> Reducer<T, Pair<T, V>> maxBy(Function<T, V> function) {
        return Reducer.of(() -> new Pair<Object, Object>(null, null), (p, t) -> {
            Comparable v = (Comparable)function.apply(t);
            if (p.second == null || ((Comparable)p.second).compareTo(v) < 0) {
                p.set(t, v);
            }
        });
    }

    public static <T> Reducer<T, IntPair<T>> maxByInt(ToIntFunction<T> function) {
        return Reducer.of(() -> new IntPair<Object>(0, null), (p, t) -> {
            int v = function.applyAsInt(t);
            if (p.it == null || p.intVal < v) {
                p.intVal = v;
                p.it = t;
            }
        });
    }

    public static <T> Reducer<T, DoublePair<T>> maxByDouble(ToDoubleFunction<T> function) {
        return Reducer.of(() -> new DoublePair<Object>(0.0, null), (p, t) -> {
            double v = function.applyAsDouble(t);
            if (p.it == null || p.doubleVal < v) {
                p.doubleVal = v;
                p.it = t;
            }
        });
    }

    public static <T> Reducer<T, LongPair<T>> maxByLong(ToLongFunction<T> function) {
        return Reducer.of(() -> new LongPair<Object>(0L, null), (p, t) -> {
            long v = function.applyAsLong(t);
            if (p.it == null || p.longVal < v) {
                p.longVal = v;
                p.it = t;
            }
        });
    }

    public static <T> Transducer<T, ?, T> min(Comparator<T> comparator) {
        return Transducer.of((t1, t2) -> comparator.compare(t1, t2) > 0 ? t2 : t1);
    }

    public static <T, V extends Comparable<V>> Reducer<T, AtomicReference<Pair<T, V>>> minAtomicBy(V initValue, Function<T, V> function) {
        return Reducer.of(() -> new AtomicReference<Pair<Object, Comparable>>(new Pair<Object, Comparable>(null, initValue)), (ref, t) -> {
            Comparable v = (Comparable)function.apply(t);
            ref.updateAndGet(p -> {
                if (((Comparable)p.second).compareTo(v) > 0) {
                    p.set(t, v);
                }
                return p;
            });
        });
    }

    public static <T, V extends Comparable<V>> Reducer<T, Pair<T, V>> minBy(Function<T, V> function) {
        return Reducer.of(() -> new Pair<Object, Object>(null, null), (p, t) -> {
            Comparable v = (Comparable)function.apply(t);
            if (p.second == null || ((Comparable)p.second).compareTo(v) > 0) {
                p.set(t, v);
            }
        });
    }

    public static <T> Reducer<T, IntPair<T>> minByInt(ToIntFunction<T> function) {
        return Reducer.of(() -> new IntPair<Object>(0, null), (p, t) -> {
            int v = function.applyAsInt(t);
            if (p.it == null || p.intVal > v) {
                p.intVal = v;
                p.it = t;
            }
        });
    }

    public static <T> Reducer<T, DoublePair<T>> minByDouble(ToDoubleFunction<T> function) {
        return Reducer.of(() -> new DoublePair<Object>(0.0, null), (p, t) -> {
            double v = function.applyAsDouble(t);
            if (p.it == null || p.doubleVal > v) {
                p.doubleVal = v;
                p.it = t;
            }
        });
    }

    public static <T> Reducer<T, LongPair<T>> minByLong(ToLongFunction<T> function) {
        return Reducer.of(() -> new LongPair<Object>(0L, null), (p, t) -> {
            long v = function.applyAsLong(t);
            if (p.it == null || p.longVal > v) {
                p.longVal = v;
                p.it = t;
            }
        });
    }

    public static <T, V> Reducer<T, V> of(Supplier<V> supplier, BiConsumer<V, T> accumulator) {
        return Reducer.of(supplier, accumulator, null);
    }

    public static <T, V> Reducer<T, V> of(final Supplier<V> supplier, final BiConsumer<V, T> accumulator, final Consumer<V> finisher) {
        return new Reducer<T, V>(){

            @Override
            public Supplier<V> supplier() {
                return supplier;
            }

            @Override
            public BiConsumer<V, T> accumulator() {
                return accumulator;
            }

            @Override
            public Consumer<V> finisher() {
                return finisher;
            }
        };
    }

    public static <T> Reducer<T, Pair<BatchedSeq<T>, BatchedSeq<T>>> partition(Predicate<T> predicate) {
        return Reducer.partition(predicate, Reducer.toBatched());
    }

    public static <T, V> Reducer<T, Pair<V, V>> partition(Predicate<T> predicate, Reducer<T, V> reducer) {
        BiConsumer accumulator = reducer.accumulator();
        Supplier supplier = reducer.supplier();
        Consumer finisher = reducer.finisher();
        return Reducer.of(() -> new Pair(supplier.get(), supplier.get()), (p, t) -> accumulator.accept(predicate.test(t) ? p.first : p.second, t), finisher == null ? null : p -> {
            finisher.accept(p.first);
            finisher.accept(p.second);
        });
    }

    public static <T, V, R> Transducer<T, ?, Pair<R, R>> partition(Predicate<T> predicate, Transducer<T, V, R> transducer) {
        Function mapper = transducer.transformer();
        return Transducer.of(Reducer.partition(predicate, transducer.reducer()), (V p) -> new Pair(mapper.apply(p.first), mapper.apply(p.second)));
    }

    public static <T> Reducer<T, ArraySeq<T>> reverse() {
        return Reducer.toList().then(Collections::reverse);
    }

    public static <T> Reducer<T, ArraySeq<T>> sort() {
        return Reducer.sort((Comparator)null);
    }

    public static <T> Reducer<T, ArraySeq<T>> sort(Comparator<T> comparator) {
        return Reducer.toList().then(ts -> ts.sort(comparator));
    }

    public static <T, V extends Comparable<V>> Reducer<T, ArraySeq<T>> sort(Function<T, V> function) {
        return Reducer.sort(Comparator.comparing(function));
    }

    public static <T> Reducer<T, ArraySeq<T>> sortDesc() {
        return Reducer.sort(Collections.reverseOrder());
    }

    public static <T> Reducer<T, ArraySeq<T>> sortDesc(Comparator<T> comparator) {
        return Reducer.sort(comparator.reversed());
    }

    public static <T, V extends Comparable<V>> Reducer<T, ArraySeq<T>> sortDesc(Function<T, V> function) {
        return Reducer.sort(Comparator.comparing(function).reversed());
    }

    public static <T> Transducer<T, ?, Double> sum(ToDoubleFunction<T> function) {
        return Transducer.of(() -> new double[1], (V a, T t) -> {
            a[0] = a[0] + function.applyAsDouble(t);
        }, (V a) -> a[0]);
    }

    public static <T> Transducer<T, ?, Integer> sumInt(ToIntFunction<T> function) {
        return Transducer.of(() -> new int[1], (V a, T t) -> {
            a[0] = a[0] + function.applyAsInt(t);
        }, (V a) -> a[0]);
    }

    public static <T> Transducer<T, ?, Long> sumLong(ToLongFunction<T> function) {
        return Transducer.of(() -> new long[1], (V a, T t) -> {
            a[0] = a[0] + function.applyAsLong(t);
        }, (V a) -> a[0]);
    }

    public static <T> Reducer<T, BatchedSeq<T>> toBatched() {
        return Reducer.of(BatchedSeq::new, BatchedSeq::add);
    }

    public static <T> Reducer<T, ConcurrentSeq<T>> toConcurrent() {
        return Reducer.of(ConcurrentSeq::new, ConcurrentLinkedQueue::add);
    }

    public static <T> Reducer<T, LinkedSeq<T>> toLinked() {
        return Reducer.of(LinkedSeq::new, LinkedList::add);
    }

    public static <T> Reducer<T, ArraySeq<T>> toList() {
        return Reducer.of(ArraySeq::new, ArrayList::add);
    }

    public static <T> Reducer<T, ArraySeq<T>> toList(int initialCapacity) {
        return Reducer.of(() -> new ArraySeq(initialCapacity), ArrayList::add);
    }

    public static <T, K, V> Reducer<T, SeqMap<K, V>> toMap(Function<T, K> toKey, Function<T, V> toValue) {
        return Reducer.of(SeqMap::hash, (m, t) -> m.put(toKey.apply(t), toValue.apply(t)));
    }

    public static <T, K, V> Reducer<T, SeqMap<K, V>> toMap(Supplier<Map<K, V>> mapSupplier, Function<T, K> toKey, Function<T, V> toValue) {
        return Reducer.of(() -> SeqMap.of((Map)mapSupplier.get()), (m, t) -> m.put(toKey.apply(t), toValue.apply(t)));
    }

    public static <T, K> Reducer<T, SeqMap<K, T>> toMapBy(Function<T, K> toKey) {
        return Reducer.toMapBy(LinkedHashMap::new, toKey);
    }

    public static <T, K> Reducer<T, SeqMap<K, T>> toMapBy(Supplier<Map<K, T>> mapSupplier, Function<T, K> toKey) {
        return Reducer.of(() -> SeqMap.of((Map)mapSupplier.get()), (m, t) -> m.put(toKey.apply(t), t));
    }

    public static <T, V> Reducer<T, SeqMap<T, V>> toMapWith(Function<T, V> toValue) {
        return Reducer.toMapWith(LinkedHashMap::new, toValue);
    }

    public static <T, V> Reducer<T, SeqMap<T, V>> toMapWith(Supplier<Map<T, V>> mapSupplier, Function<T, V> toValue) {
        return Reducer.of(() -> SeqMap.of((Map)mapSupplier.get()), (m, t) -> m.put(t, toValue.apply(t)));
    }

    public static <T> Reducer<T, SeqSet<T>> toSet() {
        return Reducer.of(LinkedSeqSet::new, Set::add);
    }

    public static <T> Reducer<T, SeqSet<T>> toSet(int initialCapacity) {
        return Reducer.of(() -> new LinkedSeqSet(initialCapacity), Set::add);
    }

    default public Reducer<T, V> then(Consumer<V> action) {
        Consumer<V> finisher = this.finisher();
        return Reducer.of(this.supplier(), this.accumulator(), finisher == null ? action : finisher.andThen(action));
    }

    private static /* synthetic */ Object lambda$null$11(Supplier supplier, Object k) {
        return supplier.get();
    }
}

