/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ArraySeq;
import com.github.wolray.seq.BatchedSeq;
import com.github.wolray.seq.BoolPair;
import com.github.wolray.seq.ConcurrentSeq;
import com.github.wolray.seq.Consumer3;
import com.github.wolray.seq.DoublePair;
import com.github.wolray.seq.IntPair;
import com.github.wolray.seq.IntSeq;
import com.github.wolray.seq.ItrSeq;
import com.github.wolray.seq.ItrUtil;
import com.github.wolray.seq.Lazy;
import com.github.wolray.seq.LinkedSeq;
import com.github.wolray.seq.LongPair;
import com.github.wolray.seq.Mutable;
import com.github.wolray.seq.Pair;
import com.github.wolray.seq.PickItr;
import com.github.wolray.seq.Reducer;
import com.github.wolray.seq.Seq0;
import com.github.wolray.seq.Seq2;
import com.github.wolray.seq.Seq3;
import com.github.wolray.seq.SeqExpand;
import com.github.wolray.seq.SeqMap;
import com.github.wolray.seq.SeqSet;
import com.github.wolray.seq.SizedSeq;
import com.github.wolray.seq.StopException;
import com.github.wolray.seq.Transducer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Seq<T>
extends Seq0<Consumer<T>> {
    public static <T> Seq<T> empty() {
        return Empty.emptySeq;
    }

    public static <T> Seq<T> flat(Seq<Optional<T>> seq) {
        return c -> seq.consume(o -> o.ifPresent(c));
    }

    @SafeVarargs
    public static <T> Seq<T> flat(Seq<T> ... seq) {
        return c -> {
            for (Seq s : seq) {
                s.consume(c);
            }
        };
    }

    public static <T> ItrSeq<T> flatIterable(Iterable<Optional<T>> iterable) {
        return () -> ItrUtil.flatOptional(iterable.iterator());
    }

    @SafeVarargs
    public static <T> ItrSeq<T> flatIterable(Iterable<T> ... iterables) {
        return () -> ItrUtil.flat(Arrays.asList(iterables).iterator());
    }

    public static <T> ItrSeq<T> gen(final Supplier<T> supplier) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return supplier.get();
            }
        };
    }

    public static <T> Seq<T> gen(T seed, UnaryOperator<T> operator) {
        return c -> {
            Object t = seed;
            c.accept(t);
            while (true) {
                t = operator.apply(t);
                c.accept(t);
            }
        };
    }

    public static <T> Seq<T> gen(T seed1, T seed2, BinaryOperator<T> operator) {
        return c -> {
            Object t1 = seed1;
            Object t2 = seed2;
            c.accept(t1);
            c.accept(t2);
            while (true) {
                Object object = t1;
                t1 = t2;
                t2 = operator.apply(object, t1);
                c.accept(t2);
            }
        };
    }

    public static ItrSeq<Matcher> match(final String s, final Pattern pattern) {
        return () -> new Iterator<Matcher>(){
            Matcher matcher;
            {
                this.matcher = pattern.matcher(s);
            }

            @Override
            public boolean hasNext() {
                return this.matcher.find();
            }

            @Override
            public Matcher next() {
                return this.matcher;
            }
        };
    }

    public static <T> Consumer<T> nothing() {
        return Empty.nothing;
    }

    public static <T> Seq<T> of(Iterable<T> iterable) {
        return iterable instanceof ItrSeq ? (ItrSeq)iterable : iterable::iterator;
    }

    public static <K, V> SeqMap<K, V> of(Map<K, V> map) {
        return SeqMap.of(map);
    }

    public static <T> Seq<T> of(Optional<T> optional) {
        return optional::ifPresent;
    }

    @SafeVarargs
    public static <T> Seq<T> of(T ... ts) {
        return Seq.of(Arrays.asList(ts));
    }

    public static Seq<Object> ofJson(Object node) {
        return Seq.ofTree(node, n -> c -> {
            if (n instanceof Iterable) {
                ((Iterable)n).forEach(c);
            } else if (n instanceof Map) {
                ((Map)n).values().forEach(c);
            }
        });
    }

    public static <N> Seq<N> ofTree(int maxDepth, N node, Function<N, Seq<N>> sub) {
        return SeqExpand.of(sub).toSeq(node, maxDepth);
    }

    public static <N> Seq<N> ofTree(N node, Function<N, Seq<N>> sub) {
        return SeqExpand.of(sub).toSeq(node);
    }

    public static <T> ItrSeq<T> repeat(final int n, final T t) {
        return () -> new Iterator<T>(){
            int i;
            {
                this.i = n;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public T next() {
                --this.i;
                return t;
            }
        };
    }

    public static <T> T stop() {
        throw StopException.INSTANCE;
    }

    public static <T> ItrSeq<T> tillNull(final Supplier<T> supplier) {
        return () -> new PickItr<T>(){

            @Override
            public T pick() {
                Object t = supplier.get();
                return t != null ? t : Seq.stop();
            }
        };
    }

    public static <T> Seq<T> unit(T t) {
        return c -> c.accept(t);
    }

    default public boolean all(Predicate<T> predicate) {
        return !this.find(predicate.negate()).isPresent();
    }

    default public boolean any(Predicate<T> predicate) {
        return this.find(predicate).isPresent();
    }

    default public boolean anyNot(Predicate<T> predicate) {
        return this.any(predicate.negate());
    }

    default public Seq<T> append(T t) {
        return c -> {
            this.consume(c);
            c.accept(t);
        };
    }

    default public Seq<T> append(T ... t) {
        return c -> {
            this.consume(c);
            for (Object x : t) {
                c.accept(x);
            }
        };
    }

    default public Seq<T> appendAll(Iterable<T> iterable) {
        return c -> {
            this.consume(c);
            iterable.forEach((Consumer<T>)c);
        };
    }

    default public Seq<T> appendWith(Seq<T> seq) {
        return c -> {
            this.consume(c);
            seq.consume(c);
        };
    }

    default public ItrSeq<T> asIterable() {
        return this.toBatched();
    }

    default public double average(ToDoubleFunction<T> function) {
        return this.average(function, null);
    }

    default public double average(ToDoubleFunction<T> function, ToDoubleFunction<T> weightFunction) {
        return this.reduce(Reducer.average(function, weightFunction));
    }

    default public SizedSeq<T> cache() {
        return this.toBatched();
    }

    default public Seq<ArraySeq<T>> chunked(int size) {
        return this.chunked(size, Reducer.toList(size));
    }

    default public <V> Seq<V> chunked(int size, Reducer<T, V> reducer) {
        if (size <= 0) {
            throw new IllegalArgumentException("non-positive size");
        }
        Supplier supplier = reducer.supplier();
        BiConsumer accumulator = reducer.accumulator();
        Consumer finisher = reducer.finisher();
        return c -> {
            IntPair intPair = new IntPair(0, supplier.get());
            this.reduce(intPair, (arg_0, arg_1) -> Seq.lambda$null$18(size, finisher, c, (Supplier)supplier, accumulator, arg_0, arg_1));
            if (intPair.it != null) {
                c.accept(intPair.it);
            }
        };
    }

    default public <V, E> Seq<E> chunked(int size, Transducer<T, V, E> transducer) {
        return this.chunked(size, transducer.reducer()).map(transducer.transformer());
    }

    default public Seq<T> circle() {
        return c -> {
            while (true) {
                this.consume(c);
            }
        };
    }

    default public <C extends Collection<T>> C collectBy(IntFunction<C> constructor) {
        return (C)this.reduce(constructor.apply(this.sizeOrDefault()), Collection::add);
    }

    default public void consume(Consumer<T> consumer, int n, Consumer<T> substitute) {
        if (n > 0) {
            int[] a = new int[]{n - 1};
            this.consume(t -> {
                if (a[0] < 0) {
                    consumer.accept(t);
                } else {
                    a[0] = a[0] - 1;
                    substitute.accept(t);
                }
            });
        } else {
            this.consume(consumer);
        }
    }

    default public void consumeIndexed(IndexObjConsumer<T> consumer) {
        int[] a = new int[]{0};
        this.consume(t -> {
            int n = a[0];
            a[0] = n + 1;
            consumer.accept(n, t);
        });
    }

    default public void consumeIndexedTillStop(IndexObjConsumer<T> consumer) {
        int[] a = new int[]{0};
        this.consumeTillStop(t -> {
            int n = a[0];
            a[0] = n + 1;
            consumer.accept(n, t);
        });
    }

    default public int count() {
        return this.reduce(Reducer.count());
    }

    default public int count(Predicate<T> predicate) {
        return this.reduce(Reducer.count(predicate));
    }

    default public int countNot(Predicate<T> predicate) {
        return this.reduce(Reducer.countNot(predicate));
    }

    default public Seq<T> distinct() {
        return this.toSet();
    }

    default public <E> Seq<T> distinctBy(Function<T, E> function) {
        return c -> this.reduce(new HashSet(), (E set, T t) -> {
            if (set.add(function.apply(t))) {
                c.accept(t);
            }
        });
    }

    default public Seq<T> drop(int n) {
        return n <= 0 ? this : this.partial(n, Seq.nothing());
    }

    default public Seq<T> dropWhile(Predicate<T> predicate) {
        return c -> this.foldBoolean(false, (b, t) -> {
            if (b || !predicate.test(t)) {
                c.accept(t);
                return true;
            }
            return false;
        });
    }

    default public Seq<T> duplicateAll(int times) {
        return c -> {
            for (int i = 0; i < times; ++i) {
                this.consume(c);
            }
        };
    }

    default public Seq<T> duplicateEach(int times) {
        return c -> this.consume(t -> {
            for (int i = 0; i < times; ++i) {
                c.accept(t);
            }
        });
    }

    default public Seq<T> duplicateIf(int times, Predicate<T> predicate) {
        return c -> this.consume(t -> {
            if (predicate.test(t)) {
                for (int i = 0; i < times; ++i) {
                    c.accept(t);
                }
            } else {
                c.accept(t);
            }
        });
    }

    default public Seq<T> filter(int n, Predicate<T> predicate) {
        return predicate == null ? this : c -> this.consume((Consumer<T>)c, n, t -> {
            if (predicate.test(t)) {
                c.accept(t);
            }
        });
    }

    default public Seq<T> filter(Predicate<T> predicate) {
        return predicate == null ? this : c -> this.consume(t -> {
            if (predicate.test(t)) {
                c.accept(t);
            }
        });
    }

    default public Seq<T> filterIn(Collection<T> collection) {
        return collection == null ? this : this.filter(collection::contains);
    }

    default public Seq<T> filterIn(Map<T, ?> map) {
        return map == null ? this : this.filter(map::containsKey);
    }

    default public Seq<T> filterIndexed(IndexObjPredicate<T> predicate) {
        return predicate == null ? this : c -> this.consumeIndexed((i, t) -> {
            if (predicate.test(i, t)) {
                c.accept(t);
            }
        });
    }

    default public <E> Seq<E> filterInstance(Class<E> cls) {
        return c -> this.consume(t -> {
            if (cls.isInstance(t)) {
                c.accept(cls.cast(t));
            }
        });
    }

    default public Seq<T> filterNot(Predicate<T> predicate) {
        return predicate == null ? this : this.filter(predicate.negate());
    }

    default public Seq<T> filterNotIn(Collection<T> collection) {
        return collection == null ? this : this.filterNot(collection::contains);
    }

    default public Seq<T> filterNotIn(Map<T, ?> map) {
        return map == null ? this : this.filterNot(map::containsKey);
    }

    default public Seq<T> filterNotNull() {
        return this.filter(Objects::nonNull);
    }

    default public Optional<T> find(Predicate<T> predicate) {
        Mutable<Object> m = new Mutable<Object>(null);
        this.consumeTillStop(t -> {
            if (predicate.test(t)) {
                m.set(t);
                Seq.stop();
            }
        });
        return m.toOptional();
    }

    default public Optional<T> findDuplicate() {
        HashSet set = new HashSet(this.sizeOrDefault());
        return this.find(t -> !set.add(t));
    }

    default public Optional<T> findNot(Predicate<T> predicate) {
        return this.find(predicate.negate());
    }

    default public T first() {
        Mutable<Object> m = new Mutable<Object>(null);
        this.consumeTillStop(t -> {
            m.it = t;
            Seq.stop();
        });
        return m.it;
    }

    default public Optional<T> firstMaybe() {
        return this.find(t -> true);
    }

    default public <E> Seq<E> flatIterable(Function<T, Iterable<E>> function) {
        return c -> this.consume(t -> ((Iterable)function.apply(t)).forEach(c));
    }

    default public <E> Seq<E> flatMap(Function<T, Seq<E>> function) {
        return c -> this.consume(t -> ((Seq)function.apply(t)).consume(c));
    }

    default public <E> Seq<E> flatOptional(Function<T, Optional<E>> function) {
        return c -> this.consume(t -> ((Optional)function.apply(t)).ifPresent(c));
    }

    default public <E> E fold(E init, BiFunction<E, T, E> function) {
        Mutable<E> m = new Mutable<E>(init);
        this.consume(t -> {
            m.it = function.apply(m.it, t);
        });
        return (E)m.it;
    }

    default public int foldInt(int init, IntObjToInt<T> function) {
        int[] a = new int[]{init};
        this.consume(t -> {
            a[0] = function.apply(a[0], t);
        });
        return a[0];
    }

    default public double foldDouble(double init, DoubleObjToDouble<T> function) {
        double[] a = new double[]{init};
        this.consume(t -> {
            a[0] = function.apply(a[0], t);
        });
        return a[0];
    }

    default public long foldLong(long init, LongObjToLong<T> function) {
        long[] a = new long[]{init};
        this.consume(t -> {
            a[0] = function.apply(a[0], t);
        });
        return a[0];
    }

    default public boolean foldBoolean(boolean init, BooleanObjToBoolean<T> function) {
        boolean[] a = new boolean[]{init};
        this.consume(t -> {
            a[0] = function.apply(a[0], t);
        });
        return a[0];
    }

    default public <E> E foldAtomic(E init, BiFunction<E, T, E> function) {
        AtomicReference m = new AtomicReference(init);
        this.consume(t -> m.updateAndGet(e -> function.apply(e, t)));
        return m.get();
    }

    default public <K> SeqMap<K, ArraySeq<T>> groupBy(Function<T, K> toKey) {
        return this.groupBy(toKey, Reducer.toList());
    }

    default public <K> SeqMap<K, T> groupBy(Function<T, K> toKey, BinaryOperator<T> operator) {
        return this.groupBy(toKey, Transducer.of(operator));
    }

    default public <K, E> SeqMap<K, ArraySeq<E>> groupBy(Function<T, K> toKey, Function<T, E> toValue) {
        return this.groupBy(toKey, Reducer.mapping(toValue));
    }

    default public <K, V> SeqMap<K, V> groupBy(Function<T, K> toKey, Reducer<T, V> reducer) {
        return this.reduce(Reducer.groupBy(toKey, reducer));
    }

    default public <K, V, E> SeqMap<K, E> groupBy(Function<T, K> toKey, Transducer<T, V, E> transducer) {
        return this.reduce(Reducer.groupBy(toKey, transducer));
    }

    default public String join(String sep) {
        return this.join(sep, Object::toString);
    }

    default public String join(String sep, Function<T, String> function) {
        return this.reduce(new StringJoiner(sep), (E j, T t) -> j.add((CharSequence)function.apply(t))).toString();
    }

    default public T last() {
        return this.reduce(new Mutable<Object>(null), (BiConsumer<Mutable, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, set(T ), (Lcom/github/wolray/seq/Mutable;Ljava/lang/Object;)V)()).it;
    }

    default public Optional<T> last(Predicate<T> predicate) {
        return this.filter(predicate).lastMaybe();
    }

    default public Optional<T> lastMaybe() {
        Mutable<Object> m = new Mutable<Object>(null);
        this.consume(m::set);
        return m.toOptional();
    }

    default public Optional<T> lastNot(Predicate<T> predicate) {
        return this.last(predicate.negate());
    }

    default public Lazy<T> lazyLast() {
        return new Mutable<T>(null){

            @Override
            protected void eval() {
                Seq.this.consume(t -> {
                    this.it = t;
                });
            }
        };
    }

    default public Lazy<T> lazyReduce(BinaryOperator<T> binaryOperator) {
        return Lazy.of(() -> this.reduce(binaryOperator));
    }

    default public <E> Lazy<E> lazyReduce(Reducer<T, E> reducer) {
        return Lazy.of(() -> this.reduce(reducer));
    }

    default public <E, V> Lazy<E> lazyReduce(Transducer<T, V, E> transducer) {
        return Lazy.of(() -> this.reduce(transducer));
    }

    default public <E> Seq<E> map(Function<T, E> function) {
        return c -> this.consume(t -> c.accept(function.apply(t)));
    }

    default public <E> Seq<E> map(Function<T, E> function, int n, Function<T, E> substitute) {
        return n <= 0 ? this.map(function) : c -> {
            int[] a = new int[]{n - 1};
            this.consume(t -> {
                if (a[0] < 0) {
                    c.accept(function.apply(t));
                } else {
                    a[0] = a[0] - 1;
                    c.accept(substitute.apply(t));
                }
            });
        };
    }

    default public <E> Seq<E> mapIndexed(IndexObjFunction<T, E> function) {
        return c -> this.consumeIndexed((i, t) -> c.accept(function.apply(i, t)));
    }

    default public <E> Seq<E> mapMaybe(Function<T, E> function) {
        return c -> this.consume(t -> {
            if (t != null) {
                c.accept(function.apply(t));
            }
        });
    }

    default public <E> Seq<E> mapNotNull(Function<T, E> function) {
        return c -> this.consume(t -> {
            Object e = function.apply(t);
            if (e != null) {
                c.accept(e);
            }
        });
    }

    default public Seq2<T, T> mapPair(boolean overlapping) {
        return c -> this.reduce(new BoolPair<Object>(false, null), (E p, T t) -> {
            if (p.flag) {
                c.accept(p.it, t);
            }
            p.flag = overlapping || !p.flag;
            p.it = t;
        });
    }

    default public <V> Seq<V> mapSub(Predicate<T> first, Predicate<T> last, Reducer<T, V> reducer) {
        Supplier supplier = reducer.supplier();
        BiConsumer accumulator = reducer.accumulator();
        return c -> this.fold(null, (arg_0, arg_1) -> Seq.lambda$null$74(first, (Supplier)supplier, accumulator, last, c, arg_0, arg_1));
    }

    default public Seq<ArraySeq<T>> mapSub(Predicate<T> takeWhile) {
        return this.mapSub((T)takeWhile, (T)Reducer.toList());
    }

    default public <V> Seq<V> mapSub(Predicate<T> takeWhile, Reducer<T, V> reducer) {
        Supplier supplier = reducer.supplier();
        BiConsumer accumulator = reducer.accumulator();
        return c -> {
            Object last = this.fold(null, (arg_0, arg_1) -> Seq.lambda$null$76(takeWhile, (Supplier)supplier, accumulator, c, arg_0, arg_1));
            if (last != null) {
                c.accept(last);
            }
        };
    }

    default public Seq<ArraySeq<T>> mapSub(T first, T last) {
        return this.mapSub(first, last, Reducer.toList());
    }

    default public <V> Seq<V> mapSub(T first, T last, Reducer<T, V> reducer) {
        return this.mapSub((T)((Predicate<Object>)first::equals), (T)((Predicate<Object>)last::equals), reducer);
    }

    default public IntSeq mapToInt(ToIntFunction<T> function) {
        return c -> this.consume(t -> c.accept(function.applyAsInt(t)));
    }

    default public T max(Comparator<T> comparator) {
        return this.reduce(Reducer.max(comparator));
    }

    default public <V extends Comparable<V>> Pair<T, V> maxBy(Function<T, V> function) {
        return this.reduce(Reducer.maxBy(function));
    }

    default public T min(Comparator<T> comparator) {
        return this.reduce(Reducer.min(comparator));
    }

    default public <V extends Comparable<V>> Pair<T, V> minBy(Function<T, V> function) {
        return this.reduce(Reducer.minBy(function));
    }

    default public boolean none(Predicate<T> predicate) {
        return !this.find(predicate).isPresent();
    }

    default public Seq<T> onEach(Consumer<T> consumer) {
        return c -> this.consume(consumer.andThen((Consumer<T>)c));
    }

    default public Seq<T> onEach(int n, Consumer<T> consumer) {
        return c -> this.consume((Consumer<T>)c, n, consumer.andThen((Consumer<T>)c));
    }

    default public Seq<T> onEachIndexed(IndexObjConsumer<T> consumer) {
        return c -> this.consumeIndexed((i, t) -> {
            consumer.accept(i, t);
            c.accept(t);
        });
    }

    default public <A, B> Seq2<A, B> pair(Function<T, A> f1, Function<T, B> f2) {
        return c -> this.consume(t -> c.accept(f1.apply(t), f2.apply(t)));
    }

    default public <E> Seq2<E, T> pairBy(Function<T, E> function) {
        return c -> this.consume(t -> c.accept(function.apply(t), t));
    }

    default public <E> Seq2<E, T> pairByNotNull(Function<T, E> function) {
        return c -> this.consume(t -> {
            Object e = function.apply(t);
            if (e != null) {
                c.accept(e, t);
            }
        });
    }

    default public <E> Seq2<T, E> pairWith(Function<T, E> function) {
        return c -> this.consume(t -> c.accept(t, function.apply(t)));
    }

    default public <E> Seq2<T, E> pairWithNotNull(Function<T, E> function) {
        return c -> this.consume(t -> {
            Object e = function.apply(t);
            if (e != null) {
                c.accept(t, e);
            }
        });
    }

    default public Seq<T> partial(int n, Consumer<T> substitute) {
        return c -> this.consume((Consumer<T>)c, n, substitute);
    }

    default public void printAll(String sep) {
        if ("\n".equals(sep)) {
            this.println();
        } else {
            System.out.println(this.join(sep));
        }
    }

    default public void println() {
        this.consume(System.out::println);
    }

    default public T reduce(BinaryOperator<T> binaryOperator) {
        return this.reduce(Transducer.of(binaryOperator));
    }

    default public <E> E reduce(E des, BiConsumer<E, T> accumulator) {
        this.consume(t -> accumulator.accept(des, t));
        return des;
    }

    default public <E> E reduce(Reducer<T, E> reducer) {
        Object des = reducer.supplier().get();
        BiConsumer accumulator = reducer.accumulator();
        this.consume(t -> accumulator.accept(des, t));
        Consumer<E> finisher = reducer.finisher();
        if (finisher != null) {
            finisher.accept(des);
        }
        return des;
    }

    default public <E, V> E reduce(Reducer<T, V> reducer, Function<V, E> transformer) {
        return transformer.apply(this.reduce(reducer));
    }

    default public <E, V> E reduce(Transducer<T, V, E> transducer) {
        return transducer.transformer().apply(this.reduce(transducer.reducer()));
    }

    default public Seq<T> replace(int n, UnaryOperator<T> operator) {
        return c -> this.consume((Consumer<T>)c, n, t -> c.accept(operator.apply(t)));
    }

    default public ArraySeq<T> reverse() {
        return this.reduce(Reducer.reverse());
    }

    default public <E> Seq<E> runningFold(E init, BiFunction<E, T, E> function) {
        return c -> this.fold(init, (e, t) -> {
            e = function.apply(e, t);
            c.accept(e);
            return e;
        });
    }

    default public int sizeOrDefault() {
        return 10;
    }

    default public <E extends Comparable<E>> ArraySeq<T> sortBy(Function<T, E> function) {
        return this.sortWith(Comparator.comparing(function));
    }

    default public <E extends Comparable<E>> ArraySeq<T> sortByDesc(Function<T, E> function) {
        return this.sortWith(Comparator.comparing(function).reversed());
    }

    default public <E extends Comparable<E>> Seq<T> sortCached(Function<T, E> function) {
        return this.map(t -> new Pair(t, function.apply(t))).sortBy(p -> (Comparable)p.second).map((T p) -> p.first);
    }

    default public <E extends Comparable<E>> Seq<T> sortCachedDesc(Function<T, E> function) {
        return this.map(t -> new Pair(t, function.apply(t))).sortByDesc(p -> (Comparable)p.second).map((T p) -> p.first);
    }

    default public ArraySeq<T> sorted() {
        return this.sortWith(null);
    }

    default public ArraySeq<T> sortedDesc() {
        return this.sortWith(Collections.reverseOrder());
    }

    default public ArraySeq<T> sortWith(Comparator<T> comparator) {
        ArraySeq<T> list = this.toList();
        list.sort(comparator);
        return list;
    }

    default public ArraySeq<T> sortWithDesc(Comparator<T> comparator) {
        return this.sortWith(comparator.reversed());
    }

    default public double sum(ToDoubleFunction<T> function) {
        return this.reduce(Reducer.sum(function));
    }

    default public int sumInt(ToIntFunction<T> function) {
        return this.reduce(Reducer.sumInt(function));
    }

    default public long sumLong(ToLongFunction<T> function) {
        return this.reduce(Reducer.sumLong(function));
    }

    default public Seq<T> take(int n) {
        return n <= 0 ? Seq.empty() : c -> {
            int[] i = new int[]{n};
            this.consumeTillStop(t -> {
                c.accept(t);
                i[0] = i[0] - 1;
                if (i[0] == 0) {
                    Seq.stop();
                }
            });
        };
    }

    default public Seq<T> takeWhile(BiPredicate<T, T> testPrevCurr) {
        return this.takeWhile(t -> t, testPrevCurr);
    }

    default public <E> Seq<T> takeWhile(Function<T, E> function, BiPredicate<E, E> testPrevCurr) {
        return c -> {
            Mutable<Object> m = new Mutable<Object>(null);
            this.consumeTillStop(t -> {
                Object curr = function.apply(t);
                if (m.it == null || testPrevCurr.test(m.it, curr)) {
                    c.accept(t);
                    m.it = curr;
                } else {
                    Seq.stop();
                }
            });
        };
    }

    default public Seq<T> takeWhile(Predicate<T> predicate) {
        return c -> this.consumeTillStop(t -> {
            if (predicate.test(t)) {
                c.accept(t);
            } else {
                Seq.stop();
            }
        });
    }

    default public Seq<T> takeWhileEquals() {
        return this.takeWhile(t -> t, Objects::equals);
    }

    default public <E> Seq<T> takeWhileEquals(Function<T, E> function) {
        return this.takeWhile(function, Objects::equals);
    }

    default public Seq<T> timeLimit(long millis) {
        return millis <= 0L ? this : c -> {
            long end = System.currentTimeMillis() + millis;
            this.consumeTillStop(t -> {
                if (System.currentTimeMillis() > end) {
                    Seq.stop();
                }
                c.accept(t);
            });
        };
    }

    default public T[] toObjArray(IntFunction<T[]> initializer) {
        SizedSeq<Object> ts = this.cache();
        Object[] a = initializer.apply(ts.size());
        ts.consumeIndexed((i, t) -> {
            a[i] = t;
        });
        return a;
    }

    default public int[] toIntArray(ToIntFunction<T> function) {
        SizedSeq<Object> ts = this.cache();
        int[] a = new int[ts.size()];
        ts.consumeIndexed((i, t) -> {
            a[i] = function.applyAsInt(t);
        });
        return a;
    }

    default public double[] toDoubleArray(ToDoubleFunction<T> function) {
        SizedSeq<Object> ts = this.cache();
        double[] a = new double[ts.size()];
        ts.consumeIndexed((i, t) -> {
            a[i] = function.applyAsDouble(t);
        });
        return a;
    }

    default public long[] toLongArray(ToLongFunction<T> function) {
        SizedSeq<Object> ts = this.cache();
        long[] a = new long[ts.size()];
        ts.consumeIndexed((i, t) -> {
            a[i] = function.applyAsLong(t);
        });
        return a;
    }

    default public boolean[] toBooleanArray(Predicate<T> function) {
        SizedSeq<Object> ts = this.cache();
        boolean[] a = new boolean[ts.size()];
        ts.consumeIndexed((i, t) -> {
            a[i] = function.test(t);
        });
        return a;
    }

    default public BatchedSeq<T> toBatched() {
        return this.reduce(new BatchedSeq(), BatchedSeq::add);
    }

    default public ConcurrentSeq<T> toConcurrent() {
        return this.reduce(new ConcurrentSeq(), ConcurrentLinkedQueue::add);
    }

    default public <E> Lazy<E> toLazy(Reducer<T, E> reducer) {
        return Lazy.of(() -> this.reduce(reducer));
    }

    default public <V, E> Lazy<E> toLazy(Transducer<T, V, E> transducer) {
        return Lazy.of(() -> this.reduce(transducer));
    }

    default public LinkedSeq<T> toLinked() {
        return this.reduce(new LinkedSeq(), LinkedList::add);
    }

    default public ArraySeq<T> toList() {
        return this.reduce(new ArraySeq(this.sizeOrDefault()), ArrayList::add);
    }

    default public <K, V> SeqMap<K, V> toMap(Function<T, K> toKey, Function<T, V> toValue) {
        return this.reduce(Reducer.toMap(() -> new LinkedHashMap(this.sizeOrDefault()), toKey, toValue));
    }

    default public <K> SeqMap<K, T> toMapBy(Function<T, K> toKey) {
        return this.toMap(toKey, v -> v);
    }

    default public <V> SeqMap<T, V> toMapWith(Function<T, V> toValue) {
        return this.toMap(k -> k, toValue);
    }

    default public SeqSet<T> toSet() {
        return this.reduce(Reducer.toSet(this.sizeOrDefault()));
    }

    default public <A, B, D> Seq3<A, B, D> triple(BiConsumer<Consumer3<A, B, D>, T> consumer) {
        return c -> this.consume(t -> consumer.accept((Consumer3)c, (Object)t));
    }

    default public <A, B, D> Seq3<A, B, D> triple(Function<T, A> f1, Function<T, B> f2, Function<T, D> f3) {
        return c -> this.consume(t -> c.accept(f1.apply(t), f2.apply(t), f3.apply(t)));
    }

    default public Seq<ArraySeq<T>> windowed(int size, int step, boolean allowPartial) {
        return this.windowed(size, step, allowPartial, Reducer.toList());
    }

    default public <V> Seq<V> windowed(int size, int step, boolean allowPartial, Reducer<T, V> reducer) {
        if (size <= 0 || step <= 0) {
            throw new IllegalArgumentException("non-positive size or step");
        }
        return c -> {
            Supplier supplier = reducer.supplier();
            BiConsumer accumulator = reducer.accumulator();
            Consumer finisher = reducer.finisher();
            LinkedList queue = new LinkedList();
            this.foldInt(0, (left, t) -> {
                if (left == 0) {
                    left = step;
                    queue.offer(new IntPair(0, supplier.get()));
                }
                queue.forEach(sub -> {
                    accumulator.accept(sub.it, t);
                    ++sub.intVal;
                });
                IntPair first = (IntPair)queue.peek();
                if (first != null && first.intVal == size) {
                    queue.poll();
                    if (finisher != null) {
                        finisher.accept(first.it);
                    }
                    c.accept(first.it);
                }
                return left - 1;
            });
            if (allowPartial) {
                queue.forEach(p -> c.accept(p.it));
            }
            queue.clear();
        };
    }

    default public <V, E> Seq<E> windowed(int size, int step, boolean allowPartial, Transducer<T, V, E> transducer) {
        return this.windowed(size, step, allowPartial, transducer.reducer()).map(transducer.transformer());
    }

    default public Seq<ArraySeq<T>> windowedByTime(long timeMillis) {
        return this.windowedByTime(timeMillis, Reducer.toList());
    }

    default public Seq<ArraySeq<T>> windowedByTime(long timeMillis, long stepMillis) {
        return this.windowedByTime(timeMillis, stepMillis, Reducer.toList());
    }

    default public <V> Seq<V> windowedByTime(long timeMillis, long stepMillis, Reducer<T, V> reducer) {
        if (timeMillis <= 0L || stepMillis <= 0L) {
            throw new IllegalArgumentException("non-positive time or step");
        }
        return c -> {
            Supplier supplier = reducer.supplier();
            BiConsumer accumulator = reducer.accumulator();
            Consumer finisher = reducer.finisher();
            LinkedList queue = new LinkedList();
            long[] last = new long[]{System.currentTimeMillis(), 0L};
            this.reduce(last, (E a, T t) -> {
                if (a[1] <= 0L) {
                    a[1] = stepMillis;
                    queue.offer(new LongPair(System.currentTimeMillis(), supplier.get()));
                }
                queue.forEach(sub -> accumulator.accept(sub.it, t));
                LongPair first = (LongPair)queue.peek();
                if (first != null && System.currentTimeMillis() - first.longVal > timeMillis) {
                    queue.poll();
                    if (finisher != null) {
                        finisher.accept(first.it);
                    }
                    c.accept(first.it);
                }
                long now = System.currentTimeMillis();
                a[1] = a[1] - (now - a[0]);
                a[0] = now;
            });
            queue.clear();
        };
    }

    default public <V, E> Seq<E> windowedByTime(long timeMillis, long stepMillis, Transducer<T, V, E> transducer) {
        return this.windowedByTime(timeMillis, stepMillis, transducer.reducer()).map(transducer.transformer());
    }

    default public <V> Seq<V> windowedByTime(long timeMillis, Reducer<T, V> reducer) {
        if (timeMillis <= 0L) {
            throw new IllegalArgumentException("non-positive time");
        }
        return c -> {
            Supplier supplier = reducer.supplier();
            BiConsumer accumulator = reducer.accumulator();
            Consumer finisher = reducer.finisher();
            this.reduce(new LongPair(System.currentTimeMillis(), supplier.get()), (E p, T t) -> {
                long now = System.currentTimeMillis();
                if (now - p.longVal > timeMillis) {
                    p.longVal = now;
                    if (finisher != null) {
                        finisher.accept(p.it);
                    }
                    c.accept(p.it);
                    p.it = supplier.get();
                }
                accumulator.accept(p.it, t);
            });
        };
    }

    default public <V, E> Seq<E> windowedByTime(long timeMillis, Transducer<T, V, E> transducer) {
        return this.windowedByTime(timeMillis, transducer.reducer()).map(transducer.transformer());
    }

    default public Seq<IntPair<T>> withInt(ToIntFunction<T> function) {
        return this.map(t -> new IntPair<Object>(function.applyAsInt(t), t));
    }

    default public Seq<DoublePair<T>> withDouble(ToDoubleFunction<T> function) {
        return this.map(t -> new DoublePair<Object>(function.applyAsDouble(t), t));
    }

    default public Seq<LongPair<T>> withLong(ToLongFunction<T> function) {
        return this.map(t -> new LongPair<Object>(function.applyAsLong(t), t));
    }

    default public Seq<BoolPair<T>> withBool(Predicate<T> function) {
        return this.map(t -> new BoolPair<Object>(function.test(t), t));
    }

    default public Seq<IntPair<T>> withIndex() {
        return c -> this.consumeIndexed((i, t) -> c.accept(new IntPair<Object>(i, t)));
    }

    default public <B, C> Seq3<T, B, C> zip(Iterable<B> bs, Iterable<C> cs) {
        return c -> this.zip(bs, cs, (Consumer3)c);
    }

    default public <B, C> void zip(Iterable<B> bs, Iterable<C> cs, Consumer3<T, B, C> consumer) {
        Iterator bi = bs.iterator();
        Iterator ci = cs.iterator();
        this.consumeTillStop(t -> consumer.accept(t, ItrUtil.pop(bi), ItrUtil.pop(ci)));
    }

    default public <E> Seq2<T, E> zip(Iterable<E> iterable) {
        return c -> this.zip(iterable, (BiConsumer)c);
    }

    default public <E> void zip(Iterable<E> iterable, BiConsumer<T, E> consumer) {
        Iterator iterator = iterable.iterator();
        this.consumeTillStop(t -> consumer.accept(t, ItrUtil.pop(iterator)));
    }

    private static /* synthetic */ Object lambda$null$76(Predicate takeWhile, Supplier supplier, BiConsumer accumulator, Consumer c, Object v, Object t) {
        if (takeWhile.test(t)) {
            if (v == null) {
                v = supplier.get();
            }
            accumulator.accept(v, t);
            return v;
        }
        if (v != null) {
            c.accept(v);
        }
        return null;
    }

    private static /* synthetic */ Object lambda$null$74(Predicate first, Supplier supplier, BiConsumer accumulator, Predicate last, Consumer c, Object v, Object t) {
        if (v == null && first.test(t)) {
            v = supplier.get();
            accumulator.accept(v, t);
        } else if (v != null) {
            accumulator.accept(v, t);
            if (last.test(t)) {
                c.accept(v);
                return null;
            }
        }
        return v;
    }

    private static /* synthetic */ void lambda$null$18(int size, Consumer finisher, Consumer c, Supplier supplier, BiConsumer accumulator, IntPair p, Object t) {
        if (p.intVal == size) {
            if (finisher != null) {
                finisher.accept(p.it);
            }
            c.accept(p.it);
            p.it = supplier.get();
            p.intVal = 0;
        }
        accumulator.accept(p.it, t);
        ++p.intVal;
    }

    public static class Empty {
        static final Seq<Object> emptySeq = c -> {};
        static final Consumer<Object> nothing = t -> {};
    }

    public static interface IndexObjPredicate<T> {
        public boolean test(int var1, T var2);
    }

    public static interface IndexObjFunction<T, E> {
        public E apply(int var1, T var2);
    }

    public static interface IndexObjConsumer<T> {
        public void accept(int var1, T var2);
    }

    public static interface BooleanObjToBoolean<T> {
        public boolean apply(boolean var1, T var2);
    }

    public static interface LongObjToLong<T> {
        public long apply(long var1, T var3);
    }

    public static interface DoubleObjToDouble<T> {
        public double apply(double var1, T var3);
    }

    public static interface IntObjToInt<T> {
        public int apply(int var1, T var2);
    }
}

