/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Consumer3;
import com.github.wolray.seq.Pair;
import com.github.wolray.seq.Seq;
import com.github.wolray.seq.Seq0;
import com.github.wolray.seq.SeqMap;
import com.github.wolray.seq.SizedSeq;
import com.github.wolray.seq.Splitter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Seq2<K, V>
extends Seq0<BiConsumer<K, V>> {
    public static <K, V> Seq2<K, V> empty() {
        return Empty.emptySeq;
    }

    public static <K, V> BiConsumer<K, V> nothing() {
        return Empty.nothing;
    }

    public static Seq2<String, String> parseMap(char[] chars, char entrySep, char kvSep) {
        return c -> {
            int len = chars.length;
            int last = 0;
            String prev = null;
            for (int i = 0; i < len; ++i) {
                if (chars[i] == entrySep) {
                    if (prev != null) {
                        c.accept(prev, Splitter.substring(chars, last, i));
                        prev = null;
                    }
                    last = i + 1;
                    continue;
                }
                if (prev != null || chars[i] != kvSep) continue;
                prev = Splitter.substring(chars, last, i);
                last = i + 1;
            }
            if (prev != null) {
                c.accept(prev, Splitter.substring(chars, last, len));
            }
        };
    }

    public static Seq2<String, String> parseMap(String s, char entrySep, char kvSep) {
        return Seq2.parseMap(s.toCharArray(), entrySep, kvSep);
    }

    public static <K, V> Seq2<K, V> unit(K k, V v) {
        return c -> c.accept(k, v);
    }

    default public Seq2<K, V> cache() {
        SizedSeq pairSeq = this.paired().cache();
        return c -> pairSeq.consume(p -> c.accept(p.first, p.second));
    }

    default public Seq2<K, V> filter(BiPredicate<K, V> predicate) {
        return c -> this.consume((k, v) -> {
            if (predicate.test(k, v)) {
                c.accept(k, v);
            }
        });
    }

    default public Seq2<K, V> filterByKey(Predicate<K> predicate) {
        return c -> this.consume((k, v) -> {
            if (predicate.test(k)) {
                c.accept(k, v);
            }
        });
    }

    default public Seq2<K, V> filterByValue(Predicate<V> predicate) {
        return c -> this.consume((k, v) -> {
            if (predicate.test(v)) {
                c.accept(k, v);
            }
        });
    }

    default public Seq<K> justKeys() {
        return c -> this.consume((k, v) -> c.accept(k));
    }

    default public Seq<V> justValues() {
        return c -> this.consume((k, v) -> c.accept(v));
    }

    default public <T> Seq<T> map(BiFunction<K, V, T> function) {
        return c -> this.consume((k, v) -> c.accept(function.apply(k, v)));
    }

    default public <T> Seq2<T, V> mapKey(BiFunction<K, V, T> function) {
        return c -> this.consume((k, v) -> c.accept(function.apply(k, v), v));
    }

    default public <T> Seq2<T, V> mapKey(Function<K, T> function) {
        return c -> this.consume((k, v) -> c.accept(function.apply(k), v));
    }

    default public <T> Seq2<K, T> mapValue(BiFunction<K, V, T> function) {
        return c -> this.consume((k, v) -> c.accept(k, function.apply(k, v)));
    }

    default public <T> Seq2<K, T> mapValue(Function<V, T> function) {
        return c -> this.consume((k, v) -> c.accept(k, function.apply(v)));
    }

    default public Pair<K, V> maxByKey(Comparator<K> comparator) {
        return this.reduce(new Pair<Object, Object>(null, null), (p, k, v) -> {
            if (p.first == null || comparator.compare(p.first, k) < 0) {
                p.set(k, v);
            }
        });
    }

    default public Pair<K, V> maxByValue(Comparator<V> comparator) {
        return this.reduce(new Pair<Object, Object>(null, null), (p, k, v) -> {
            if (p.second == null || comparator.compare(p.second, v) < 0) {
                p.set(k, v);
            }
        });
    }

    default public Pair<K, V> minByKey(Comparator<K> comparator) {
        return this.reduce(new Pair<Object, Object>(null, null), (p, k, v) -> {
            if (p.first == null || comparator.compare(p.first, k) > 0) {
                p.set(k, v);
            }
        });
    }

    default public Pair<K, V> minByValue(Comparator<V> comparator) {
        return this.reduce(new Pair<Object, Object>(null, null), (p, k, v) -> {
            if (p.second == null || comparator.compare(p.second, v) > 0) {
                p.set(k, v);
            }
        });
    }

    default public Seq2<K, V> onEach(BiConsumer<K, V> consumer) {
        return c -> this.consumeTillStop(consumer.andThen((BiConsumer<K, V>)c));
    }

    default public Seq<Pair<K, V>> paired() {
        return this.map(Pair::new);
    }

    default public <E> E reduce(E des, Consumer3<E, K, V> accumulator) {
        this.consume((k, v) -> accumulator.accept(des, k, v));
        return des;
    }

    default public Seq2<V, K> swap() {
        return c -> this.consume((k, v) -> c.accept(v, k));
    }

    default public SeqMap<K, V> toMap() {
        return this.toMap(new LinkedHashMap());
    }

    default public <A, B> SeqMap<A, B> toMap(BiFunction<K, V, A> toKey, BiFunction<K, V, B> toValue) {
        return this.toMap(new LinkedHashMap(), toKey, toValue);
    }

    default public <A, B> SeqMap<A, B> toMap(Map<A, B> des, BiFunction<K, V, A> toKey, BiFunction<K, V, B> toValue) {
        return SeqMap.of(this.reduce(des, (res, k, v) -> res.put(toKey.apply(k, v), toValue.apply(k, v))));
    }

    default public SeqMap<K, V> toMap(Map<K, V> des) {
        return SeqMap.of(this.reduce(des, Map::put));
    }

    public static class Empty {
        static final Seq2<Object, Object> emptySeq = c -> {};
        static final BiConsumer<Object, Object> nothing = (k, v) -> {};
    }
}

