/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.Consumer3;
import com.github.wolray.seq.Function3;
import com.github.wolray.seq.Seq;
import com.github.wolray.seq.Seq0;
import com.github.wolray.seq.Triple;
import java.util.function.Function;

public interface Seq3<A, B, C>
extends Seq0<Consumer3<A, B, C>> {
    public static <A, B, C> Seq3<A, B, C> empty() {
        return Empty.emptySeq;
    }

    public static <A, B, C> Consumer3<A, B, C> nothing() {
        return Empty.nothing;
    }

    default public Seq3<A, B, C> filter(TriPredicate<A, B, C> predicate) {
        return cs -> this.consume((a, b, c) -> {
            if (predicate.test(a, b, c)) {
                cs.accept(a, b, c);
            }
        });
    }

    default public Triple<A, B, C> first() {
        Triple<Object, Object, Object> t = new Triple<Object, Object, Object>(null, null, null);
        this.consumeTillStop((a, b, c) -> {
            t.first = a;
            t.second = b;
            t.third = c;
            Seq.stop();
        });
        return t;
    }

    default public Seq<A> keepFirst() {
        return cs -> this.consume((a, b, c) -> cs.accept(a));
    }

    default public Seq<B> keepSecond() {
        return cs -> this.consume((a, b, c) -> cs.accept(b));
    }

    default public Seq<C> keepThird() {
        return cs -> this.consume((a, b, c) -> cs.accept(c));
    }

    default public <T> Seq<T> map(Function3<A, B, C, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(function.apply(a, b, c)));
    }

    default public <T> Seq3<T, B, C> mapFirst(Function3<A, B, C, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(function.apply(a, b, c), b, c));
    }

    default public <T> Seq3<T, B, C> mapFirst(Function<A, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(function.apply(a), b, c));
    }

    default public <T> Seq3<A, T, C> mapSecond(Function3<A, B, C, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(a, function.apply(a, b, c), c));
    }

    default public <T> Seq3<A, T, C> mapSecond(Function<B, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(a, function.apply(b), c));
    }

    default public <T> Seq3<A, B, T> mapThird(Function3<A, B, C, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(a, b, function.apply(a, b, c)));
    }

    default public <T> Seq3<A, B, T> mapThird(Function<C, T> function) {
        return cs -> this.consume((a, b, c) -> cs.accept(a, b, function.apply(c)));
    }

    default public Seq<Triple<A, B, C>> tripled() {
        return this.map(Triple::new);
    }

    public static class Empty {
        static final Seq3<Object, Object, Object> emptySeq = cs -> {};
        static final Consumer3<Object, Object, Object> nothing = (a, b, c) -> {};
    }

    public static interface TriPredicate<A, B, D> {
        public boolean test(A var1, B var2, D var3);
    }
}

