/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ArraySeq;
import com.github.wolray.seq.Seq;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface SeqExpand<T>
extends Function<T, Seq<T>> {
    public static <T> SeqExpand<T> of(Function<T, Seq<T>> function) {
        return function instanceof SeqExpand ? (SeqExpand)function : function::apply;
    }

    default public SeqExpand<T> filter(Predicate<T> predicate) {
        return t -> ((Seq)this.apply(t)).filter(predicate);
    }

    default public SeqExpand<T> filterNot(Predicate<T> predicate) {
        return t -> ((Seq)this.apply(t)).filter(predicate.negate());
    }

    default public void scan(BiConsumer<T, ArraySeq<T>> c, T node) {
        ArraySeq<Object> sub = ((Seq)this.apply(node)).filterNotNull().toList();
        c.accept(node, sub);
        sub.consume(n -> this.scan(c, n));
    }

    default public void scan(Consumer<T> c, T node) {
        c.accept(node);
        ((Seq)this.apply(node)).consume(n -> {
            if (n != null) {
                this.scan(c, n);
            }
        });
    }

    default public void scan(Consumer<T> c, T node, int maxDepth, int depth) {
        c.accept(node);
        if (depth < maxDepth) {
            ((Seq)this.apply(node)).consume(n -> {
                if (n != null) {
                    this.scan(c, n, maxDepth, depth + 1);
                }
            });
        }
    }

    default public SeqExpand<T> terminate(Predicate<T> predicate) {
        return t -> predicate.test(t) ? Seq.empty() : (Seq)this.apply(t);
    }

    default public Map<T, ArraySeq<T>> toDAG(Seq<T> nodes) {
        return nodes.reduce(new HashMap(), (map, node) -> this.scan(map::put, node));
    }

    default public Map<T, ArraySeq<T>> toDAG(T node) {
        HashMap map = new HashMap();
        this.scan(map::put, node);
        return map;
    }

    default public Seq<T> toSeq(T node) {
        return c -> this.scan((Consumer<T>)c, node);
    }

    default public Seq<T> toSeq(T node, int maxDepth) {
        return c -> this.scan((Consumer<T>)c, node, maxDepth, 0);
    }
}

