/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ArraySeq;
import com.github.wolray.seq.LinkedSeqMap;
import com.github.wolray.seq.Seq2;
import com.github.wolray.seq.SeqCollection;
import com.github.wolray.seq.SeqSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface SeqMap<K, V>
extends Seq2<K, V>,
Map<K, V> {
    public SeqSet<K> seqKeySet();

    public SeqCollection<V> seqValues();

    public SeqSet<Map.Entry<K, V>> seqEntrySet();

    public <A, B> SeqMap<A, B> newForMapping();

    @Override
    default public void consume(BiConsumer<K, V> consumer) {
        this.forEach(consumer);
    }

    default public <E> SeqMap<E, V> mapByKey(BiFunction<K, V, E> function) {
        return this.toMap(this.newForMapping(), function, (k, v) -> v);
    }

    default public <E> SeqMap<E, V> mapByKey(Function<K, E> function) {
        return this.toMap(this.newForMapping(), (k, v) -> function.apply(k), (k, v) -> v);
    }

    default public <E> SeqMap<K, E> mapByValue(BiFunction<K, V, E> function) {
        return this.toMap(this.newForMapping(), (k, v) -> k, function);
    }

    default public <E> SeqMap<K, E> mapByValue(Function<V, E> function) {
        return this.toMap(this.newForMapping(), (k, v) -> k, (k, v) -> function.apply(v));
    }

    @Override
    default public SeqMap<K, V> toMap() {
        return this;
    }

    public static <K, V> SeqMap<K, V> hash() {
        return new LinkedSeqMap();
    }

    public static <K, V> SeqMap<K, V> hash(int initialCapacity) {
        return new LinkedSeqMap(initialCapacity);
    }

    public static <K, V> SeqMap<K, V> of(Map<K, V> map) {
        return map instanceof SeqMap ? (SeqMap<K, V>)map : new Proxy<K, V>(map);
    }

    public static <K, V> SeqMap<K, V> tree(Comparator<K> comparator) {
        return new Proxy(new TreeMap(comparator));
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public <E> SeqMap<K, E> replaceValue(BiFunction<K, V, E> function) {
        SeqMap map = this;
        map.entrySet().forEach((? super T e) -> e.setValue(function.apply(e.getKey(), e.getValue())));
        return map;
    }

    default public <E> SeqMap<K, E> replaceValue(Function<V, E> function) {
        SeqMap map = this;
        map.entrySet().forEach((? super T e) -> e.setValue(function.apply(e.getValue())));
        return map;
    }

    default public <E extends Comparable<E>> ArraySeq<Map.Entry<K, V>> sort(BiFunction<K, V, E> function) {
        return this.seqEntrySet().sortBy(e -> (Comparable)function.apply(e.getKey(), e.getValue()));
    }

    default public ArraySeq<Map.Entry<K, V>> sortByKey(Comparator<K> comparator) {
        return this.seqEntrySet().sortWith(Map.Entry.comparingByKey(comparator));
    }

    default public ArraySeq<Map.Entry<K, V>> sortByValue(Comparator<V> comparator) {
        return this.seqEntrySet().sortWith(Map.Entry.comparingByValue(comparator));
    }

    default public <E extends Comparable<E>> ArraySeq<Map.Entry<K, V>> sortDesc(BiFunction<K, V, E> function) {
        return this.seqEntrySet().sortByDesc(e -> (Comparable)function.apply(e.getKey(), e.getValue()));
    }

    default public ArraySeq<Map.Entry<K, V>> sortDescByKey(Comparator<K> comparator) {
        return this.seqEntrySet().sortWithDesc(Map.Entry.comparingByKey(comparator));
    }

    default public ArraySeq<Map.Entry<K, V>> sortDescByValue(Comparator<V> comparator) {
        return this.seqEntrySet().sortWithDesc(Map.Entry.comparingByValue(comparator));
    }

    public static class Proxy<K, V>
    implements SeqMap<K, V> {
        public final Map<K, V> backer;

        Proxy(Map<K, V> backer) {
            this.backer = backer;
        }

        @Override
        public void consume(BiConsumer<K, V> consumer) {
            this.backer.forEach(consumer);
        }

        @Override
        public Set<K> keySet() {
            return this.backer.keySet();
        }

        @Override
        public SeqSet<K> seqKeySet() {
            return SeqSet.of(this.backer.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.backer.values();
        }

        @Override
        public SeqCollection<V> seqValues() {
            return SeqCollection.of(this.backer.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.backer.entrySet();
        }

        @Override
        public SeqSet<Map.Entry<K, V>> seqEntrySet() {
            return SeqSet.of(this.backer.entrySet());
        }

        @Override
        public <A, B> SeqMap<A, B> newForMapping() {
            if (this.backer instanceof TreeMap) {
                return new Proxy(new TreeMap());
            }
            if (this.backer instanceof ConcurrentHashMap) {
                return new Proxy(new ConcurrentHashMap(this.backer.size()));
            }
            return new LinkedSeqMap(this.backer.size());
        }

        @Override
        public int size() {
            return this.backer.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backer.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.backer.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.backer.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.backer.get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.backer.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.backer.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.backer.putAll(m);
        }

        @Override
        public void clear() {
            this.backer.clear();
        }

        public String toString() {
            return this.backer.toString();
        }
    }
}

