/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolray.seq;

import com.github.wolray.seq.ItrSeq;
import com.github.wolray.seq.ItrUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;

public interface SizedSeq<T>
extends ItrSeq<T> {
    public int size();

    public boolean isEmpty();

    @Override
    default public SizedSeq<T> cache() {
        return this;
    }

    @Override
    default public void consume(Consumer<T> consumer, int n, Consumer<T> substitute) {
        if (n >= this.size()) {
            this.consume(substitute);
        } else {
            ItrSeq.super.consume(consumer, n, substitute);
        }
    }

    @Override
    default public int count() {
        return this.size();
    }

    @Override
    default public ItrSeq<T> drop(int n) {
        return n >= this.size() ? Collections::emptyIterator : ItrSeq.super.drop(n);
    }

    @Override
    default public <E> SizedSeq<E> map(final Function<T, E> function) {
        return new SizedSeq<E>(){

            @Override
            public Iterator<E> iterator() {
                return ItrUtil.map(SizedSeq.this.iterator(), function);
            }

            @Override
            public int size() {
                return SizedSeq.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SizedSeq.this.isEmpty();
            }

            @Override
            public SizedSeq<E> cache() {
                return this.toList();
            }
        };
    }

    @Override
    default public <E> ItrSeq<E> map(Function<T, E> function, int n, Function<T, E> substitute) {
        if (n >= this.size()) {
            return this.map((Function)substitute);
        }
        return ItrSeq.super.map((Function)function, n, (Function)substitute);
    }

    @Override
    default public int sizeOrDefault() {
        return this.size();
    }

    @Override
    default public ItrSeq<T> take(int n) {
        return n >= this.size() ? this : ItrSeq.super.take(n);
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

